﻿Imports System.Windows.Forms.DataVisualization.Charting

Public Class Form1

    Private Const PHY_CYCLE As Integer = 23
    Private Const EMO_CYCLE As Integer = 28
    Private Const INT_CYCLE As Integer = 33
    Private Const INTUITION_CYCLE As Integer = 38
    Private Const AESTHETIC_CYCLE As Integer = 43
    Private Const AWARE_CYCLE As Integer = 48
    Private Const SPIRITUAL_CYCLE As Integer = 53

    Private Sub btnGenerate_Click(sender As Object, e As EventArgs) Handles btnGenerate.Click

        Dim birth As Date = dtpBirthdate.Value
        Dim target As Date = dtpTargetDate.Value

        Dim daysPast As Integer = (target - birth).Days

        ' Setup chart
        SetupChart()

        ' Plot 15 days before to 15 days after target date
        Dim startDate As Date = target.AddDays(-15)
        Dim endDate As Date = target.AddDays(15)

        Dim d As Date = startDate
        While d <= endDate

            Dim x As Double = (d - birth).Days

            Dim physical = Math.Sin(2 * Math.PI * x / PHY_CYCLE)
            Dim emotional = Math.Sin(2 * Math.PI * x / EMO_CYCLE)
            Dim intellectual = Math.Sin(2 * Math.PI * x / INT_CYCLE)
            Dim intuition = Math.Sin(2 * Math.PI * x / INTUITION_CYCLE)
            Dim aesthetic = Math.Sin(2 * Math.PI * x / AESTHETIC_CYCLE)
            Dim awareness = Math.Sin(2 * Math.PI * x / AWARE_CYCLE)
            Dim spiritual = Math.Sin(2 * Math.PI * x / SPIRITUAL_CYCLE)
            Dim wellbeing = (physical + emotional + intellectual + intuition + aesthetic + awareness + spiritual) / 7.0

            chartBiorhythm.Series("Physical").Points.AddXY(d, physical)
            chartBiorhythm.Series("Emotional").Points.AddXY(d, emotional)
            chartBiorhythm.Series("Intellectual").Points.AddXY(d, intellectual)
            chartBiorhythm.Series("Intuition").Points.AddXY(d, intuition)
            chartBiorhythm.Series("Aesthetic").Points.AddXY(d, aesthetic)
            chartBiorhythm.Series("Awareness").Points.AddXY(d, awareness)
            chartBiorhythm.Series("Spiritual").Points.AddXY(d, spiritual)
            chartBiorhythm.Series("WellBeing").Points.AddXY(d, wellbeing)

            d = d.AddDays(1)
        End While

        ' Add vertical marker at selected date
        AddTargetMarker(target)

        ' Compute today's values
        Dim pToday = Math.Sin(2 * Math.PI * daysPast / PHY_CYCLE)
        Dim eToday = Math.Sin(2 * Math.PI * daysPast / EMO_CYCLE)
        Dim iToday = Math.Sin(2 * Math.PI * daysPast / INT_CYCLE)
        Dim inToday = Math.Sin(2 * Math.PI * daysPast / INTUITION_CYCLE)
        Dim aToday = Math.Sin(2 * Math.PI * daysPast / AESTHETIC_CYCLE)
        Dim awToday = Math.Sin(2 * Math.PI * daysPast / AWARE_CYCLE)
        Dim sToday = Math.Sin(2 * Math.PI * daysPast / SPIRITUAL_CYCLE)
        Dim wbToday = (pToday + eToday + iToday + inToday + aToday + awToday + sToday) / 7.0

        Dim criticalList As String = ""
        If Math.Abs(pToday) < 0.05 Then criticalList &= "Physical "
        If Math.Abs(eToday) < 0.05 Then criticalList &= "Emotional "
        If Math.Abs(iToday) < 0.05 Then criticalList &= "Intellectual "
        If Math.Abs(inToday) < 0.05 Then criticalList &= "Intuition "
        If Math.Abs(aToday) < 0.05 Then criticalList &= "Aesthetic "
        If Math.Abs(awToday) < 0.05 Then criticalList &= "Awareness "
        If Math.Abs(sToday) < 0.05 Then criticalList &= "Spiritual "

        lblOutput.Text =
            $"Date: {target.ToShortDateString()}" & vbCrLf &
            $"Physical: {Math.Round(pToday, 3)}" & vbCrLf &
            $"Emotional: {Math.Round(eToday, 3)}" & vbCrLf &
            $"Intellectual: {Math.Round(iToday, 3)}" & vbCrLf &
            $"Intuition: {Math.Round(inToday, 3)}" & vbCrLf &
            $"Aesthetic: {Math.Round(aToday, 3)}" & vbCrLf &
            $"Awareness: {Math.Round(awToday, 3)}" & vbCrLf &
            $"Spiritual: {Math.Round(sToday, 3)}" & vbCrLf &
            $"Well-Being Index: {Math.Round(wbToday, 3)}" & vbCrLf &
            If(criticalList <> "", $"CRITICAL: {criticalList}", "No critical cycle today")

        BuildMonthCalendar()
        PrintAsciiCalendar()

        lblOutput.Text = lblOutput.Text + vbCrLf + vbCrLf + GetUpcomingCriticalDays()
    End Sub

    Private Sub SetupChart()

        chartBiorhythm.Series.Clear()
        chartBiorhythm.ChartAreas(0).AxisX.LabelStyle.Format = "MM/dd"
        chartBiorhythm.ChartAreas(0).AxisY.Minimum = -1.2
        chartBiorhythm.ChartAreas(0).AxisY.Maximum = 1.2
        chartBiorhythm.ChartAreas(0).AxisY.Interval = 0.5

        ' Add the three series
        CreateSeries("Physical", Color.Red)
        CreateSeries("Emotional", Color.Blue)
        CreateSeries("Intellectual", Color.Green)
        CreateSeries("Intuition", Color.Purple)
        CreateSeries("Aesthetic", Color.Goldenrod)
        CreateSeries("Awareness", Color.Brown)
        CreateSeries("Spiritual", Color.DarkCyan)
        CreateSeries("WellBeing", Color.Black)
        chartBiorhythm.Series("WellBeing").BorderDashStyle = ChartDashStyle.Dot
        chartBiorhythm.Series("WellBeing").BorderWidth = 2

    End Sub

    Private Sub CreateSeries(name As String, color As Color)
        Dim s As New Series(name)
        s.ChartType = SeriesChartType.Line
        s.BorderWidth = 2
        s.Color = color
        s.XValueType = ChartValueType.Date
        chartBiorhythm.Series.Add(s)
    End Sub

    Private Sub AddTargetMarker(target As Date)

        Dim ca = chartBiorhythm.ChartAreas(0)
        Dim strip As New StripLine()

        strip.Interval = 0
        strip.BackColor = Color.FromArgb(60, Color.Black)
        strip.StripWidth = 0.15
        strip.IntervalOffset = target.ToOADate()
        strip.Text = "Selected Date"
        strip.TextAlignment = StringAlignment.Center
        strip.ForeColor = Color.Black
        strip.Font = New Font("Arial", 8, FontStyle.Bold)

        ca.AxisX.StripLines.Add(strip)

    End Sub

    Private Sub BuildMonthCalendar()

        Dim birth As Date = dtpBirthdate.Value

        Dim firstDay As New Date(dtpTargetDate.Value.Year,
                             dtpTargetDate.Value.Month, 1)

        ' Setup the grid
        dgvMonth.Columns.Clear()
        dgvMonth.Rows.Clear()

        For i = 1 To 7
            If i = 1 Then
                dgvMonth.Columns.Add("col" & i.ToString(),
            System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat.AbbreviatedDayNames(0))
            Else
                dgvMonth.Columns.Add("col" & i.ToString(),
            System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat.AbbreviatedDayNames((i - 1) Mod 7))
            End If
        Next

        dgvMonth.RowTemplate.Height = 32

        ' Find first weekday position
        Dim startCol As Integer = CInt(firstDay.DayOfWeek)

        Dim curRow As Integer = dgvMonth.Rows.Add()
        Dim curCol As Integer = startCol

        Dim d As Date = firstDay
        Dim lastDay As Integer = Date.DaysInMonth(firstDay.Year, firstDay.Month)

        For day = 1 To lastDay

            Dim daysPast As Integer = (d - birth).Days
            Dim P = Math.Sin(2 * Math.PI * daysPast / PHY_CYCLE)
            Dim E = Math.Sin(2 * Math.PI * daysPast / EMO_CYCLE)
            Dim I = Math.Sin(2 * Math.PI * daysPast / INT_CYCLE)
            Dim INN = Math.Sin(2 * Math.PI * daysPast / INTUITION_CYCLE)
            Dim critINN = (Math.Abs(INN) < 0.03)
            Dim A = Math.Sin(2 * Math.PI * daysPast / AESTHETIC_CYCLE)
            Dim critA = (Math.Abs(A) < 0.03)
            Dim AW = Math.Sin(2 * Math.PI * daysPast / AWARE_CYCLE)
            Dim critAW = (Math.Abs(AW) < 0.03)
            Dim S = Math.Sin(2 * Math.PI * daysPast / SPIRITUAL_CYCLE)
            Dim critS = (Math.Abs(S) < 0.03)

            Dim critP = (Math.Abs(P) < 0.03)
            Dim critE = (Math.Abs(E) < 0.03)
            Dim critI = (Math.Abs(I) < 0.03)

            Dim cellIcon As String = ""
            Dim bg As Color = Color.White

            Dim critCount As Integer = 0
            If critP Then critCount += 1 : cellIcon &= "🔴"
            If critE Then critCount += 1 : cellIcon &= "🔵"
            If critI Then critCount += 1 : cellIcon &= "🟢"
            If critINN Then critCount += 1 : cellIcon &= "🟣"
            If critA Then critCount += 1 : cellIcon &= "🟡"
            If critAW Then critCount += 1 : cellIcon &= "🟤"
            If critS Then critCount += 1 : cellIcon &= "🔶"

            If critCount = 2 Then
                cellIcon = "⭐ " & cellIcon
            ElseIf critCount >= 3 Then
                cellIcon = "💥"
                bg = Color.LightCoral
            End If

            ''Dim bg As Color = Color.White

            If critCount = 1 Then
                If critP Then bg = Color.LightCoral
                If critE Then bg = Color.LightBlue
                If critI Then bg = Color.LightGreen
                If critINN Then bg = Color.MediumPurple
                If critA Then bg = Color.Gold
            ElseIf critCount = 2 Then
                bg = Color.LightGray ' Two-cycle critical
            ElseIf critCount >= 3 Then
                bg = Color.OrangeRed ' Three or more
            End If

            dgvMonth.Rows(curRow).Cells(curCol).Style.BackColor = bg

            dgvMonth.Rows(curRow).Cells(curCol).Value = day & " " & cellIcon

            dgvMonth.Rows(curRow).Cells(curCol).Style.BackColor = bg

            ' Next day
            curCol += 1
            If curCol > 6 Then
                curRow = dgvMonth.Rows.Add()
                curCol = 0
            End If

            d = d.AddDays(1)
        Next

    End Sub

    Private Sub PrintAsciiCalendar()

        Dim birth As Date = dtpBirthdate.Value
        Dim shown As New Date(dtpTargetDate.Value.Year,
                          dtpTargetDate.Value.Month, 1)

        Dim sb As New System.Text.StringBuilder()

        sb.AppendLine(shown.ToString("MMMM yyyy"))
        sb.AppendLine("Su Mo Tu We Th Fr Sa")

        Dim startCol As Integer = CInt(shown.DayOfWeek)
        sb.Append(New String(" "c, startCol * 3))

        Dim d As Date = shown
        Dim daysInMonth = Date.DaysInMonth(shown.Year, shown.Month)

        For day = 1 To daysInMonth

            Dim daysPast As Integer = (d - birth).Days
            Dim P = Math.Sin(2 * Math.PI * daysPast / PHY_CYCLE)
            Dim E = Math.Sin(2 * Math.PI * daysPast / EMO_CYCLE)
            Dim I = Math.Sin(2 * Math.PI * daysPast / INT_CYCLE)
            Dim INN = Math.Sin(2 * Math.PI * daysPast / INTUITION_CYCLE)
            Dim A = Math.Sin(2 * Math.PI * daysPast / AESTHETIC_CYCLE)
            Dim AW = Math.Sin(2 * Math.PI * daysPast / AWARE_CYCLE)
            Dim S = Math.Sin(2 * Math.PI * daysPast / SPIRITUAL_CYCLE)

            Dim critCount As Integer =
    (If(Math.Abs(P) < 0.03, 1, 0)) +
    (If(Math.Abs(E) < 0.03, 1, 0)) +
    (If(Math.Abs(I) < 0.03, 1, 0)) +
    (If(Math.Abs(INN) < 0.03, 1, 0)) +
    (If(Math.Abs(A) < 0.03, 1, 0)) +
    (If(Math.Abs(AW) < 0.03, 1, 0)) +
    (If(Math.Abs(S) < 0.03, 1, 0))

            Dim marker As String =
    If(critCount >= 3, "!",
        If(critCount = 2, "*",
            If(critCount = 1, "+", " ")))

            sb.Append(day.ToString().PadLeft(2) & marker & " ")

            If (startCol Mod 7) = 6 Then sb.AppendLine()
            startCol += 1

            d = d.AddDays(1)
        Next

        txtASCII.Text = sb.ToString()

    End Sub

    Private Function GetUpcomingCriticalDays() As String
        Dim birth As Date = dtpBirthdate.Value
        Dim startDate As Date = Date.Today
        Dim endDate As Date = Date.Today.AddDays(30)

        Dim sb As New System.Text.StringBuilder()
        sb.AppendLine("UPCOMING CRITICAL DAYS (Next 30 Days):")
        sb.AppendLine("---------------------------------------")

        Dim d As Date = startDate

        While d <= endDate
            Dim daysPast = (d - birth).Days

            Dim P = Math.Sin(2 * Math.PI * daysPast / PHY_CYCLE)
            Dim E = Math.Sin(2 * Math.PI * daysPast / EMO_CYCLE)
            Dim I = Math.Sin(2 * Math.PI * daysPast / INT_CYCLE)
            Dim INN = Math.Sin(2 * Math.PI * daysPast / INTUITION_CYCLE)
            Dim A = Math.Sin(2 * Math.PI * daysPast / AESTHETIC_CYCLE)
            Dim AW = Math.Sin(2 * Math.PI * daysPast / AWARE_CYCLE)
            Dim S = Math.Sin(2 * Math.PI * daysPast / SPIRITUAL_CYCLE)

            Dim critList As New List(Of String)

            If Math.Abs(P) < 0.03 Then critList.Add("Physical")
            If Math.Abs(E) < 0.03 Then critList.Add("Emotional")
            If Math.Abs(I) < 0.03 Then critList.Add("Intellectual")
            If Math.Abs(INN) < 0.03 Then critList.Add("Intuition")
            If Math.Abs(A) < 0.03 Then critList.Add("Aesthetic")
            If Math.Abs(AW) < 0.03 Then critList.Add("Awareness")
            If Math.Abs(S) < 0.03 Then critList.Add("Spiritual")

            If critList.Count > 0 Then
                Dim level As String =
                If(critList.Count = 1, "Single Critical",
                If(critList.Count = 2, "Double Critical",
                "MULTI Critical!"))

                sb.AppendLine($"{d.ToShortDateString()}  → {level}: {String.Join(", ", critList)}")
            End If

            d = d.AddDays(1)
        End While

        Return sb.ToString()
    End Function

End Class

