﻿Public Class Form1

    Private bmp1 As Bitmap
    Private bmp2 As Bitmap

    Private clusters As New List(Of List(Of Point))

    Private Sub btnLoad1_Click(sender As Object, e As EventArgs) Handles btnLoad1.Click
        Dim ofd As New OpenFileDialog()
        If ofd.ShowDialog() = DialogResult.OK Then
            bmp1 = New Bitmap(ofd.FileName)
            pic1.Image = bmp1
        End If
    End Sub

    Private Sub btnLoad2_Click(sender As Object, e As EventArgs) Handles btnLoad2.Click
        Dim ofd As New OpenFileDialog()
        If ofd.ShowDialog() = DialogResult.OK Then
            bmp2 = New Bitmap(ofd.FileName)
            pic2.Image = bmp2
        End If
    End Sub

    Private Sub btnCompare_Click(sender As Object, e As EventArgs) Handles btnCompare.Click
        If bmp1 Is Nothing OrElse bmp2 Is Nothing Then
            MessageBox.Show("Please load both images!")
            Return
        End If

        If bmp1.Width <> bmp2.Width OrElse bmp1.Height <> bmp2.Height Then
            MessageBox.Show("Images must be the same size.")
            Return
        End If

        Dim result As New Bitmap(bmp1.Width, bmp1.Height)
        Dim diffCount As Integer = 0

        For y As Integer = 0 To bmp1.Height - 1
            For x As Integer = 0 To bmp1.Width - 1

                Dim c1 As Color = bmp1.GetPixel(x, y)
                Dim c2 As Color = bmp2.GetPixel(x, y)

                'Compare pixels
                If Math.Abs(CInt(c1.R) - CInt(c2.R)) > 20 OrElse
                   Math.Abs(CInt(c1.G) - CInt(c2.G)) > 20 OrElse
                   Math.Abs(CInt(c1.B) - CInt(c2.B)) > 20 Then

                    'Highlight difference (red)
                    result.SetPixel(x, y, Color.Red)
                    diffCount += 1
                Else
                    'Copy original pixel
                    result.SetPixel(x, y, c1)
                End If

            Next
        Next

        picResult.Image = result

        MessageBox.Show("Differences found: " & diffCount)
    End Sub

    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        If bmp1 Is Nothing OrElse bmp2 Is Nothing Then
            MessageBox.Show("Please load both images!")
            Return
        End If

        If bmp1.Width <> bmp2.Width OrElse bmp1.Height <> bmp2.Height Then
            MessageBox.Show("Images must be the same size.")
            Return
        End If

        Dim w As Integer = bmp1.Width
        Dim h As Integer = bmp1.Height
        Dim sensitivity As Integer = tbSensitivity.Value

        lblSensitivityValue.Text = sensitivity.ToString()

        Dim diffMap(h - 1, w - 1) As Boolean

        '=== STEP 1: Create difference map ==========================
        For y As Integer = 0 To h - 1
            For x As Integer = 0 To w - 1

                Dim c1 = bmp1.GetPixel(x, y)
                Dim c2 = bmp2.GetPixel(x, y)

                If Math.Abs(CInt(c1.R) - CInt(c2.R)) > sensitivity OrElse
               Math.Abs(CInt(c1.G) - CInt(c2.G)) > sensitivity OrElse
               Math.Abs(CInt(c1.B) - CInt(c2.B)) > sensitivity Then

                    diffMap(y, x) = True
                End If

            Next
        Next

        '=== STEP 2: Flood fill clusters ============================
        Dim visited(h - 1, w - 1) As Boolean
        clusters = New List(Of List(Of Point))

        Dim directions() As Point = {
        New Point(1, 0), New Point(-1, 0),
        New Point(0, 1), New Point(0, -1)
    }

        For y As Integer = 0 To h - 1
            For x As Integer = 0 To w - 1

                If diffMap(y, x) AndAlso Not visited(y, x) Then

                    Dim queue As New Queue(Of Point)
                    Dim cluster As New List(Of Point)

                    queue.Enqueue(New Point(x, y))
                    visited(y, x) = True

                    While queue.Count > 0
                        Dim p = queue.Dequeue()
                        cluster.Add(p)

                        For Each d In directions
                            Dim nx = p.X + d.X
                            Dim ny = p.Y + d.Y

                            If nx >= 0 AndAlso ny >= 0 AndAlso nx < w AndAlso ny < h Then
                                If diffMap(ny, nx) AndAlso Not visited(ny, nx) Then
                                    visited(ny, nx) = True
                                    queue.Enqueue(New Point(nx, ny))
                                End If
                            End If
                        Next
                    End While

                    clusters.Add(cluster)
                End If

            Next
        Next

        '=== STEP 3: Identify the 2 largest clusters =================
        Dim biggest = clusters _
        .OrderByDescending(Function(c) c.Count) _
        .Take(2) _
        .ToList()

        '=== STEP 4: Draw result =====================================
        Dim result As New Bitmap(bmp1)
        Dim rand As New Random()

        Using g As Graphics = Graphics.FromImage(result)
            g.SmoothingMode = Drawing2D.SmoothingMode.AntiAlias

            Dim font As New Font("Arial", 20, FontStyle.Bold)

            For i As Integer = 0 To clusters.Count - 1
                Dim cluster = clusters(i)

                Dim minX = cluster.Min(Function(p) p.X)
                Dim minY = cluster.Min(Function(p) p.Y)
                Dim maxX = cluster.Max(Function(p) p.X)
                Dim maxY = cluster.Max(Function(p) p.Y)

                Dim rect As New Rectangle(minX, minY, maxX - minX, maxY - minY)
                rect.Inflate(6, 6)

                Dim col As Color = Color.FromArgb(255,
                rand.Next(60, 255),
                rand.Next(60, 255),
                rand.Next(60, 255)
            )

                'Circle for the cluster
                g.DrawEllipse(New Pen(col, 2), rect)

                'Label next to circle
                g.DrawString($"{i + 1}", font, Brushes.Black, rect.X, rect.Y - 25)
            Next

            'Bold outlines for the largest clusters
            For Each cluster In biggest
                Dim minX = cluster.Min(Function(p) p.X)
                Dim minY = cluster.Min(Function(p) p.Y)
                Dim maxX = cluster.Max(Function(p) p.X)
                Dim maxY = cluster.Max(Function(p) p.Y)

                Dim rect As New Rectangle(minX, minY, maxX - minX, maxY - minY)
                rect.Inflate(12, 12)

                g.DrawEllipse(New Pen(Color.Red, 6), rect)
            Next

        End Using

        picResult.Image = result

        MessageBox.Show($"Clusters found: {clusters.Count}. Largest two highlighted.")
    End Sub

    Private Sub tbSensitivity_Scroll(sender As Object, e As EventArgs) Handles tbSensitivity.Scroll
        lblSensitivityValue.Text = tbSensitivity.Value.ToString()
    End Sub

    Private Sub Button2_Click(sender As Object, e As EventArgs) Handles Button2.Click
        If bmp1 Is Nothing OrElse bmp2 Is Nothing Then
            MessageBox.Show("Please load both images!")
            Return
        End If

        If bmp1.Width <> bmp2.Width OrElse bmp1.Height <> bmp2.Height Then
            MessageBox.Show("Images must be the same size.")
            Return
        End If

        Dim w As Integer = bmp1.Width
        Dim h As Integer = bmp1.Height

        Dim sensitivity As Integer = tbSensitivity.Value
        Dim MinClusterSize As Integer = tbMinClusterSize.Value
        Dim MergeDistance As Integer = tbMergeDistance.Value

        lblSensitivityValue.Text = sensitivity.ToString()
        lblMinClusterValue.Text = MinClusterSize.ToString()
        lblMergeDistanceValue.Text = MergeDistance.ToString()

        Dim diffMap(h - 1, w - 1) As Boolean

        '=== STEP 1: Create difference map ==========================
        For y As Integer = 0 To h - 1
            For x As Integer = 0 To w - 1

                Dim c1 = bmp1.GetPixel(x, y)
                Dim c2 = bmp2.GetPixel(x, y)

                If Math.Abs(CInt(c1.R) - CInt(c2.R)) > sensitivity OrElse
               Math.Abs(CInt(c1.G) - CInt(c2.G)) > sensitivity OrElse
               Math.Abs(CInt(c1.B) - CInt(c2.B)) > sensitivity Then
                    diffMap(y, x) = True
                End If

            Next
        Next

        '=== STEP 2: Flood fill clusters ============================
        Dim visited(h - 1, w - 1) As Boolean
        clusters = New List(Of List(Of Point))

        Dim directions() As Point = {
        New Point(1, 0), New Point(-1, 0),
        New Point(0, 1), New Point(0, -1)
    }

        For y As Integer = 0 To h - 1
            For x As Integer = 0 To w - 1
                If diffMap(y, x) AndAlso Not visited(y, x) Then

                    Dim queue As New Queue(Of Point)
                    Dim cluster As New List(Of Point)

                    queue.Enqueue(New Point(x, y))
                    visited(y, x) = True

                    While queue.Count > 0
                        Dim p = queue.Dequeue()
                        cluster.Add(p)

                        For Each d In directions
                            Dim nx = p.X + d.X
                            Dim ny = p.Y + d.Y

                            If nx >= 0 AndAlso ny >= 0 AndAlso nx < w AndAlso ny < h Then
                                If diffMap(ny, nx) AndAlso Not visited(ny, nx) Then
                                    visited(ny, nx) = True
                                    queue.Enqueue(New Point(nx, ny))
                                End If
                            End If
                        Next
                    End While

                    ' Noise filtering
                    If cluster.Count >= MinClusterSize Then
                        clusters.Add(cluster)
                    End If
                End If
            Next
        Next

        '=== STEP 3: Merge clusters close to each other ==============
        Dim merged As Boolean = True

        While merged
            merged = False

            For i As Integer = 0 To clusters.Count - 2
                For j As Integer = i + 1 To clusters.Count - 1

                    Dim r1 = GetBoundingBox(clusters(i))
                    Dim r2 = GetBoundingBox(clusters(j))

                    If AreRectsClose(r1, r2, MergeDistance) Then
                        clusters(i).AddRange(clusters(j))
                        clusters.RemoveAt(j)
                        merged = True
                        Exit For
                    End If
                Next
                If merged Then Exit For
            Next
        End While

        '=== STEP 4: Identify largest 2 clusters ======================
        Dim biggest = clusters _
        .OrderByDescending(Function(c) c.Count) _
        .Take(2) _
        .ToList()

        '=== STEP 5: Draw results ====================================
        Dim result As New Bitmap(bmp1)
        Dim rand As New Random()

        Using g As Graphics = Graphics.FromImage(result)
            g.SmoothingMode = Drawing2D.SmoothingMode.AntiAlias
            Dim font As New Font("Arial", 22, FontStyle.Bold)

            For i As Integer = 0 To clusters.Count - 1
                Dim cluster = clusters(i)
                Dim r = GetBoundingBox(cluster)
                r.Inflate(6, 6)

                Dim col As Color = Color.FromArgb(255,
            rand.Next(80, 255),
            rand.Next(80, 255),
            rand.Next(80, 255)
        )

                If chkShowBoundingBoxes.Checked Then
                    ' Draw RECTANGLE instead of circle
                    g.DrawRectangle(New Pen(col, 3), r)
                Else
                    ' Draw circle/ellipse
                    g.DrawEllipse(New Pen(col, 3), r)
                End If

                ' Draw label (optional)
                If chkShowLabels.Checked Then
                    g.DrawString((i + 1).ToString(), font, Brushes.Black, r.X, r.Y - 30)
                End If
            Next

            ' Highlight the biggest two clusters
            For Each cluster In biggest
                Dim r = GetBoundingBox(cluster)
                r.Inflate(12, 12)

                If chkShowBoundingBoxes.Checked Then
                    g.DrawRectangle(New Pen(Color.Red, 6), r)
                Else
                    g.DrawEllipse(New Pen(Color.Red, 6), r)
                End If
            Next

        End Using

        picResult.Image = result

        MessageBox.Show($"Clusters after filtering + merging: {clusters.Count}")
    End Sub

    Private Sub tbMinClusterSize_Scroll(sender As Object, e As EventArgs) Handles tbMinClusterSize.Scroll
        lblMinClusterValue.Text = tbMinClusterSize.Value.ToString()
    End Sub

    Private Sub tbMergeDistance_Scroll(sender As Object, e As EventArgs) Handles tbMergeDistance.Scroll
        lblMergeDistanceValue.Text = tbMergeDistance.Value.ToString()
    End Sub

    Private Function GetBoundingBox(cluster As List(Of Point)) As Rectangle
        Dim minX = cluster.Min(Function(p) p.X)
        Dim minY = cluster.Min(Function(p) p.Y)
        Dim maxX = cluster.Max(Function(p) p.X)
        Dim maxY = cluster.Max(Function(p) p.Y)
        Return New Rectangle(minX, minY, maxX - minX, maxY - minY)
    End Function

    Private Function AreRectsClose(r1 As Rectangle, r2 As Rectangle, distance As Integer) As Boolean
        r1.Inflate(distance, distance)
        Return r1.IntersectsWith(r2)
    End Function

    Private Sub btnExportClusters_Click(sender As Object, e As EventArgs) Handles btnExportClusters.Click
        If clusters Is Nothing OrElse clusters.Count = 0 Then
            MessageBox.Show("No clusters to export.")
            Return
        End If

        Dim dlg As New SaveFileDialog()
        dlg.Filter = "JSON|*.json|CSV|*.csv|XML|*.xml"
        dlg.FileName = "clusters"

        If dlg.ShowDialog() <> DialogResult.OK Then Return

        Select Case IO.Path.GetExtension(dlg.FileName).ToLower()
            Case ".json"
                ExportClustersJSON(dlg.FileName)
            Case ".csv"
                ExportClustersCSV(dlg.FileName)
            Case ".xml"
                ExportClustersXML(dlg.FileName)
        End Select

        MessageBox.Show("Cluster export complete.")
    End Sub

    Private Sub ExportClustersJSON(path As String)
        Dim sb As New System.Text.StringBuilder()

        sb.AppendLine("[")
        For i As Integer = 0 To clusters.Count - 1
            Dim c = clusters(i)
            Dim bb = GetBoundingBox(c)

            sb.AppendLine("  {")
            sb.AppendLine($"    ""id"": {i + 1},")
            sb.AppendLine($"    ""pixelCount"": {c.Count},")
            sb.AppendLine($"    ""boundingBox"": {{ ""x"": {bb.X}, ""y"": {bb.Y}, ""w"": {bb.Width}, ""h"": {bb.Height} }},")

            sb.AppendLine("    ""points"": [")
            For Each p In c
                sb.AppendLine($"      {{ ""x"": {p.X}, ""y"": {p.Y} }},")
            Next
            sb.AppendLine("    ]")

            sb.AppendLine("  },")
        Next
        sb.AppendLine("]")

        IO.File.WriteAllText(path, sb.ToString())
    End Sub

    Private Sub ExportClustersCSV(path As String)
        Using sw As New IO.StreamWriter(path)
            sw.WriteLine("ClusterID,PixelCount,X,Y,Width,Height")

            For i As Integer = 0 To clusters.Count - 1
                Dim bb = GetBoundingBox(clusters(i))
                sw.WriteLine($"{i + 1},{clusters(i).Count},{bb.X},{bb.Y},{bb.Width},{bb.Height}")
            Next
        End Using
    End Sub

    Private Sub ExportClustersXML(path As String)
        Dim sw As New IO.StreamWriter(path)
        sw.WriteLine("<Clusters>")

        For i As Integer = 0 To clusters.Count - 1
            Dim c = clusters(i)
            Dim bb = GetBoundingBox(c)

            sw.WriteLine($"  <Cluster id=""{i + 1}"" pixelCount=""{c.Count}"">")
            sw.WriteLine($"    <BoundingBox x=""{bb.X}"" y=""{bb.Y}"" width=""{bb.Width}"" height=""{bb.Height}""/>")
            sw.WriteLine("    <Points>")

            For Each p In c
                sw.WriteLine($"      <Point x=""{p.X}"" y=""{p.Y}""/>")
            Next

            sw.WriteLine("    </Points>")
            sw.WriteLine("  </Cluster>")
        Next

        sw.WriteLine("</Clusters>")
        sw.Close()
    End Sub

End Class
