﻿' VB.NET WinForms version of TECHNOSPHERE
' Create a new Windows Forms App (.NET Framework)
' Replace Form1.vb with this code

Imports System.Drawing
Imports System.Windows.Forms

Public Class Form1

    Const WorldWidth As Integer = 80
    Const WorldHeight As Integer = 20
    Const CellSize As Integer = 10

    Dim rng As New Random()

    Dim NameArr(100, 2) As String
    Dim Map(WorldWidth, WorldHeight) As Integer
    Dim Stats(100, 6) As Integer
    Dim Location(100, 2) As Integer
    Dim OldLocation(100, 2) As Integer

    Dim TotalDays As Integer = 0
    Dim FoodCheck As Integer = 0
    Dim hsex As Integer = 2
    Dim csex As Integer = 2

    Dim simTimer As New Timer()

    Public Sub New()
        InitializeComponent()
        Me.DoubleBuffered = True
        Me.ClientSize = New Size(WorldWidth * CellSize + 1, WorldHeight * CellSize + 40)
        Me.Text = "TECHNOSPHERE"

        InitWorld()

        simTimer.Interval = 100
        AddHandler simTimer.Tick, AddressOf UpdateWorld
        simTimer.Start()
    End Sub

    Sub InitWorld()
        For a = 1 To 100
            Dim x = rng.Next(1, WorldWidth + 1)
            Dim y = rng.Next(1, WorldHeight + 1)
            Location(a, 1) = x
            Location(a, 2) = y

            NameArr(a, 2) = If(rng.Next(0, 6) = 0, "C", "H")
            If NameArr(a, 2) = "H" Then Stats(a, 2) = 1
        Next
    End Sub

    Sub UpdateWorld(sender As Object, e As EventArgs)
        TotalDays += 1
        FoodCheck += 1
        Array.Clear(Map, 0, Map.Length)

        For a = 1 To 100

            If NameArr(a, 2) = "DEAD" Then Continue For

            OldLocation(a, 1) = Location(a, 1)
            OldLocation(a, 2) = Location(a, 2)

            Dim randy = rng.Next(0, 20)

            If NameArr(a, 2) <> "C" Then
                If randy < hsex Then
                    For b = 1 To 100
                        If NameArr(b, 2) = "H" Then MoveToward(a, b) : Exit For
                    Next
                Else
                    RandomMove(a)
                End If
            End If

            If NameArr(a, 2) = "C" Then
                If randy < csex Then
                    For b = 1 To 100
                        If NameArr(b, 2) = "C" Then MoveToward(a, b) : Exit For
                    Next
                Else
                    Dim hunt = rng.Next(0, 10)
                    If hunt < 2 Then
                        For b = 1 To 100
                            If NameArr(b, 2) = "H" Then MoveToward(a, b) : Exit For
                        Next
                    Else
                        RandomMove(a)
                    End If
                End If
            End If

            Location(a, 1) = Math.Max(1, Math.Min(WorldWidth, Location(a, 1)))
            Location(a, 2) = Math.Max(1, Math.Min(WorldHeight, Location(a, 2)))

            Dim x = Location(a, 1)
            Dim y = Location(a, 2)

            If Map(x, y) <> 0 AndAlso Map(x, y) <> a Then
                Dim t = Map(x, y)

                If NameArr(t, 2) = "H" AndAlso NameArr(a, 2) = "C" Then
                    NameArr(t, 2) = "DEAD"
                    Stats(a, 2) += 1
                End If

                If NameArr(t, 2) = NameArr(a, 2) AndAlso (NameArr(a, 2) = "H" Or NameArr(a, 2) = "C") Then
                    If Stats(a, 2) > Stats(a, 6) Then
                        Stats(a, 6) += 1
                        For b = 1 To 100
                            If NameArr(b, 2) = "DEAD" OrElse NameArr(b, 2) = "" Then
                                NameArr(b, 2) = NameArr(a, 2)
                                Exit For
                            End If
                        Next
                    End If
                End If

                If NameArr(t, 2) = "DEAD" Then
                    Stats(a, 2) += 1
                    NameArr(t, 2) = ""
                End If
            End If

            Map(x, y) = a
        Next

        If FoodCheck > 7 Then
            FoodCheck = 0
            For a = 1 To 100
                If NameArr(a, 2) = "C" AndAlso Stats(a, 6) >= Stats(a, 2) Then
                    NameArr(a, 2) = "DEAD"
                End If
            Next
        End If

        Me.Invalidate()
    End Sub

    Protected Overrides Sub OnPaint(e As PaintEventArgs)
        Dim g = e.Graphics
        g.Clear(Color.Black)

        For a = 1 To 100
            Dim x = Location(a, 1)
            Dim y = Location(a, 2)
            Dim rect As New Rectangle((x - 1) * CellSize, (y - 1) * CellSize + 20, CellSize, CellSize)

            Select Case NameArr(a, 2)
                Case "H" : g.FillEllipse(Brushes.White, rect)
                Case "C" : g.FillEllipse(Brushes.Red, rect)
                Case "DEAD" : g.FillRectangle(Brushes.Yellow, rect)
            End Select
        Next

        g.DrawString($"Days: {TotalDays}", Me.Font, Brushes.White, 5, 2)
    End Sub

    Sub MoveToward(a As Integer, b As Integer)
        If Location(b, 1) > Location(a, 1) Then Location(a, 1) += 1
        If Location(b, 1) < Location(a, 1) Then Location(a, 1) -= 1
        If Location(b, 2) > Location(a, 2) Then Location(a, 2) += 1
        If Location(b, 2) < Location(a, 2) Then Location(a, 2) -= 1
    End Sub

    Sub RandomMove(a As Integer)
        Location(a, 1) += rng.Next(-1, 2)
        Location(a, 2) += rng.Next(-1, 2)
    End Sub

End Class
