﻿Imports System

Module Technosphere

    Sub Main()

        Dim hsex As Integer = 2
        Dim csex As Integer = 2

        Dim rng As New Random()

        Console.Clear()

        Dim Name(100, 2) As String
        Dim Map(80, 20) As Integer
        Dim Creature(100, 4) As Integer
        Dim Stats(100, 6) As Integer
        Dim Activity(100, 2) As Integer
        Dim Days(100, 1) As Integer
        Dim Location(100, 2) As Integer
        Dim OldLocation(100, 2) As Integer

        Dim TotalDays As Integer = 0
        Dim FoodCheck As Integer = 0

        ' Header
        DrawHeader()

        ' Initialize creatures
        For a As Integer = 1 To 100
            Dim x As Integer = rng.Next(1, 81)
            Dim y As Integer = rng.Next(1, 21)

            Map(x, y) = a
            Location(a, 1) = x
            Location(a, 2) = y

            Name(a, 1) = "nameless"
            Dim s As String = If(rng.Next(0, 6) = 0, "C", "H")
            Name(a, 2) = s
            If s = "H" Then Stats(a, 2) = 1
        Next

        ' Draw initial map
        For x As Integer = 1 To 80
            For y As Integer = 1 To 20
                If Map(x, y) > 0 Then
                    Console.SetCursorPosition(x - 1, y + 1)
                    If Name(Map(x, y), 2) = "H" Then Console.Write("O")
                    If Name(Map(x, y), 2) = "C" Then Console.Write("*")
                End If
            Next
        Next

        ' ================= MAIN LOOP =================
        Do
            TotalDays += 1
            FoodCheck += 1
            Array.Clear(Map, 0, Map.Length)

            For a As Integer = 1 To 100

                If Name(a, 2) = "DEAD" Then
                    Console.SetCursorPosition(Location(a, 1) - 1, Location(a, 2) + 1)
                    Console.ForegroundColor = ConsoleColor.Yellow
                    Console.Write("#")
                    Console.ForegroundColor = ConsoleColor.White
                    Continue For
                End If

                OldLocation(a, 1) = Location(a, 1)
                OldLocation(a, 2) = Location(a, 2)

                Dim randy As Integer = rng.Next(0, 20)

                ' Herbivore behavior
                If Name(a, 2) <> "C" Then
                    If randy < hsex Then
                        For b As Integer = 1 To 100
                            If Name(b, 2) = "H" Then
                                MoveToward(a, b, Location)
                                Exit For
                            End If
                        Next
                    Else
                        RandomMove(a, Location, rng)
                    End If
                End If

                ' Carnivore behavior
                If Name(a, 2) = "C" Then
                    If randy < csex Then
                        For b As Integer = 1 To 100
                            If Name(b, 2) = "C" Then
                                MoveToward(a, b, Location)
                                Exit For
                            End If
                        Next
                    Else
                        Dim hunt As Integer = rng.Next(0, 10)
                        If hunt < 2 Then
                            For b As Integer = 1 To 100
                                If Name(b, 2) = "H" Then
                                    MoveToward(a, b, Location)
                                    Exit For
                                End If
                            Next
                        Else
                            RandomMove(a, Location, rng)
                        End If
                    End If
                End If

                ' Bounds
                Location(a, 1) = Math.Max(1, Math.Min(80, Location(a, 1)))
                Location(a, 2) = Math.Max(1, Math.Min(20, Location(a, 2)))

                Dim x As Integer = Location(a, 1)
                Dim y As Integer = Location(a, 2)

                If Map(x, y) <> 0 AndAlso Map(x, y) <> a Then
                    Dim t As Integer = Map(x, y)

                    If Name(t, 2) = "H" AndAlso Name(a, 2) = "C" Then
                        Name(t, 2) = "DEAD"
                        Stats(a, 2) += 1
                    End If

                    If Name(t, 2) = Name(a, 2) AndAlso (Name(a, 2) = "H" OrElse Name(a, 2) = "C") Then
                        If Stats(a, 2) > Stats(a, 6) Then
                            Stats(a, 6) += 1
                            For b As Integer = 1 To 100
                                If Name(b, 2) = "DEAD" OrElse Name(b, 2) = "" Then
                                    Name(b, 2) = Name(a, 2)
                                    Exit For
                                End If
                            Next
                        End If
                    End If

                    If Name(t, 2) = "DEAD" Then
                        Stats(a, 2) += 1
                        Name(t, 2) = ""
                    End If
                End If

                Map(x, y) = a

                Console.SetCursorPosition(OldLocation(a, 1) - 1, OldLocation(a, 2) + 1)
                Console.Write(" ")

                Console.SetCursorPosition(x - 1, y + 1)
                If Name(a, 2) = "H" Then Console.Write("O")
                If Name(a, 2) = "C" Then Console.Write("*")
                If Name(a, 2) = "DEAD" Then Console.Write("#")

            Next

            ' Count stats
            Dim C As Integer = 0, H As Integer = 0, D As Integer = 0, F As Integer = 0
            For a As Integer = 1 To 100
                Select Case Name(a, 2)
                    Case "C" : C += 1
                    Case "H" : H += 1
                    Case "DEAD" : D += 1
                    Case "" : F += 1
                End Select
            Next

            ' Starvation check
            If FoodCheck > 7 Then
                FoodCheck = 0
                For a As Integer = 1 To 100
                    If Name(a, 2) = "C" AndAlso Stats(a, 6) >= Stats(a, 2) Then
                        Name(a, 2) = "DEAD"
                    End If
                Next
            End If

            DrawHeader()

            Console.SetCursorPosition(0, 22)
            Console.Write($"Days {TotalDays}")
            Console.SetCursorPosition(15, 22)
            Console.Write($"C/vore(*) {C}")
            Console.SetCursorPosition(30, 22)
            Console.Write($"H/vore(O) {H}")
            Console.SetCursorPosition(46, 22)
            Console.Write($"Dead(#) {D}")
            Console.SetCursorPosition(60, 22)
            Console.Write($"Free {F}")
            Console.SetCursorPosition(70, 22)
            Console.Write($"Total {C + H + D + F}")

        Loop Until Console.KeyAvailable AndAlso Console.ReadKey(True).Key = ConsoleKey.Escape

    End Sub

    Sub MoveToward(a As Integer, b As Integer, loc(,) As Integer)
        If loc(b, 1) > loc(a, 1) Then loc(a, 1) += 1
        If loc(b, 1) < loc(a, 1) Then loc(a, 1) -= 1
        If loc(b, 2) > loc(a, 2) Then loc(a, 2) += 1
        If loc(b, 2) < loc(a, 2) Then loc(a, 2) -= 1
    End Sub

    Sub RandomMove(a As Integer, loc(,) As Integer, rng As Random)
        loc(a, 1) += rng.Next(-1, 2)
        loc(a, 2) += rng.Next(-1, 2)
    End Sub

    Sub DrawHeader()
        Console.ForegroundColor = ConsoleColor.Yellow
        Console.SetCursorPosition(0, 0)
        Console.Write(New String(" "c, 80))
        Console.SetCursorPosition(33, 0)
        Console.Write("TECHNOSPHERE")
        Console.ForegroundColor = ConsoleColor.White
    End Sub

End Module
