﻿Imports System.Globalization

Public Class Form1

    Dim MonthOffsets() As Integer = {0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334}

    Private Sub btnAnalyze_Click(sender As Object, e As EventArgs) Handles btnAnalyze.Click

        txtResults.Clear()

        ' ===== Input Validation =====
        If txtName1.Text.Trim() = "" OrElse txtName2.Text.Trim() = "" Then
            MessageBox.Show("Please enter both names.", "Input Error")
            Exit Sub
        End If

        Dim dob1 As Date, dob2 As Date

        If Not Date.TryParseExact(txtDOB1.Text, "MM/dd/yyyy", CultureInfo.InvariantCulture, DateTimeStyles.None, dob1) Then
            MessageBox.Show("Person One birthday must be MM/DD/YYYY.", "Input Error")
            Exit Sub
        End If

        If Not Date.TryParseExact(txtDOB2.Text, "MM/dd/yyyy", CultureInfo.InvariantCulture, DateTimeStyles.None, dob2) Then
            MessageBox.Show("Person Two birthday must be MM/DD/YYYY.", "Input Error")
            Exit Sub
        End If

        ' ===== Calculations =====
        Dim t1 = ComputeTotalDays(dob1)
        Dim t2 = ComputeTotalDays(dob2)
        Dim z = Math.Abs(t1 - t2)

        Dim p3 = Math.Abs(CInt(((z / 23.0) - Math.Floor(z / 23.0)) * 23))
        Dim s3 = Math.Abs(CInt(((z / 28.0) - Math.Floor(z / 28.0)) * 28))
        Dim c3 = Math.Abs(CInt(((z / 33.0) - Math.Floor(z / 33.0)) * 33))

        Dim p5 = Math.Abs(100 - ((2 * p3) * (100 / 23.0)))
        Dim s5 = Math.Abs(100 - ((2 * s3) * (100 / 28.0)))
        Dim c5 = Math.Abs(100 - ((2 * c3) * (100 / 33.0)))

        Dim avg = (p5 + s5 + c5) / 3

        ' ===== Output =====
        txtResults.AppendText("COMPATIBILITY ANALYSIS" & vbCrLf)
        txtResults.AppendText("----------------------" & vbCrLf & vbCrLf)

        txtResults.AppendText($"{txtName1.Text} was born on {dob1:MMMM dd, yyyy} ({dob1:dddd})" & vbCrLf)
        txtResults.AppendText($"{txtName2.Text} was born on {dob2:MMMM dd, yyyy} ({dob2:dddd})" & vbCrLf & vbCrLf)

        txtResults.AppendText($"PHYSICAL CYCLE (23-DAY):     {p5:F3}%" & vbCrLf)
        txtResults.AppendText($"SENSITIVITY CYCLE (28-DAY):  {s5:F3}%" & vbCrLf)
        txtResults.AppendText($"COGNITIVE CYCLE (33-DAY):    {c5:F3}%" & vbCrLf)
        txtResults.AppendText("                            --------" & vbCrLf)
        txtResults.AppendText($"AVERAGE COMPATIBILITY:      {avg:F3}%" & vbCrLf)

    End Sub

    Private Sub btnClear_Click(sender As Object, e As EventArgs) Handles btnClear.Click
        txtName1.Clear()
        txtDOB1.Clear()
        txtName2.Clear()
        txtDOB2.Clear()
        txtResults.Clear()
    End Sub

    ' === Original QBasic-Compatible Day Count Logic ===
    Private Function ComputeTotalDays(dob As Date) As Integer

        Dim y = dob.Year
        Dim m = dob.Month
        Dim d = dob.Day

        Dim Y1 = y - 1800
        Dim Q1 = Y1 \ 4
        Dim Q2 = Q1 \ 25
        Dim Q3 = (Y1 + 200) \ 400
        Dim K = 0

        If Q1 * 4 = Y1 AndAlso Q2 * 100 = Y1 AndAlso Q3 * 400 - 200 = Y1 Then
            K = 1
        End If

        Dim T = 365 * Y1 + Q1 - Q2 + Q3 - K
        T += MonthOffsets(m - 1) + d - 1

        If m >= 3 Then T += K
        If (Y1 Mod 4 = 0) AndAlso m <= 2 Then T -= 1

        Return T
    End Function

End Class
