﻿Imports System

Module CompatibilityAnalysis

    ' Shared variables to mimic QBasic globals
    Dim A(12) As Integer
    Dim T As Integer
    Dim J As Integer

    Sub Main()
        Console.Clear()

        ' Header
        Console.ForegroundColor = ConsoleColor.White
        Console.WriteLine("            C O M P A T A B I L I T Y")
        Console.WriteLine("                 A N A L Y S I S")
        Console.ForegroundColor = ConsoleColor.Gray
        Console.WriteLine()
        Console.WriteLine("By using the biorhythmic")
        Console.WriteLine("cycle theory, this program")
        Console.WriteLine("takes the birthdays of two")
        Console.WriteLine("individuals and calculates")
        Console.WriteLine("when they are compatible")
        Console.WriteLine("during their lifetime.")
        Console.WriteLine("It also gives the average")
        Console.WriteLine("compatibility percentage.")
        Console.WriteLine()
        Console.WriteLine("Press any key to continue...")
        Console.ReadKey(True)

        ' Month offsets
        Dim data() As Integer = {0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334}
        For i = 1 To 12
            A(i) = data(i - 1)
        Next

        Console.Clear()

        ' Person 1
        Console.Write("What is the name of person one (1): ")
        Dim name1 As String = Console.ReadLine()

        Console.Write("What is person one's birthday (MM,DD,YYYY): ")
        Dim p1 = Console.ReadLine().Split(","c)
        Dim m1 = Integer.Parse(p1(0))
        Dim d1 = Integer.Parse(p1(1))
        Dim y1 = Integer.Parse(p1(2))

        ComputeDate(m1, d1, y1)
        Dim total1 = T
        Dim dayOfWeek1 = J + 1

        ' Person 2
        Console.WriteLine()
        Console.Write("What is the name of person two (2): ")
        Dim name2 As String = Console.ReadLine()

        Console.Write("What is person two's birthday (MM,DD,YYYY): ")
        Dim p2 = Console.ReadLine().Split(","c)
        Dim m2 = Integer.Parse(p2(0))
        Dim d2 = Integer.Parse(p2(1))
        Dim y2 = Integer.Parse(p2(2))

        ComputeDate(m2, d2, y2)
        Dim total2 = T
        Dim dayOfWeek2 = J + 1

        ' Compatibility math
        Dim Z = Math.Abs(total1 - total2)

        Dim P3 = Math.Abs(CInt(((Z / 23.0) - Math.Floor(Z / 23.0)) * 23))
        Dim S3 = Math.Abs(CInt(((Z / 28.0) - Math.Floor(Z / 28.0)) * 28))
        Dim C3 = Math.Abs(CInt(((Z / 33.0) - Math.Floor(Z / 33.0)) * 33))

        Dim P5 = Math.Abs(100 - ((2 * P3) * (100 / 23.0)))
        Dim S5 = Math.Abs(100 - ((2 * S3) * (100 / 28.0)))
        Dim C5 = Math.Abs(100 - ((2 * C3) * (100 / 33.0)))

        Dim avg = (P5 + S5 + C5) / 3.0

        ' Output
        Console.Clear()
        Console.WriteLine("COMPATIBILITY ANALYSIS")
        Console.WriteLine("----------------------")
        Console.WriteLine()

        Console.Write($"{name1} was born on ")
        PrintMonth(m1)
        Console.WriteLine($"{d1}, {y1}. On a {DayName(dayOfWeek1)}.")

        Console.WriteLine()

        Console.Write($"{name2} was born on ")
        PrintMonth(m2)
        Console.WriteLine($"{d2}, {y2}. On a {DayName(dayOfWeek2)}.")

        Console.WriteLine()
        Console.WriteLine($"PHYSICAL CYCLE COMPATIBILITY (23-DAY) IS    {P5:F3}%")
        Console.WriteLine($"SENSITIVITY CYCLE COMPATIBILITY (28-DAY) IS {S5:F3}%")
        Console.WriteLine($"COGNITIVE CYCLE COMPATIBILITY (33-DAY) IS   {C5:F3}%")
        Console.WriteLine("                                            --------")
        Console.WriteLine($"AVERAGE COMPATIBILITY IS                    {avg:F3}%")

        Console.WriteLine()
        Console.WriteLine("Press any key to exit...")
        Console.ReadKey(True)
    End Sub

    ' === Date Calculation (former GOSUB 72) ===
    Sub ComputeDate(m As Integer, d As Integer, y As Integer)
        Dim Y1 = y - 1800
        Dim Q1 = Y1 \ 4
        Dim Q2 = Q1 \ 25
        Dim Q3 = (Y1 + 200) \ 400
        Dim K = 0

        If Q1 * 4 = Y1 AndAlso Q2 * 100 = Y1 AndAlso Q3 * 400 - 200 = Y1 Then
            K = 1
        End If

        T = 365 * Y1 + Q1 - Q2 + Q3 - K
        T += A(m) + d - 1

        If m >= 3 Then T += K
        If (Y1 Mod 4 = 0) AndAlso m <= 2 Then T -= 1

        J = T Mod 7
    End Sub

    Sub PrintMonth(m As Integer)
        Dim months() = {
            "JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE",
            "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"
        }
        Console.Write(months(m - 1) & " ")
    End Sub

    Function DayName(j As Integer) As String
        Dim days() = {
            "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY",
            "SATURDAY", "SUNDAY", "MONDAY"
        }
        Return days(j Mod 7)
    End Function

End Module
