﻿Imports System.IO

Public Class Form1

    Dim rnd As New Random()
    Dim userName As String = ""
    Dim logFile As String = $"DoctorKookoo_{DateTime.Now:yyyyMMdd_HHmmss}.log"

    ' ========= ELIZA DATA =========

    Dim reflections As New Dictionary(Of String, String) From {
        {" i ", " you "},
        {" me ", " you "},
        {" my ", " your "},
        {" am ", " are "},
        {" you ", " I "},
        {" your ", " my "}
    }

    Dim rules As New List(Of ElizaRule)

    Dim fallbackResponses() As String = {
        "Please go on.",
        "Tell me more about that.",
        "How does that make you feel?",
        "Why do you say that?",
        "Can you elaborate on that?",
        "I see. And what does that suggest to you?"
    }

    ' ==============================

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        InitializeRules()
        AddDoctor("Hello, I'm Doctor Kookoo. What is your name?")
    End Sub

    Private Sub btnSend_Click(sender As Object, e As EventArgs) Handles btnSend.Click
        If txtInput.Text.Trim = "" Then Exit Sub

        Dim input As String = txtInput.Text.Trim()
        txtInput.Clear()

        AddUser(input)

        If userName = "" Then
            userName = input
            AddDoctor($"That's a fine name, {userName}. What's on your mind?")
            Return
        End If

        If input.ToLower().StartsWith("bye") Then
            AddDoctor("Goodbye. Our session is over.")
            Log("SESSION ENDED")
            btnSend.Enabled = False
            Return
        End If

        Dim response As String = GenerateResponse(input)
        AddDoctor(response)
    End Sub

    ' ========= CORE LOGIC =========

    Function GenerateResponse(input As String) As String
        Dim padded = " " & input.ToLower() & " "

        For Each rule In rules.OrderByDescending(Function(r) r.Priority)
            If padded.Contains(" " & rule.Keyword & " ") Then
                Dim fragment = ExtractFragment(padded, rule.Keyword)
                fragment = Reflect(fragment)
                Return String.Format(rule.Response, fragment, userName)
            End If
        Next

        Return fallbackResponses(rnd.Next(fallbackResponses.Length))
    End Function

    Function ExtractFragment(text As String, keyword As String) As String
        Dim idx = text.IndexOf(keyword)
        If idx = -1 Then Return ""
        Return text.Substring(idx + keyword.Length).Trim()
    End Function

    Function Reflect(text As String) As String
        Dim result = " " & text & " "
        For Each pair In reflections
            result = result.Replace(pair.Key, pair.Value)
        Next
        Return result.Trim()
    End Function

    ' ========= RULE DEFINITIONS =========

    Sub InitializeRules()
        rules.Add(New ElizaRule("i am", 5, "Why are you {0}?"))
        rules.Add(New ElizaRule("i feel", 5, "Do you often feel {0}?"))
        rules.Add(New ElizaRule("because", 4, "Is that the real reason?"))
        rules.Add(New ElizaRule("you are", 3, "What makes you think I am {0}?"))
        rules.Add(New ElizaRule("mother", 4, "Tell me more about your mother."))
        rules.Add(New ElizaRule("father", 4, "How is your relationship with your father?"))
        rules.Add(New ElizaRule("dream", 4, "What does that dream suggest to you?"))
        rules.Add(New ElizaRule("sorry", 2, "Please don't apologize."))
    End Sub

    ' ========= UI + LOGGING =========

    Sub AddUser(text As String)
        txtConversation.AppendText($"{userName}: {text}{Environment.NewLine}")
        Log($"USER: {text}")
    End Sub

    Sub AddDoctor(text As String)
        txtConversation.AppendText($"Doctor: {text}{Environment.NewLine}{Environment.NewLine}")
        Log($"DOCTOR: {text}")
    End Sub

    Sub Log(text As String)
        File.AppendAllText(logFile, $"{DateTime.Now}: {text}{Environment.NewLine}")
    End Sub

End Class

' ========= SUPPORT CLASS =========

Public Class ElizaRule
    Public Property Keyword As String
    Public Property Priority As Integer
    Public Property Response As String

    Public Sub New(key As String, prio As Integer, resp As String)
        Keyword = key
        Priority = prio
        Response = resp
    End Sub
End Class
