﻿Imports System

Module DoctorKookoo

    Dim rnd As New Random()

    Sub Main()
        Console.Clear()
        Randomize()

        Console.WriteLine("Dr. Kookoo -- by David Bump")
        Console.Write("Press ENTER to start")
        Console.ReadLine()

        Console.Clear()
        Console.WriteLine("The doctor is in.  Type your answers to his questions and then")
        Console.WriteLine("press the 'enter' key.")
        Console.WriteLine()
        Console.WriteLine("For best results, limit each response to one simple sentence.")
        Console.WriteLine("Don't use commas!  Periods...question marks? and exclamation points! are fine.")
        Console.WriteLine("You might represent commas by other symbols like -_+=@#^*.")
        Console.WriteLine()
        Console.WriteLine("Press any key to meet the doctor.")
        Console.ReadKey(True)

        Console.Clear()
        RunSession()
    End Sub

    Sub RunSession()
        Dim name As String
        Dim response As String
        Dim c As Integer = 0
        Dim c1 As Integer = 0
        Dim q As Integer = 0

        Dim randomReplies() As String = {
            "Why do you say that?",
            "Has that been on your mind lately?",
            "Go on...",
            "Are you sure?",
            "Please continue...",
            "I do not understand.",
            "Could you re-phrase that?",
            "I can hardly believe you said that.",
            "You must be joking.",
            "How can you say that?",
            "I don't think so...",
            "No!",
            "Hmmmmm it's a good thing you came to me!",
            "Uh huh... was there anything else?",
            "Perhaps we should close now."
        }

        Console.WriteLine("Hello, I'm Doctor Kookoo -- the psychiatrist program.")
        Console.WriteLine("What is your name?")
        name = Console.ReadLine()

        Console.WriteLine()
        Console.WriteLine("That's a fine name.  What is on your mind, " & name & "?")
        Console.WriteLine()

        Do
            c += 1
            c1 += 1
            If c1 > 5 Then c1 = 1

            response = Console.ReadLine()
            Console.WriteLine()

            If response.Length >= 3 AndAlso response.Substring(0, 3).ToLower() = "bye" Then Exit Do

            If response.Length < 8 Then
                ShortResponse(c1, name)
                Continue Do
            End If

            ' punctuation handling
            If response.EndsWith("?") Then
                response = response.TrimEnd("?"c)
                QuestionResponse(c1, name)
                Continue Do
            End If

            If response.EndsWith("!") Then
                response = response.TrimEnd("!"c)
                ExclamationResponse(c1, name)
                Continue Do
            End If

            If response.EndsWith(".") Then
                response = response.TrimEnd("."c)
            End If

            If response.StartsWith("I don't") Then
                response = response.Substring(7).Trim()
                IDontResponse(c1, response, name)
                Continue Do
            End If

            If response.StartsWith("I do not") Then
                response = response.Substring(8).Trim()
                IDontResponse(c1, response, name)
                Continue Do
            End If

            If response.StartsWith("I am") Then
                response = response.Substring(4).Trim()
                IAmResponse(c1, response, name)
                Continue Do
            End If

            If response.StartsWith("I'm") Then
                response = response.Substring(3).Trim()
                IAmResponse(c1, response, name)
                Continue Do
            End If

            If response.StartsWith("I ") Then
                response = response.Substring(1).Trim()
                IActionResponse(c1, response, name)
                Continue Do
            End If

            If response.ToLower().Contains("you are") Or response.Contains("You're") Then
                YouAreResponse(c1, name)
                Continue Do
            End If

            If response.ToLower().Contains("because") Then
                BecauseResponse(c1, name)
                Continue Do
            End If

            ' random fallback
            q += 1
            If q > randomReplies.Length Then Exit Do
            Console.WriteLine(randomReplies(rnd.Next(randomReplies.Length)))

        Loop

        Diagnosis(c, q, name)
    End Sub

    ' ==== RESPONSE HANDLERS ====

    Sub ShortResponse(c1 As Integer, name As String)
        Select Case c1
            Case 1 : Console.WriteLine("Please give me more to go on.")
            Case 2 : Console.WriteLine("Can you tell me more?")
            Case 3 : Console.WriteLine("Please explain further, " & name & ".")
            Case 4 : Console.WriteLine("Feel free to write longer responses than THAT...")
            Case 5 : Console.WriteLine(name & ", please lengthen your responses!  Try again.")
        End Select
    End Sub

    Sub IDontResponse(c1 As Integer, r As String, name As String)
        Select Case c1
            Case 1 : Console.WriteLine("Why don't you " & r & "?")
            Case 2 : Console.WriteLine("Would you like to " & r & "?")
            Case 3 : Console.WriteLine("Why do you suppose you don't " & r & "?")
            Case 4 : Console.WriteLine("What might be required so you could or would " & r & "?")
            Case 5 : Console.WriteLine("What do you imagine would happen if you DID " & r & ", " & name & "?")
        End Select
    End Sub

    Sub IAmResponse(c1 As Integer, r As String, name As String)
        Select Case c1
            Case 1 : Console.WriteLine("Why are you " & r & "?")
            Case 2 : Console.WriteLine("Are you sure you're " & r & "?")
            Case 3 : Console.WriteLine("Do you enjoy being " & r & ", " & name & "?")
            Case 4 : Console.WriteLine("How long do you expect to be " & r & "?")
            Case 5 : Console.WriteLine(name & ", could you possibly be " & r & " because you LIKE it?")
        End Select
    End Sub

    Sub IActionResponse(c1 As Integer, r As String, name As String)
        Select Case c1
            Case 1 : Console.WriteLine("Do you understand why you " & r & "?")
            Case 2 : Console.WriteLine("Is it common for you to " & r & "?")
            Case 3 : Console.WriteLine(name & ", do you like to " & r & "?")
            Case 4 : Console.WriteLine("What would you think if *I* were to " & r & "?")
            Case 5 : Console.WriteLine("Do you think everyone should " & r & "?")
        End Select
    End Sub

    Sub YouAreResponse(c1 As Integer, name As String)
        Select Case c1
            Case 1 : Console.WriteLine(name & ", remember that I'm just here to help you.")
            Case 2
                Console.WriteLine("I'm sorry but I can't get personally involved.")
                Console.WriteLine("Tell me how you respond if someone talked about you like that.")
            Case 3 : Console.WriteLine("Hmmmmm... do YOU have a problem with that?")
            Case 4 : Console.WriteLine(name & ", we must get back to YOUR problem...")
            Case 5 : Console.WriteLine("Pretend you are talking to yourself and give me your own response.")
        End Select
    End Sub

    Sub QuestionResponse(c1 As Integer, name As String)
        Select Case c1
            Case 1 : Console.WriteLine("What do you think, " & name & "?")
            Case 2 : Console.WriteLine(name & ", I'm not an answer man.")
            Case 3 : Console.WriteLine("Do you ask questions a lot when you're with others?")
            Case 4 : Console.WriteLine("Tell me what you really feel about that, " & name & ".")
            Case 5 : Console.WriteLine("What's your own 'gut reaction' to this question?")
        End Select
    End Sub

    Sub ExclamationResponse(c1 As Integer, name As String)
        Select Case c1
            Case 1 : Console.WriteLine("Please don't get overly excited, " & name & ".")
            Case 2 : Console.WriteLine("Oh -- is it that important to you?")
            Case 3 : Console.WriteLine(name & ", don't you feel you are over-reacting?")
            Case 4 : Console.WriteLine("Tell me why you are so agitated, please.")
            Case 5 : Console.WriteLine("If you feel that strongly about it, we should change the subject.")
        End Select
    End Sub

    Sub BecauseResponse(c1 As Integer, name As String)
        Select Case c1
            Case 1 : Console.WriteLine("Okay -- but can you name another reason, " & name & "?")
            Case 2 : Console.WriteLine("Tell me how you know that is the reason.")
            Case 3 : Console.WriteLine(name & ", what reasons might you hesitate to mention?")
            Case 4 : Console.WriteLine("Okay, " & name & ", but now tell me the REAL reason.")
            Case 5 : Console.WriteLine("Please explain how you arrived at that conclusion.")
        End Select
    End Sub

    Sub Diagnosis(c As Integer, q As Integer, name As String)
        Console.WriteLine()
        Console.WriteLine("Okay, that's enough for today.  Here is my diagnosis:")
        Console.WriteLine()

        Dim score As Integer = Math.Abs(c - q)

        If score <= 7 Then
            Console.WriteLine("You're perfectly normal, " & name & ", but very boring.")
        ElseIf score <= 15 Then
            Console.WriteLine("You're a little strange, but you're the kind of person I like best!")
        ElseIf score <= 20 Then
            Console.WriteLine("Remarkable!  You're even crazier than *I* am!")
        Else
            Console.WriteLine(name & ", you're either a genius, or you've been peeking at my coding.")
        End If

        Console.WriteLine()
        Console.WriteLine("Goodbye.  For another session, press F5")
    End Sub

End Module
