﻿Public Class Form1

    Private questions As String() = {
        "Is your number in this set: {1, 3, 4, 6, 8, 10, 13, 15} ?",
        "Is your number in this set: {1, 2, 5, 6, 8, 11, 12, 15} ?",
        "Is your number in this set: {1, 2, 4, 7, 9, 10, 12, 15} ?",
        "Is your number in this set: {8, 9, 10, 11, 12, 13, 14, 15} ?",
        "Is your number in this set: {4, 5, 6, 7, 12, 13, 14, 15} ?",
        "Is your number in this set: {2, 3, 6, 7, 10, 11, 14, 15} ?",
        "Is your number in this set: {1, 3, 5, 7, 9, 11, 13, 15} ?"
    }

    Private answers(7) As String
    Private currentQuestion As Integer = 0

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        lblTitle.Text = "Seven Questions with Lies"
        lblStatus.Text = "Pick a number between 1 and 15. You may lie once."
        lblQuestion.Text = ""
        btnYes.Enabled = False
        btnNo.Enabled = False
    End Sub

    Private Sub btnStart_Click(sender As Object, e As EventArgs) Handles btnStart.Click
        currentQuestion = 0
        lblStatus.Text = "Answer Y or N to each question."
        btnYes.Enabled = True
        btnNo.Enabled = True
        btnStart.Enabled = False
        ShowQuestion()
    End Sub

    Private Sub ShowQuestion()
        lblQuestion.Text = questions(currentQuestion)
    End Sub

    Private Sub btnYes_Click(sender As Object, e As EventArgs) Handles btnYes.Click
        RecordAnswer("Y")
    End Sub

    Private Sub btnNo_Click(sender As Object, e As EventArgs) Handles btnNo.Click
        RecordAnswer("N")
    End Sub

    Private Sub RecordAnswer(value As String)
        answers(currentQuestion + 1) = value
        currentQuestion += 1

        If currentQuestion < 7 Then
            ShowQuestion()
        Else
            btnYes.Enabled = False
            btnNo.Enabled = False
            DetermineNumber()
        End If
    End Sub

    Private Sub DetermineNumber()
        Dim A As Integer = 0, B As Integer = 0, C As Integer = 0

        If answers(1) = "Y" Then A += 1
        If answers(2) = "Y" Then B += 1
        If answers(3) = "Y" Then C += 1
        If answers(4) = "Y" Then A += 1 : B += 1
        If answers(5) = "Y" Then A += 1 : C += 1
        If answers(6) = "Y" Then B += 1 : C += 1
        If answers(7) = "Y" Then A += 1 : B += 1 : C += 1

        Dim A2 = If(A Mod 2 = 0, 0, 100)
        Dim B2 = If(B Mod 2 = 0, 0, 10)
        Dim C2 = If(C Mod 2 = 0, 0, 1)

        Dim finalSet = A2 + B2 + C2
        Dim liedOn As Integer = 0

        Select Case finalSet
            Case 0
                liedOn = 0
            Case 100
                liedOn = 1
            Case 10
                liedOn = 2
            Case 1
                liedOn = 3
            Case 110
                Flip(answers(4)) : liedOn = 4
            Case 101
                Flip(answers(5)) : liedOn = 5
            Case 11
                Flip(answers(6)) : liedOn = 6
            Case 111
                Flip(answers(7)) : liedOn = 7
        End Select

        Dim X As Integer = 0
        If answers(4) = "Y" Then X += 8
        If answers(5) = "Y" Then X += 4
        If answers(6) = "Y" Then X += 2
        If answers(7) = "Y" Then X += 1

        If liedOn = 0 Then
            lblStatus.Text = $"Your number was {X}."
        Else
            lblStatus.Text = $"Your number was {X}, and you lied on question {liedOn}."
        End If

        btnStart.Enabled = True
    End Sub

    Private Sub Flip(ByRef value As String)
        value = If(value = "Y", "N", "Y")
    End Sub

End Class
