﻿Option Strict On
Option Explicit On

Module MechanicalMouse

    '========================================================
    ' Constants
    '========================================================
    Const False2 As Boolean = False
    Const True2 As Boolean = True

    Const STARTDIR As Integer = 0

    ' Directions: 0=Up, 1=Right, 2=Down, 3=Left
    Dim BinaryWeight() As Integer = {1, 2, 4, 8}
    Dim MoveRowOffset() As Integer = {-1, 0, 1, 0}
    Dim MoveColOffset() As Integer = {0, 1, 0, -1}

    '========================================================
    ' Shared State
    '========================================================
    Dim MouseRow As Integer
    Dim MouseCol As Integer
    Dim MouseDir As Integer

    Dim EntranceRow As Integer
    Dim EntranceCol As Integer
    Dim ExitRow As Integer
    Dim ExitCol As Integer

    Dim Maze(2, 2) As Integer

    Dim MazeIndex As Integer = 0

    '========================================================
    ' Maze Data (Converted from DATA statements)
    '========================================================
    Dim MazeData As Integer(,) = {
        {0, 0, 3, 1, 0, 1, 12, 3, 9, 6},
        {0, 4, 3, 1, 0, 1, 8, 7, 8, 7},
        {4, 0, 3, 1, 0, 2, 9, 6, 8, 7},
        {4, 4, 3, 2, 0, 1, 10, 11, 12, 2}
    }

    Sub Main()
        Console.Title = "Mechanical Mouse (VB.NET)"

        For i As Integer = 0 To 3
            ReadMaze(i)
            InitializeMouse()
            SolveMaze()
            Console.WriteLine("Maze {0} solved.", i + 1)
            Console.WriteLine(New String("-"c, 40))
        Next

        Console.WriteLine("All mazes solved.")
        Console.ReadLine()
    End Sub

    '========================================================
    ' Initialization
    '========================================================
    Sub InitializeMouse()
        MouseRow = EntranceRow
        MouseCol = EntranceCol
        MouseDir = STARTDIR

        Console.WriteLine("Mouse enters maze at ({0},{1})", MouseRow, MouseCol)
    End Sub

    '========================================================
    ' Maze Loading
    '========================================================
    Sub ReadMaze(index As Integer)
        Dim p As Integer = 0

        ' Offsets ignored in console version
        p += 2

        EntranceRow = MazeData(index, p) : EntranceCol = MazeData(index, p + 1)
        p += 2

        ExitRow = MazeData(index, p) : ExitCol = MazeData(index, p + 1)
        p += 2

        For r As Integer = 1 To 2
            For c As Integer = 1 To 2
                Maze(r, c) = MazeData(index, p)
                p += 1
            Next
        Next
    End Sub

    '========================================================
    ' Instruction Set
    '========================================================
    Sub MoveForward()
        MouseRow += MoveRowOffset(MouseDir)
        MouseCol += MoveColOffset(MouseDir)
        Console.WriteLine("Move Forward -> ({0},{1})", MouseRow, MouseCol)
    End Sub

    Sub TurnLeft()
        MouseDir = (MouseDir + 3) Mod 4
        Console.WriteLine("Turn Left -> Dir {0}", MouseDir)
    End Sub

    Sub TurnRight()
        MouseDir = (MouseDir + 1) Mod 4
        Console.WriteLine("Turn Right -> Dir {0}", MouseDir)
    End Sub

    Function WallAhead() As Boolean
        Dim wall As Boolean =
            (Maze(MouseRow, MouseCol) And BinaryWeight(MouseDir)) <> 0

        Console.WriteLine("Wall Ahead? {0}", wall)
        Return wall
    End Function

    Function MazeExit() As Boolean
        Return (MouseRow = ExitRow AndAlso MouseCol = ExitCol)
    End Function

    Sub Halt()
        Console.WriteLine("HALT: Exit reached at ({0},{1})", MouseRow, MouseCol)
    End Sub

    '========================================================
    ' Maze Solution Algorithm
    ' Turn Right, Spin Left (Right-hand wall follower)
    '========================================================
    Sub SolveMaze()

        MoveForward()

        Do Until MazeExit()
            TurnRight()

            While WallAhead()
                TurnLeft()
            End While

            MoveForward()
        Loop

        Halt()
    End Sub

End Module
