﻿Public Class Form1

    Dim qIndex As Integer = 0
    Dim A, B, C, D, E, F, G, H, I As Integer

    Dim questions As String() = {
        "You win $5,000,000 in a lottery. The first thing you do is",
        "You come home unexpectedly and find your spouse with your best friend. You",
        "Given a choice you would rather be",
        "Your idea of a fun Saturday night is",
        "You feel the best way to succeed is to",
        "At a party, someone makes a rude remark. You",
        "You are happiest when you are",
        "A fellow employee blames you for their mistake. You",
        "You usually eat dinner",
        "Your favorite kind of movie is"
    }

    Dim answers(,) As String = {
        {"3 - Give half away", "5 - Quit your job", "1 - Figure out taxes"},
        {"8 - Get angry", "3 - Forgive", "5 - Join them"},
        {"3 - Doctor", "7 - Actor", "8 - Soldier"},
        {"1 - Stay home", "7 - Concert", "2 - Boxing match"},
        {"1 - Work harder", "8 - Be shrewd", "7 - Innovative"},
        {"2 - Tell host", "1 - Joke", "8 - Confront"},
        {"7 - Alone", "9 - With friends", "2 - Challenging"},
        {"2 - Confront now", "6 - Tell later", "4 - Tell boss"},
        {"1 - Same time", "2 - When finished", "9 - With others"},
        {"5 - Comedy", "7 - Love story", "8 - Western"}
    }

    Dim scoreMap(,) As Integer = {
        {3, 5, 1},
        {8, 3, 5},
        {3, 7, 8},
        {1, 7, 2},
        {1, 8, 7},
        {2, 1, 8},
        {7, 9, 2},
        {2, 6, 4},
        {1, 2, 9},
        {5, 7, 8}
    }

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        lblTitle.Text = "PERSONA"
        LoadQuestion()
    End Sub

    Sub LoadQuestion()
        If qIndex >= questions.Length Then
            ShowResults()
            Return
        End If

        lblQuestion.Text = questions(qIndex)
        btn1.Text = answers(qIndex, 0)
        btn2.Text = answers(qIndex, 1)
        btn3.Text = answers(qIndex, 2)
        lblProgress.Text = $"Question {qIndex + 1} of {questions.Length}"
    End Sub

    Sub Score(value As Integer)
        Select Case value
            Case 1 : A += 1
            Case 2 : B += 1
            Case 3 : C += 1
            Case 4 : D += 1
            Case 5 : E += 1
            Case 6 : F += 1
            Case 7 : G += 1
            Case 8 : H += 1
            Case 9 : I += 1
        End Select
    End Sub

    Private Sub btn1_Click(sender As Object, e As EventArgs) Handles btn1.Click
        Score(scoreMap(qIndex, 0))
        qIndex += 1
        LoadQuestion()
    End Sub

    Private Sub btn2_Click(sender As Object, e As EventArgs) Handles btn2.Click
        Score(scoreMap(qIndex, 1))
        qIndex += 1
        LoadQuestion()
    End Sub

    Private Sub btn3_Click(sender As Object, e As EventArgs) Handles btn3.Click
        Score(scoreMap(qIndex, 2))
        qIndex += 1
        LoadQuestion()
    End Sub

    Sub ShowResults()
        lblTitle.Text = "YOUR PERSONALITY"
        lblQuestion.Text = ""

        Dim result As String = ""

        If A < 3 Then
            result &= "You are not very practical." & vbCrLf
        ElseIf A <= 5 Then
            result &= "You have a practical side." & vbCrLf
        Else
            result &= "You are very practical." & vbCrLf
        End If

        If B > 3 Then result &= "You enjoy challenges." & vbCrLf
        If C > 2 Then result &= "You are generous." & vbCrLf
        If D > 2 Then result &= "You can be negative at times." & vbCrLf
        If E > 3 Then result &= "You are easygoing." & vbCrLf
        If F > 3 Then result &= "You are honest and trusting." & vbCrLf
        If G > 3 Then result &= "You have an artistic side." & vbCrLf
        If H > 3 Then result &= "You are strong-willed." & vbCrLf
        If I > 3 Then result &= "You enjoy being with people." & vbCrLf

        lblQuestion.Text = result

        btn1.Visible = False
        btn2.Visible = False
        btn3.Visible = False
        lblProgress.Visible = False
    End Sub

End Class
