﻿Imports System

Module PersonaTest

    Sub Main()
        Console.Title = "PERSONA - Personality Test"

        Console.Clear()
        Console.WriteLine("            PERSONA")
        Console.WriteLine()
        Console.Write("Instructions (y/n)? ")

        Dim key As ConsoleKeyInfo = Console.ReadKey(True)
        If key.KeyChar = "y"c Or key.KeyChar = "Y"c Then
            ShowInstructions()
        End If

        RunTest()
        ShowResults()

        Console.WriteLine()
        Console.WriteLine("Press ESC to exit...")
        Do
            key = Console.ReadKey(True)
        Loop Until key.Key = ConsoleKey.Escape
    End Sub

    '------------------------------------------------------

    Sub ShowInstructions()
        Console.Clear()
        Console.WriteLine("            PERSONA")
        Console.WriteLine()
        Console.WriteLine("Persona is a psychological quiz.")
        Console.WriteLine()
        Console.WriteLine("I will ask you a number of questions.")
        Console.WriteLine("Each question has three responses.")
        Console.WriteLine("Enter the NUMBER of the response")
        Console.WriteLine("you agree with most.")
        Console.WriteLine()
        Console.WriteLine("After answering all questions,")
        Console.WriteLine("I will do a psychological profile on you.")
        Console.WriteLine()
        Console.Write("Press any key to start...")
        Console.ReadKey(True)
    End Sub

    '------------------------------------------------------

    Dim A, B, C, D, E, F, G, H, I As Integer

    Sub RunTest()

        Dim questions As String() = {
            "You win $5,000,000 in a lottery. The first thing you do is",
            "You come home unexpectedly and find your spouse with your best friend. You",
            "Given a choice you would rather be",
            "Your idea of a fun Saturday night is",
            "You feel the best way to succeed is to",
            "At a party, someone makes a rude remark. You",
            "You are happiest when you are",
            "A fellow employee blames you for their mistake. You",
            "You usually eat dinner",
            "Your favorite kind of movie is",
            "I never met a man",
            "When criticized by others you",
            "You join a restricted country club. You",
            "When you play a game, you",
            "You were given too much change. You",
            "You would most like to be remembered as",
            "Your attitude towards life is",
            "Your most admirable attribute is",
            "When asked to donate to save the whales, you say",
            "When you make a mistake you",
            "What impresses you most about others is",
            "When things look bad, they'll",
            "If at first you don't succeed",
            "The best way to do something is",
            "You are most attracted to people who are",
            "You would rather read",
            "What makes you most attractive is",
            "If you wrote a book it would be",
            "When you encounter an argumentative person you",
            "If you run for public office, your best quality is",
            "Remodeling a room gives you pleasure from",
            "Your wardrobe tends toward"
        }

        Dim answers As String(,) = {
            {"3 - Give half away", "5 - Quit your job", "1 - Figure out taxes"},
            {"8 - Get angry", "3 - Forgive", "5 - Join them"},
            {"3 - Doctor", "7 - Actor", "8 - Soldier"},
            {"1 - Stay home", "7 - Concert", "2 - Boxing match"},
            {"1 - Work harder", "8 - Be shrewd", "7 - Innovative ideas"},
            {"2 - Tell host", "1 - Joke", "8 - Confront"},
            {"7 - Alone", "9 - With friends", "2 - Challenging task"},
            {"2 - Confront now", "6 - Tell later", "4 - Tell boss"},
            {"1 - Same time", "2 - When finished", "9 - With others"},
            {"5 - Comedy", "7 - Love story", "8 - Western"},
            {"9 - I liked", "4 - I trusted", "8 - I beat"},
            {"6 - Accept it", "2 - Dismiss it", "1 - Analyze"},
            {"5 - Don't care", "9 - Resign", "1 - Change policy"},
            {"8 - Anything to win", "5 - Have fun", "1 - Methodical"},
            {"4 - Keep it", "6 - Return it", "2 - Tell manager"},
            {"9 - Warm", "4 - Rich", "8 - Always right"},
            {"1 - Obey rules", "2 - Lead others", "5 - Live and let live"},
            {"9 - Loyalty", "8 - Perseverance", "5 - Humor"},
            {"3 - Yes", "1 - Already did", "4 - Let them"},
            {"4 - Hide it", "5 - Admit it", "6 - Hope unnoticed"},
            {"7 - Looks", "5 - Humor", "4 - Money"},
            {"5 - Get better", "4 - Worse", "1 - Stay same"},
            {"2 - Try again", "4 - Give up", "1 - Ask advice"},
            {"6 - Right way", "5 - Easy way", "8 - My way"},
            {"7 - Attractive", "1 - Intelligent", "3 - Committed"},
            {"9 - Letter", "1 - Psychology", "6 - Social essay"},
            {"9 - Outgoing", "3 - Affectionate", "8 - Talented"},
            {"1 - Scholarly", "6 - Inspirational", "8 - Autobiographical"},
            {"8 - Argue back", "6 - Avoid", "9 - Understand"},
            {"1 - Knowledge", "2 - Dedication", "8 - Leadership"},
            {"5 - Finished job", "7 - Planning", "2 - Doing work"},
            {"5 - Fancy", "9 - Opposite sex", "1 - Practical"}
        }

        For i As Integer = 0 To questions.Length - 1
            Console.Clear()
            Console.WriteLine($"Question #{i + 1}")
            Console.WriteLine()
            Console.WriteLine(questions(i))
            Console.WriteLine()

            For j As Integer = 0 To 2
                Console.WriteLine(answers(i, j))
            Next

            Dim choice As Integer
            Do
                Dim k = Console.ReadKey(True)
                If Char.IsDigit(k.KeyChar) Then
                    choice = Integer.Parse(k.KeyChar)
                End If
            Loop Until choice >= 1 AndAlso choice <= 9

            Score(choice)
        Next
    End Sub

    '------------------------------------------------------

    Sub Score(value As Integer)
        Select Case value
            Case 1 : A += 1
            Case 2 : B += 1
            Case 3 : C += 1
            Case 4 : D += 1
            Case 5 : E += 1
            Case 6 : F += 1
            Case 7 : G += 1
            Case 8 : H += 1
            Case 9 : I += 1
        End Select
    End Sub

    '------------------------------------------------------

    Sub ShowResults()
        Console.Clear()

        Dim r As New Random()
        Select Case r.Next(1, 4)
            Case 1 : Console.WriteLine("        MY ANALYSIS")
            Case 2 : Console.WriteLine("        YOUR PERSONALITY")
            Case 3 : Console.WriteLine("        THE TEST SHOWS")
        End Select

        Console.WriteLine()

        If A < 3 Then
            Console.WriteLine("You are not a very practical person.")
        ElseIf A <= 5 Then
            Console.WriteLine("You have a practical side that doesn't always show.")
        Else
            Console.WriteLine("You are very practical.")
        End If

        If B > 3 Then Console.WriteLine("You have a zest for doing the impossible.")
        If C > 2 Then Console.WriteLine("You can be generous, sometimes to a fault.")
        If D > 2 Then Console.WriteLine("You have a negative side at times.")
        If E > 3 Then Console.WriteLine("You are easygoing and likable.")
        If F > 3 Then Console.WriteLine("You are honest and trusting.")
        If G > 3 Then Console.WriteLine("You have an artistic side.")
        If H > 3 Then Console.WriteLine("You can be strong-willed.")
        If I > 3 Then Console.WriteLine("You like people, and they like you.")
    End Sub

End Module
