﻿Imports System.IO

Public Class Form1

    Const GroupSize As Integer = 3

    Private charMap As List(Of Char)
    Private stats(,,) As Integer
    Private rnd As New Random()

    Private Sub btnLoad_Click(sender As Object, e As EventArgs) Handles btnLoad.Click
        OpenFileDialog1.Filter = "Text files (*.txt)|*.txt|All files (*.*)|*.*"

        If OpenFileDialog1.ShowDialog() <> DialogResult.OK Then Exit Sub

        lblStatus.Text = "Reading sample..."
        Application.DoEvents()

        LearnLanguage(OpenFileDialog1.FileName)
        lblStatus.Text = "Sample loaded. Ready."
    End Sub

    Private Sub LearnLanguage(path As String)
        charMap = New List(Of Char) From {" "c}

        ' -----------------------------
        ' Build character map
        ' -----------------------------
        Using sr As New StreamReader(path)
            While Not sr.EndOfStream
                Dim line = sr.ReadLine().ToLowerInvariant()
                For Each ch In line
                    If Not charMap.Contains(ch) Then
                        charMap.Add(ch)
                    End If
                Next
            End While
        End Using

        Dim nChar = charMap.Count
        ReDim stats(nChar - 1, nChar - 1, nChar - 1)

        ' -----------------------------
        ' Collect statistics
        ' -----------------------------
        Dim group(GroupSize - 1) As Integer

        Using sr As New StreamReader(path)
            While Not sr.EndOfStream
                Dim line = sr.ReadLine().ToLowerInvariant()
                For Each ch In line
                    Dim idx = charMap.IndexOf(ch)
                    If idx >= 0 Then
                        group(0) = group(1)
                        group(1) = group(2)
                        group(2) = idx

                        If group(0) >= 0 Then
                            stats(group(0), group(1), group(2)) += 1
                        End If
                    End If
                Next
            End While
        End Using

        ' -----------------------------
        ' Accumulate frequencies
        ' -----------------------------
        For i = 0 To nChar - 1
            For j = 0 To nChar - 1
                For k = 1 To nChar - 1
                    stats(i, j, k) += stats(i, j, k - 1)
                Next
            Next
        Next
    End Sub

    Private Sub btnGenerate_Click(sender As Object, e As EventArgs) Handles btnGenerate.Click
        If charMap Is Nothing Then
            MessageBox.Show("Load a sample file first.")
            Exit Sub
        End If

        txtOutput.AppendText(GenerateText(1000) & Environment.NewLine & Environment.NewLine)
    End Sub

    Private Function GenerateText(length As Integer) As String
        Dim sb As New Text.StringBuilder()
        Dim nChar = charMap.Count
        Dim group(GroupSize - 1) As Integer

        ' Pick random valid start
        Do
            group(0) = rnd.Next(nChar)
            group(1) = rnd.Next(nChar)
        Loop While stats(group(0), group(1), nChar - 1) = 0

        For i = 1 To length
            Dim maxVal = stats(group(0), group(1), nChar - 1)
            Dim index = rnd.Next(maxVal)

            Dim k = 0
            While stats(group(0), group(1), k) < index
                k += 1
            End While

            sb.Append(charMap(k))

            group(0) = group(1)
            group(1) = k
        Next

        Dim sb2 As String = sb.ToString

        Do
            Dim pos1 As Integer = InStr(1, sb2, "  ")
            If pos1 Then
                sb2 = Mid(sb2, 1, pos1) + Mid(sb2, pos1 + 2)
            Else
                Exit Do
            End If
        Loop

        Return sb2
    End Function

End Class
