﻿Imports System.IO

Module Polyglot

    Const GroupSize As Integer = 3

    Sub Main()
        Console.WriteLine("Here I am!!")
        Console.WriteLine("I'm intelligent enough to write long texts in any language")
        Console.WriteLine("provided you give me a sample text so I can scan it and learn.")
        Console.WriteLine()

        Console.Write("Enter path to sample text file: ")
        Dim filePath As String = Console.ReadLine()

        If Not File.Exists(filePath) Then
            Console.WriteLine("File not found.")
            Return
        End If

        ' -------------------------------------------------
        ' Build character map
        ' -------------------------------------------------
        Console.WriteLine("Building character map...")
        Dim charMap As New List(Of Char)
        charMap.Add(" "c)

        Using sr As New StreamReader(filePath)
            While Not sr.EndOfStream
                Dim line = sr.ReadLine().ToLowerInvariant()
                For Each ch In line
                    If Not charMap.Contains(ch) Then
                        charMap.Add(ch)
                    End If
                Next
            End While
        End Using

        Dim nChar As Integer = charMap.Count

        ' -------------------------------------------------
        ' Statistics array
        ' -------------------------------------------------
        Console.WriteLine("Collecting statistics...")
        Dim stats(nChar - 1, nChar - 1, nChar - 1) As Integer
        Dim group(GroupSize - 1) As Integer

        Using sr As New StreamReader(filePath)
            While Not sr.EndOfStream
                Dim line = sr.ReadLine().ToLowerInvariant()
                For Each ch In line
                    Dim idx = charMap.IndexOf(ch)
                    If idx >= 0 Then
                        group(0) = group(1)
                        group(1) = group(2)
                        group(2) = idx
                        If group(0) >= 0 Then
                            stats(group(0), group(1), group(2)) += 1
                        End If
                    End If
                Next
            End While
        End Using

        ' -------------------------------------------------
        ' Accumulate frequencies
        ' -------------------------------------------------
        Console.WriteLine("Accumulating frequencies...")
        For i = 0 To nChar - 1
            For j = 0 To nChar - 1
                For k = 1 To nChar - 1
                    stats(i, j, k) += stats(i, j, k - 1)
                Next
            Next
        Next

        ' -------------------------------------------------
        ' Text generation
        ' -------------------------------------------------
        Console.WriteLine()
        Console.WriteLine("Here it goes...")
        Dim rnd As New Random()

        Do
            ' pick random starting pair
            Do
                group(0) = rnd.Next(nChar)
                group(1) = rnd.Next(nChar)
            Loop While stats(group(0), group(1), nChar - 1) = 0

            For cnt = 1 To 1000
                Dim maxVal = stats(group(0), group(1), nChar - 1)
                Dim index = rnd.Next(maxVal)

                Dim k = 0
                While stats(group(0), group(1), k) < index
                    k += 1
                End While

                group(2) = k
                Console.Write(charMap(k))

                group(0) = group(1)
                group(1) = group(2)
            Next

            Console.WriteLine()
            Console.Write("More? (N to quit): ")
        Loop While Console.ReadLine().Trim().ToUpper() <> "N"

    End Sub

End Module
