﻿Class Form1
    Class TopicInfo
        Public Weight As Integer
        Public LastMentioned As Date
        Public EmotionalBias As Integer
    End Class

    Class TherapistNote
        Public Time As Date
        Public Summary As String
    End Class

    Class StatementRecord
        Public Topic As String
        Public Sentiment As Integer
        Public Time As Date
        Public Text As String
    End Class

    Class GoalInfo
        Public Description As String
        Public Created As Date
        Public LastMentioned As Date
        Public ProgressScore As Integer
    End Class

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        rnd = New Random()
        lastCallbackTime = DateTime.Now

        Dim nl = vbCrLf
        AppendText("Hello. Welcome to psychic-ologist by Nathan Wittich" & nl, Color.LightGreen)
        AppendText("This 'Artificial intelligence' will talk to you." & nl, Color.LightGreen)
        AppendText("If something doesn't directly make sense, it may be symbolic." & nl & nl, Color.LightGreen)
        AppendText("Type 'quit' to exit." & nl & nl, Color.Yellow)
        Dim str1 As String = nonsenseMessages(rnd.Next(nonsenseMessages.Length))

        AppendText(str1 & nl & nl, Color.Cyan)
    End Sub

    Private Async Sub btnSend_Click(sender As Object, e As EventArgs) Handles btnSend.Click
        If txtInput.Text.Trim() = "" Then Exit Sub

        btnSend.Enabled = False

        Dim userText As String = txtInput.Text.Trim()
        txtInput.Clear()

        AppendText("> " & userText & vbCrLf, Color.LightGray)

        If userText.ToLower() = "quit" Then
            AppendText("session ended." & vbCrLf, Color.Red)
            btnSend.Enabled = False
            txtInput.Enabled = False
            btnSend.Enabled = True
            Exit Sub
        End If

        If IsRepeatedInput(userText) Then
            AppendText("you already said that." & vbCrLf & vbCrLf, Color.Orange)
            btnSend.Enabled = True
            Exit Sub
        End If

        DecayTopics()
        AnalyzeEmotion(userText)

        Dim detectedGoal = DetectLongTermGoal(userText)
        If detectedGoal <> "" Then
            RememberGoal(detectedGoal)
        End If

        UpdateGoalProgress(userText)

        UpdateMood()

        Dim preface = MoodPreface()
        ''If preface <> "" Then
        ''response = preface & response
        ''End If

        Dim nameString = HandleNameInput(userText)
        If nameString <> "" Then
            Await TypeText(nameString, Color.LightSkyBlue)
            btnSend.Enabled = True
            Exit Sub
        End If

        Dim layered As String = MultiLayerReassemble(userText)
        If layered <> "" Then
            If preface <> "" Then
                layered = preface & layered
            End If
            Await TypeText(layered, Color.LightSkyBlue)
            btnSend.Enabled = True
            Exit Sub
        End If

        Dim parts = ExtractNounAndVerb(userText)
        Dim sentiment = GetSentiment(userText)

        Dim contradiction = DetectContradiction(parts.Item1, sentiment)
        If contradiction <> "" Then
            If Not IsRepeatedOutput(contradiction) Then
                If preface <> "" Then
                    contradiction = preface & contradiction
                End If
                Await TypeText(contradiction, Color.LightSalmon)
                RememberStatement(parts.Item1, sentiment, userText)
                btnSend.Enabled = True
                Exit Sub
            End If
        End If
        RememberStatement(parts.Item1, sentiment, userText)

        Dim emoResponse As String = EmotionalResponse()
        If emoResponse <> "" Then
            If Not IsRepeatedOutput(emoResponse) Then
                AppendText(emoResponse & vbCrLf & vbCrLf, Color.LightCoral)
                btnSend.Enabled = True
                Exit Sub
            End If
        End If

        Dim avoidance = DetectAvoidance(parts.Item1)
        If avoidance <> "" AndAlso rnd.NextDouble() < 0.4 Then
            Await TypeText(avoidance, Color.Plum)
            btnSend.Enabled = True
            Exit Sub
        End If

        If rnd.NextDouble() < 0.25 Then
            Dim recall As String = RecallTopic()
            If recall <> "" Then
                AppendText(recall & vbCrLf & vbCrLf, Color.LightPink)
                btnSend.Enabled = True
                Exit Sub
            End If
        End If

        Dim callbackText As String = DelayedCallback()
        If callbackText <> "" Then
            Await TypeText(callbackText, Color.Khaki)
            ''AppendText(callbackText & vbCrLf & vbCrLf, Color.Khaki)
            btnSend.Enabled = True
            Exit Sub
        End If

        Dim bestScore As Integer = 0
        Dim bestResponse As String = ""

        Dim eliza As String = ElizaResponse(userText)
        Dim elizaScore As Integer = GetKeywordScore(userText)

        If eliza <> "" AndAlso elizaScore >= bestScore Then
            bestScore = elizaScore
            bestResponse = eliza
        End If

        Dim str1 = parts.Item1
        str1 = System.Text.RegularExpressions.Regex.Replace(str1, "[^a-zA-Z0-9]", "")
        If str1 <> "" Then
            RememberTopic(str1)
            Dim topicScore As Integer = 1
            If keywordWeights.ContainsKey(str1) Then
                topicScore = keywordWeights(str1)
            End If
            If topicScore >= bestScore Then
                If Not IsRepeatedOutput("tell me more about your") AndAlso Not IsRepeatedOutput("tell me more about your " & str1 & ".") Then
                    bestScore = topicScore
                    Dim pos2 As Integer = InStr(1, userText, str1)
                    Dim pos1 As Boolean
                    If pos2 > 0 AndAlso Mid(userText, pos2 - 4, 4) = "her " Then
                        bestResponse = "tell me more about her " & str1 & "."
                        pos1 = IsRepeatedOutput("tell me more about her")
                    ElseIf parts.Item1 = "you" Then
                        bestResponse = "tell me more about " & str1 & "."
                        pos1 = IsRepeatedOutput("tell me more about your")
                    ElseIf parts.Item1 = "that" Then
                        bestResponse = "tell me more about " & str1 & "."
                        pos1 = IsRepeatedOutput("tell me more about your")
                    Else
                        bestResponse = "tell me more about your " & str1 & "."
                        pos1 = IsRepeatedOutput("tell me more about your")
                    End If
                End If
            End If
        End If

        If bestResponse <> "" Then
            bestResponse = MaybeUseName(bestResponse)
            Await TypeText(bestResponse, qbColors(rnd.Next(8, 16)))
            ''AppendText(bestResponse & vbCrLf & vbCrLf, qbColors(rnd.Next(8, 16)))
            btnSend.Enabled = True
            Exit Sub
        End If

        If rnd.NextDouble() < 0.2 Then
            Dim goalRecall = RecallGoal()
            If goalRecall <> "" AndAlso Not IsRepeatedOutput(goalRecall) Then
                Await TypeText(goalRecall, Color.LightSteelBlue)
                btnSend.Enabled = True
                Exit Sub
            End If
        End If

        If rnd.NextDouble < 0.1 Then
            ' --- Fallback responses ---
            Dim fallbackResponses() As String = {
        "please tell me more.",
        "can you explain that further?",
        "how does that make you feel?",
        "why do you say that?",
        "let's talk more about that."
    }

            Await TypeText(fallbackResponses(rnd.Next(fallbackResponses.Length)), qbColors(rnd.Next(8, 16)))
            btnSend.Enabled = True
            Exit Sub
        End If

        Dim phrase As String = ""
        For i = 1 To phrases.Length
            phrase = phrases(rnd.Next(phrases.Length))
            If Not history.Contains(phrase) Then Exit For
        Next

        If history.Length > 1000 Then
            history = history.Substring(50)
        End If

        history &= phrase

        Dim colorIndex As Integer = rnd.Next(8, 16)
        Dim corrected = Await ApplyCorrection(phrase)
        Await TypeText(corrected, qbColors(colorIndex))

        QueueDelayedCallback(userText)
        AddTherapistNote(userText)
        btnSend.Enabled = True

    End Sub

    Private Sub AppendText(text As String, color As Color)
        rtConversation.SelectionStart = rtConversation.TextLength
        rtConversation.SelectionLength = 0
        rtConversation.SelectionColor = color
        rtConversation.AppendText(text)
        rtConversation.SelectionColor = rtConversation.ForeColor
        rtConversation.ScrollToCaret()
    End Sub

    Private Function ElizaResponse(input As String) As String
        Dim text As String = input.ToLowerInvariant().Trim()
        text = text.Replace("?", "").Replace(".", "").Replace("!", "").Replace(",", "").Replace("""", "")

        ' --- Feelings ---
        If text.StartsWith("i feel ") AndAlso text.Length > 7 Then
            Return "why do you feel " & text.Substring(7) & "?"
        End If

        If text.Contains("sad") OrElse text.Contains("unhappy") Then
            Return "i'm sorry you're feeling sad. what do you think caused it?"
        End If

        If text.Contains("happy") OrElse text.Contains("excited") Then
            Return "what makes you feel happy?"
        End If

        If text.Contains("angry") OrElse text.Contains("mad") Then
            Return "what usually makes you feel angry?"
        End If

        ' --- Identity ---
        If text.StartsWith("i am ") AndAlso text.Length > 5 Then
            Return "how long have you been " & DeepReflect(text.Substring(5)) & "?"
        End If

        If text.StartsWith("i am not ") Then
            Return "why do you think you are not " & text.Substring(9) & "?"
        End If

        ' --- Reasons / Thinking ---
        If text.Contains("because") Then
            Return "is that the real reason?"
        End If

        If text.StartsWith("why ") Then
            Return "what do you think?"
        End If

        If text.StartsWith("i think ") Then
            Return "what makes you think that?"
        End If

        If text.StartsWith("i dont know") OrElse text.StartsWith("i don't know") Then
            Return "sometimes not knowing is important. how does that make you feel?"
        End If

        ' --- Relationships ---
        Dim idx = text.IndexOf("my ")
        If idx >= 0 AndAlso idx + 3 < text.Length Then
            If Not IsRepeatedOutput("tell me more about your") Then
                Dim pos1 As Boolean = IsRepeatedOutput("tell me more about your")
                Return "tell me more about your " & DeepReflect(text.Substring(idx + 3))
            End If
        End If

        If text.Contains("mother") OrElse text.Contains("father") OrElse text.Contains("family") OrElse text.Contains("dad") Then
            If Not IsRepeatedOutput("How is your relationship with your family?") Then
                Return "How is your relationship with your family?"
            End If
        End If

        If text.Contains("friend") Then
            Return "tell me more about your friends."
        End If

        ' --- User talking about the bot ---
        If text.StartsWith("you ") OrElse text.Contains(" you ") Then
            Return "why do you think that about me?"
        End If

        ' --- Short answers ---
        If text = "yes" Then
            Return "you seem quite sure."
        End If

        If text = "no" Then
            Return "why not?"
        End If

        If text = "maybe" Then
            Return "you don't sound very certain."
        End If

        ' --- Greetings ---
        If text = "hello" OrElse text = "hi" OrElse text = "hey" Then
            Return helloResponses(rnd.Next(helloResponses.Length))
        End If

        If text.Contains("how are you") Then
            Return howareyouResponses(rnd.Next(howareyouResponses.Length))
        End If

        If text.ToLowerInvariant().StartsWith("good morning") Then
            Return goodmorningResponses(rnd.Next(goodmorningResponses.Length))
        End If

        If text.ToLowerInvariant().Contains("good night") OrElse
           text.ToLowerInvariant().Contains("goodnight") Then
            Return goodnightResponses(rnd.Next(goodnightResponses.Length))
        End If

        If text.Contains(" sleep ") OrElse
   text.Contains(" tired ") OrElse
   text.Contains(" exhausted ") OrElse
   text.Contains(" rest ") Then
            Return sleepResponses(rnd.Next(sleepResponses.Length))
        End If

        If text.ToLowerInvariant().Contains("i beg to differ") Then
            Return ibegtodifferResponses(rnd.Next(ibegtodifferResponses.Length))
        End If

        If text.ToLowerInvariant().Contains("i disagree") OrElse
   text.ToLowerInvariant().Contains("disagree") Then
            Return disagreeResponses(rnd.Next(disagreeResponses.Length))
        End If

        Dim lowered = text.ToLowerInvariant()
        If lowered.Contains("i challenge") OrElse
   lowered.Contains("challenge that") OrElse
   lowered.Contains("that’s not true") Then
            Return challengeResponses(rnd.Next(challengeResponses.Length))
        End If

        If text.Trim().ToLowerInvariant().Contains("don't blame me") OrElse
   text.Trim().ToLowerInvariant().Contains("dont blame me") Then
            Return dontblamemeResponses(rnd.Next(dontblamemeResponses.Length))
        End If

        lowered = text.ToLowerInvariant()
        If lowered.Contains("don't judge") OrElse
   lowered.Contains("stop accusing") OrElse
   lowered.Contains("why are you saying") OrElse
   lowered.Contains("you're wrong") Then
            Return defensiveResponses(rnd.Next(defensiveResponses.Length))
        End If

        lowered = text.ToLowerInvariant()
        If lowered.Contains(" sorry") OrElse
   lowered.Contains("apologize") OrElse
   lowered.Contains("apologies") OrElse
   lowered.Contains("forgive me") Then
            Return apologyResponses(rnd.Next(apologyResponses.Length))
        End If

        lowered = text.ToLowerInvariant()
        If lowered.Contains("could have") Then
            Return couldhaveResponses(rnd.Next(couldhaveResponses.Length))
        End If

        lowered = text.ToLowerInvariant()
        If lowered.Contains("didn't") AndAlso lowered.Contains("did not") Then
            Return didntResponses(rnd.Next(didntResponses.Length))
        End If

        lowered = text.ToLowerInvariant()
        If lowered.Contains("i got upset") Then
            Return igotupsetResponses(rnd.Next(igotupsetResponses.Length))
        End If

        lowered = text.ToLowerInvariant()
        If lowered.Contains("good for me") Then
            Return goodformeResponses(rnd.Next(goodformeResponses.Length))
        End If

        lowered = text.ToLowerInvariant()
        If lowered.Contains("punched me") Then
            Return punchedmeResponses(rnd.Next(punchedmeResponses.Length))
        End If

        lowered = text.ToLowerInvariant()
        If lowered.Contains("ouch") Then
            Return punchedmeResponses(rnd.Next(punchedmeResponses.Length))
        End If

        lowered = text.ToLowerInvariant()
        If lowered.Contains("i thought") Then
            Return ithoughtResponses(rnd.Next(ithoughtResponses.Length))
        End If

        lowered = text.ToLowerInvariant()
        If lowered.Contains("sure") Then
            Return sureResponses(rnd.Next(sureResponses.Length))
        End If

        lowered = text.ToLowerInvariant()
        If lowered.Contains("i swear") Then
            Return iswearResponses(rnd.Next(iswearResponses.Length))
        End If

        ' --- Misc ---
        If text.Contains("interesting") Then
            Return thisisinterestingResponses(rnd.Next(thisisinterestingResponses.Length))
        End If

        If text.Contains("just") AndAlso text.Contains("talking") Then
            Return talkingResponses(rnd.Next(talkingResponses.Length))
        End If

        Return ""
    End Function

    Private Function IsRepeatedInput(input As String) As Boolean
        If userHistory Is Nothing Then
            userHistory = New List(Of String)
        End If

        Dim normalized As String = input.ToLowerInvariant().Trim()
        normalized = normalized.Replace(".", "").Replace("!", "").Replace("?", "") _
                           .Replace(",", "").Replace("""", "")

        If String.IsNullOrWhiteSpace(normalized) Then
            Return False
        End If

        SyncLock userHistory
            For Each previous In userHistory

                ' 1️⃣ Exact match
                If previous = normalized Then
                    Return True
                End If

                ' 2️⃣ Greeting equivalence (hi ≈ hello)
                If IsGreetingEquivalent(previous) AndAlso IsGreetingEquivalent(normalized) Then
                    Return True
                End If

                ' 3️⃣ Phrase synonym equivalence
                If ArePhraseSynonyms(previous, normalized) Then
                    Return True
                End If

                ' 3️⃣ Fuzzy typo match
                If Math.Abs(previous.Length - normalized.Length) <= 2 Then
                    If LevenshteinDistance(previous, normalized) <= 2 Then
                        Return True
                    End If
                End If
            Next

            userHistory.Add(normalized)

            If userHistory.Count > 20 Then
                userHistory.RemoveAt(0)
            End If
        End SyncLock

        Return False
    End Function

    Private Function IsRepeatedOutput(input As String) As Boolean
        Dim normalized As String = input.ToLowerInvariant().Trim()
        normalized = normalized.Replace(".", "").Replace("!", "").Replace("?", "") _
                           .Replace(",", "").Replace("""", "")

        If String.IsNullOrWhiteSpace(normalized) Then
            Return False
        End If

        If compHistory.Contains(normalized) Then
            Return True
        End If

        compHistory.Add(normalized)

        If compHistory.Count > 20 Then
            compHistory.RemoveAt(0)
        End If

        Return False
    End Function

    Private Function ExtractNounAndVerb(input As String) As (String, String)
        Dim text As String = input.ToLowerInvariant().Trim()

        text = text.Replace(".", "") _
           .Replace(",", "") _
           .Replace("!", "") _
           .Replace("?", "") _
           .Replace("""", "")

        Dim words() As String = text.Split({" "c}, StringSplitOptions.RemoveEmptyEntries)

        Dim foundVerb As String = ""
        Dim normalizedVerb As String = ""

        For Each w In words
            Dim baseVerb = NormalizeVerb(w)

            If commonVerbs.Contains(baseVerb) Then
                foundVerb = w                ' original tense
                normalizedVerb = baseVerb    ' base form
            End If
        Next

        Dim foundNoun As String = ""

        For i As Integer = 0 To words.Length - 2
            If nounIndicators.Contains(words(i)) Then
                If Not commonVerbs.Contains(words(i + 1)) AndAlso Not noRealNouns.Contains(words(i + 1)) Then
                    foundNoun = words(i + 1)
                    Exit For
                End If
            End If
        Next

        If foundNoun = "" Then
            For Each w In words
                If nouns.ContainsKey(w) OrElse nouns.ContainsKey(w.TrimEnd("s"c)) Then
                    foundNoun = w
                    Exit For
                End If
            Next
        End If

        Return (foundNoun, normalizedVerb)
        ''Return (foundNoun, foundVerb & "|" & normalizedVerb)
    End Function

    Private Sub RememberTopic(noun As String)
        If String.IsNullOrWhiteSpace(noun) Then Exit Sub

        Dim now = DateTime.Now
        If Not topicMemory.ContainsKey(noun) Then
            topicMemory(noun) = New TopicInfo With {
            .Weight = 0,
            .EmotionalBias = 0,
            .LastMentioned = now
        }
        End If

        topicMemory(noun).Weight += 2
        topicMemory(noun).LastMentioned = now

        Dim strongestEmotion = emotionWeights.OrderByDescending(Function(e) e.Value).First()
        topicMemory(noun).EmotionalBias += strongestEmotion.Value
    End Sub

    Private Function RecallTopic() As String
        If topicMemory Is Nothing OrElse topicMemory.Count = 0 Then Return ""

        Dim best = topicMemory _
        .OrderByDescending(Function(t) CLng(t.Value.Weight) + CLng(t.Value.EmotionalBias)) _
        .First()

        Dim timePhrase2 = TimePhrase(best.Value.LastMentioned)
        Dim mention = PickRandom(MentionPhrases)
        Dim followUp = PickRandom(FollowUpPhrases)

        Return $"{timePhrase2} {mention} '{best.Key}'. {followUp}"
    End Function

    Private Sub AnalyzeEmotion(input As String)
        Dim text = " " & input.ToLowerInvariant() & " "

        text = text.Replace(".", "") _
           .Replace(",", "") _
           .Replace("!", "") _
           .Replace("?", "") _
           .Replace("""", "")

        If text.Contains(" angry ") _
            OrElse text.Contains(" mad ") _
            OrElse text.Contains(" furious ") _
            OrElse text.Contains(" pissed ") _
            OrElse text.Contains(" annoyed ") _
            OrElse text.Contains(" irritated ") _
            OrElse text.Contains(" frustrated ") _
            OrElse text.Contains(" hate ") _
            OrElse text.Contains(" upset ") _
            OrElse text.Contains(" rage ") Then

            emotionWeights("anger") += 3
        End If

        If text.Contains(" sad ") _
            OrElse text.Contains(" depressed ") _
            OrElse text.Contains(" unhappy ") _
            OrElse text.Contains(" miserable ") _
            OrElse text.Contains(" lonely ") _
            OrElse text.Contains(" tired ") _
            OrElse text.Contains(" exhausted ") _
            OrElse text.Contains(" hopeless ") _
            OrElse text.Contains(" down ") _
            OrElse text.Contains(" heartbroken ") Then

            emotionWeights("sadness") += 3
        End If

        If text.Contains(" afraid ") _
            OrElse text.Contains(" scared ") _
            OrElse text.Contains(" anxious ") _
            OrElse text.Contains(" nervous ") _
            OrElse text.Contains(" worried ") _
            OrElse text.Contains(" panicked ") _
            OrElse text.Contains(" stressed ") _
            OrElse text.Contains(" overwhelmed ") _
            OrElse text.Contains(" tense ") _
            OrElse text.Contains(" fearful ") Then

            emotionWeights("anxiety") += 3
        End If

        If text.Contains(" happy ") _
            OrElse text.Contains(" good ") _
            OrElse text.Contains(" great ") _
            OrElse text.Contains(" fine ") _
            OrElse text.Contains(" relaxed ") _
            OrElse text.Contains(" calm ") _
            OrElse text.Contains(" relieved ") _
            OrElse text.Contains(" excited ") _
            OrElse text.Contains(" content ") _
            OrElse text.Contains(" satisfied ") Then

            emotionWeights("positive") += 2
        End If

        For Each key In emotionWeights.Keys.ToList()
            emotionWeights(key) = Math.Max(0, emotionWeights(key) - 1)
        Next
    End Sub

    Private Function EmotionalResponse() As String
        Dim strongest = emotionWeights.OrderByDescending(Function(e) e.Value).First()

        If strongest.Value < 3 Then Return ""

        Select Case strongest.Key.ToLowerInvariant()
            Case "anger"
                Dim reply As String = GetRandomResponse("anger", responses)
                Return reply
            Case "sadness"
                Dim reply As String = GetRandomResponse("sadness", responses)
                Return reply
            Case "anxiety"
                Dim reply As String = GetRandomResponse("anxiety", responses)
                Return reply
            Case "positive"
                Dim reply As String = GetRandomResponse("positive", responses)
                Return reply
        End Select

        Return ""

        ''"how are you feeling right now?"
        ''"do you want to talk more about what's on your mind?"
        ''"i'm listening. tell me more."
    End Function

    Private Function GetKeywordScore(input As String) As Integer
        Dim score As Integer = 0
        Dim text As String = input.ToLower()

        Dim words = text.Split({" "c, "."c, ","c, "!"c, "?"c}, StringSplitOptions.RemoveEmptyEntries)

        For Each key In keywordWeights.Keys
            If words.Contains(key) Then
                score += keywordWeights(key)
            End If
        Next

        Return score
    End Function

    Private Sub DecayTopics()
        For Each key In topicMemory.Keys.ToList()
            Dim topic = topicMemory(key)
            topic.Weight -= 1
            topic.EmotionalBias = Math.Max(0, topic.EmotionalBias - 1)

            If topic.Weight <= 0 Then
                topicMemory.Remove(key)
            Else
                topicMemory(key) = topic
            End If
        Next
    End Sub

    Private Sub ReflectPronouns2(text As String)
        Dim reflections As (Pattern As String, Replacement As String)() = {
        ("\bI am\b", "you are"),
        ("\bI've\b", "you've"),
        ("\bI have\b", "you have"),
        ("\bI'll\b", "you'll"),
        ("\bI will\b", "you will"),
        ("\bI'd\b", "you'd"),
        ("\byou're\b", "I'm"),
        ("\byou are\b", "I am"),
        ("\byou've\b", "I've"),
        ("\byou have\b", "I have"),
        ("\byou'll\b", "I'll"),
        ("\byou will\b", "I will"),
        ("\byou'd\b", "I'd"),
        ("\bme\b", "you"),
        ("\bmy\b", "your"),
        ("\byour\b", "my"),
        ("\bmine\b", "yours"),
        ("\byours\b", "mine"),
        ("\bi\b", "you"),
        ("\byou\b", "I")
    }
    End Sub

    Private Function ReflectPronouns(text As String) As String
        If String.IsNullOrWhiteSpace(text) Then Return text

        Dim reflections As (From As String, [To] As String)() = {
        ("i'm", "you're"),
        ("i", "you"),
        ("me", "you"),
        ("my", "your"),
        ("your", "my"),
        ("mine", "yours"),
        ("yours", "mine"),
        ("myself", "yourself")
    }
        ''("you", "i"),

        text = text.ToLowerInvariant()

        Dim words = text.Split(
        {" "c, "."c, ","c, "!"c, "?"c},
        StringSplitOptions.RemoveEmptyEntries)

        Dim isChange(words.Length - 1) As Boolean

        For i = 0 To words.Length - 1
            If words(i) = "you" Then
                If i = 0 Then
                    words(i) = "i"
                Else
                    words(i) = "me" ' "me" after verb
                End If
                Continue For
            End If
            For j = 0 To reflections.Length - 1
                If Not isChange(i) AndAlso words(i) = reflections(j).From Then
                    words(i) = reflections(j).To
                    isChange(i) = True
                    Exit For
                End If
            Next
        Next

        Return String.Join(" ", words)
    End Function

    Private Function MultiLayerReassemble(input As String) As String
        If String.IsNullOrWhiteSpace(input) Then Return ""

        Dim lowered = input.ToLower()

        ' Longest phrases first to avoid partial matches
        Dim connectors As String() = {
        " as a result of ",
        " due to ",
        " owing to ",
        " because ",
        " since ",
        " as "
    }

        For Each connector In connectors
            Dim pattern = " " & connector & " "
            Dim idx = lowered.IndexOf(pattern)

            If idx = -1 Then
                pattern = connector & " "
                idx = lowered.IndexOf(pattern)
            End If

            If idx > -1 Then
                Dim partA = DeepReflect(input.Substring(0, idx).Trim())
                Dim partB = DeepReflect(input.Substring(idx + pattern.Length).Trim())

                If partB = "" Then Return ""

                Stop
                If partA <> "" Then
                    Return "you say " & partA & " " & connector & " " & partB & "."
                Else
                    Return "you say " & connector & " " & partB & "."
                End If
            End If
        Next

        If lowered.StartsWith("i feel ") Then
            Return "you seem to feel " & DeepReflect(input.Substring("i feel ".Length)) & "."
        End If

        Return ""
    End Function

    Private Sub QueueDelayedCallback(input As String)
        If input.Length < 10 Then Exit Sub

        delayedQueue.Enqueue(input)

        If delayedQueue.Count > 5 Then
            delayedQueue.Dequeue()
        End If
    End Sub

    Private Function DelayedCallback() As String
        If delayedQueue.Count = 0 Then Return ""

        If (DateTime.Now - lastCallbackTime).TotalSeconds < 20 Then Return ""

        If rnd.NextDouble() < 0.1 Then ''0.2
            lastCallbackTime = DateTime.Now
            Dim recalled = delayedQueue.Dequeue()

            Dim templates As String() = {
        $"A moment ago you said ""{recalled}"". Can you explain that?",
        $"Earlier you mentioned ""{recalled}"". What did you mean by that?",
        $"You said ""{recalled}"" not long ago. Can you tell me more?",
        $"I remember you saying ""{recalled}"". Why is that important?",
        $"You mentioned ""{recalled}"" earlier. Could you expand on that?",
        $"Going back to something you said — ""{recalled}"" — can you clarify?"
    }

            Return templates(rnd.Next(templates.Length))
        End If

        Return ""
    End Function

    Private Async Function TypeText(text As String, color As Color) As Task
        rtConversation.SelectionStart = rtConversation.TextLength
        rtConversation.SelectionColor = color

        For Each ch As Char In text
            rtConversation.AppendText(ch)
            Await Task.Delay(rnd.Next(15, 45))

            If rnd.NextDouble() < 0.02 Then
                Await Task.Delay(300)
            End If
        Next

        rtConversation.AppendText(vbCrLf & vbCrLf)
        rtConversation.SelectionColor = rtConversation.ForeColor
        rtConversation.ScrollToCaret()
    End Function

    Private Async Function ApplyCorrection(text As String) As Task(Of String)
        If rnd.NextDouble() > 0.1 Then Return text

        If text.Length < 6 Then Return text

        Dim cut As Integer = rnd.Next(3, Math.Min(8, text.Length - 1))
        Dim typo = text.Substring(0, cut)

        Await TypeText(typo & "...", Color.Gray)
        Await Task.Delay(400)

        Dim corrections As String() = {
    " sorry.",
    " oops.",
    " wait.",
    " my bad.",
    " scratch that.",
    " I mean.",
    " hold on.",
    " actually."
}

        Dim correction = corrections(rnd.Next(corrections.Length))
        Await TypeText(correction, Color.Gray)

        Return text
    End Function

    Private Function DeepReflect(text As String) As String
        Dim reflected = ReflectPronouns(text)

        Dim pos1 As Integer = InStr(1, reflected, "you am")
        If pos1 > 0 Then
            reflected = Mid(reflected, 1, pos1 + 3) + "are" + Mid(reflected, 7)
        End If

        Return reflected
    End Function

    Private Function GetBestTopic() As String
        If topicMemory.Count = 0 Then Return ""

        Dim best = topicMemory _
        .OrderByDescending(Function(t) t.Value.Weight + t.Value.EmotionalBias) _
        .First()

        Return best.Key
    End Function

    Private Function TimePhrase(t As DateTime) As String
        Dim minutes As Double = (DateTime.Now - t).TotalMinutes

        If minutes < 0 Then Return "in the future"

        Select Case minutes
            Case < 1
                Return "just now"
            Case < 5
                Return "a moment ago"
            Case < 15
                Return "a few minutes ago"
            Case < 30
                Return "earlier"
            Case < 60
                Return "less than an hour ago"
            Case < 120
                Return "earlier today"
            Case < 360
                Return "this morning/afternoon"
            Case < 720
                Return "earlier today"
            Case < 1440
                Return "earlier today"
            Case < 2880
                Return "yesterday"
            Case < 10080
                Return "earlier this week"
            Case < 20160
                Return "last week"
            Case Else
                Return "some time ago"
        End Select
    End Function

    Private Sub AddTherapistNote(input As String)
        Dim note As String = ""

        Dim dominantEmotion = emotionWeights.OrderByDescending(Function(e) e.Value).First()
        If dominantEmotion.Value > 2 Then
            note &= "Strong " & dominantEmotion.Key & ". "
        End If

        Dim topic = GetBestTopic()
        If topic <> "" Then
            note &= "Focus on " & topic & ". "
        End If

        If input.Length < 5 Then
            note &= "Minimal response."
        End If

        If longTermGoals.Count > 0 Then
            Dim g = longTermGoals.Values.OrderByDescending(Function(x) x.LastMentioned).First()
            note &= $"Long-term goal: {g.Description}. "
        End If

        If note <> "" Then
            therapistNotes.Add(New TherapistNote With {
            .Time = DateTime.Now,
            .Summary = note.Trim()
        })
        End If

        If therapistNotes.Count > 50 Then
            therapistNotes.RemoveAt(0)
        End If
    End Sub

    Private Sub DumpNotes()
        For Each n In therapistNotes
            Debug.WriteLine(n.Time.ToShortTimeString() & " - " & n.Summary)
        Next
    End Sub

    Private Function GetSentiment(text As String) As Integer
        If String.IsNullOrWhiteSpace(text) Then Return 0

        text = " " & text.ToLowerInvariant() & " "

        text = text.Replace(".", "") _
           .Replace(",", "") _
           .Replace("!", "") _
           .Replace("?", "") _
           .Replace("""", "")

        Dim lowered = text

        Dim negativeWords As String() = {
        " hate ", " angry ", " mad ", " upset ", " sad ", " bad ",
        " awful ", " terrible ", " horrible ", " annoyed ",
        " frustrated ", " disappointed ", " depressed ",
        " miserable ", " stressed ", " anxious "
    }

        Dim positiveWords As String() = {
        " like ", " love ", " happy ", " glad ", " good ",
        " great ", " fine ", " awesome ", " amazing ",
        " wonderful ", " pleased ", " satisfied ",
        " excited ", " relaxed ", " calm ", " hopeful "
    }

        Dim score As Integer = 0

        For Each word In negativeWords
            If lowered.Contains(word) Then score -= 1
        Next

        For Each word In positiveWords
            If lowered.Contains(word) Then score += 1
        Next

        If score > 0 Then Return 1
        If score < 0 Then Return -1
        Return 0
    End Function

    Private Function DetectContradiction(topic As String, sentiment As Integer) As String
        If topic = "" OrElse sentiment = 0 Then Return ""

        For Each s In statementHistory.AsEnumerable().Reverse()
            If s.Topic = topic AndAlso s.Sentiment <> 0 AndAlso s.Sentiment <> sentiment Then
                Dim responses As String() = {
                $"Earlier you said something different about {topic}. Can you help me understand that?",
                $"Before, you seemed to feel differently about {topic}. What changed?",
                $"I remember you describing {topic} in another way earlier. Can you tell me more?",
                $"You mentioned {topic} earlier with a different feeling. How do you see it now?",
                $"It sounds like your feelings about {topic} might have shifted. Can you explain?",
                $"Earlier you talked about {topic} in a different way. What led to that change?",
                $"I may be mistaken, but I remember you feeling differently about {topic}. Can you clarify?"
            }

                Return responses(rnd.Next(responses.Length))
            End If
        Next

        Return ""
    End Function

    Private Sub RememberStatement(topic As String, sentiment As Integer, text As String)
        If topic = "" Then Exit Sub

        statementHistory.Add(New StatementRecord With {
        .Topic = topic,
        .Sentiment = sentiment,
        .Time = DateTime.Now,
        .Text = text
    })

        If statementHistory.Count > 30 Then
            statementHistory.RemoveAt(0)
        End If
    End Sub

    Private Sub UpdateMood()
        Dim strongest = emotionWeights.OrderByDescending(Function(e) e.Value).First()

        If strongest.Value >= 4 Then
            currentMood = strongest.Key
        End If
    End Sub

    Private Function MoodPreface() As String
        Select Case currentMood.ToLower()
            Case "anger"
                Dim angerPhrases() As String = {
                "you still seem upset. ",
                "you sound pretty frustrated. ",
                "there's still some anger in your tone. ",
                "you seem irritated about this. ",
                "you sound tense and annoyed. "
            }

                Return angerPhrases(GetRandomIndex(angerPhrases.Length))

            Case "sadness"
                Dim sadnessPhrases() As String = {
                "you seem a bit down. ",
                "you sound discouraged. ",
                "there’s a sadness in how you’re speaking. ",
                "you seem emotionally drained. ",
                "you sound like you’re feeling low. ",
                "you seem weighed down by this. "
            }

                Return sadnessPhrases(GetRandomIndex(sadnessPhrases.Length))

            Case "anxiety"
                Dim anxietyPhrases() As String = {
                "you still sound worried. ",
                "you seem uneasy about this. ",
                "there’s a lot of tension in your words. ",
                "you sound anxious and uncertain. ",
                "you seem on edge right now. ",
                "you sound concerned about what might happen. "
            }

                Return anxietyPhrases(GetRandomIndex(anxietyPhrases.Length))

            Case Else
                Return ""
        End Select
    End Function

    Private Function GetRandomIndex(max As Integer) As Integer
        Static rnd As New Random()
        Return rnd.Next(max)
    End Function

    Private Function MoodPreface2() As String
        If String.IsNullOrEmpty(currentMood) Then Return ""

        Select Case currentMood.ToLower()
            Case "fear"
                Return "you sound a little afraid. "
            Case "stress"
                Return "you seem under a lot of pressure. "
            Case "frustration"
                Return "you sound frustrated. "
            Case "confusion"
                Return "you seem uncertain right now. "
            Case "loneliness"
                Return "you sound like you could use some company. "
            Case "happiness"
                Return "you seem to be in a good mood. "
            Case "excitement"
                Return "you sound excited. "
            Case "calm"
                Return "you seem calm and steady. "
            Case Else
                Return ""
        End Select
    End Function

    Private Function DetectAvoidance(currentTopic As String) As String
        If currentTopic = "" Then Return ""

        Dim bestTopic = GetBestTopic()
        If bestTopic = "" Then Return ""

        Dim avoidancePhrases() As String = {
    "you seem to steer the conversation away from " & bestTopic & ".",
    "it feels like talking about " & bestTopic & " might be uncomfortable for you.",
    "you tend to move on quickly when we talk about " & bestTopic & ".",
    "you seem hesitant to stay on the topic of " & bestTopic & ".",
    "you keep changing the subject when " & bestTopic & " comes up.",
    "it looks like you’re shifting topics when " & bestTopic & " comes up.",
    "you don’t seem to want to stay on the subject of " & bestTopic & ".",
    "it sounds like " & bestTopic & " is a difficult subject.",
    "you might not be ready to talk about " & bestTopic & " yet.",
    "you seem to avoid talking about " & bestTopic & ".",
    "it feels like you’re deliberately steering away from " & bestTopic & ".",
    "I notice we don’t stay long on the topic of " & bestTopic & ".",
    "we seem to move away from " & bestTopic & " pretty quickly.",
    "it’s interesting how the conversation shifts when " & bestTopic & " comes up."
}

        If currentTopic <> bestTopic AndAlso emotionWeights.Values.Max() >= 4 Then
            Return avoidancePhrases(GetRandomIndex(avoidancePhrases.Length))
            ''Return "You seem to change the subject when we talk about " & bestTopic & "."
        End If

        Return ""
    End Function

    Private Function LevenshteinDistance(s As String, t As String) As Integer
        Dim n = s.Length
        Dim m = t.Length
        Dim d(n, m) As Integer

        For i = 0 To n
            d(i, 0) = i
        Next
        For j = 0 To m
            d(0, j) = j
        Next

        For i = 1 To n
            For j = 1 To m
                Dim cost = If(s(i - 1) = t(j - 1), 0, 1)
                d(i, j) = Math.Min(
                Math.Min(d(i - 1, j) + 1, d(i, j - 1) + 1),
                d(i - 1, j - 1) + cost)
            Next
        Next

        Return d(n, m)
    End Function

    Private Function IsGreetingEquivalent(text As String) As Boolean
        Dim greetings() As String = {
    "hi", "hello", "hey", "hiya", "howdy", "greetings",
    "hey there", "hello there", "hi there",
    "good morning", "good afternoon", "good evening",
    "yo", "sup", "what's up", "whats up",
    "salutations", "welcome"
}

        Return greetings.Contains(text)
    End Function

    Private Function ArePhraseSynonyms(a As String, b As String) As Boolean
        For Each group In phraseSynonymGroups
            If group.Contains(a) AndAlso group.Contains(b) Then
                Return True
            End If
        Next
        Return False
    End Function

    Private Function NormalizeVerb(word As String) As String
        ' Irregular verbs first
        If irregularVerbs.ContainsKey(word) Then
            Return irregularVerbs(word)
        End If

        ' -ing form
        If word.EndsWith("ing") AndAlso word.Length > 4 Then
            Return word.Substring(0, word.Length - 3)
        End If

        ' -ed form
        If word.EndsWith("ed") AndAlso word.Length > 3 Then
            Return word.Substring(0, word.Length - 2)
        End If

        ' 3rd person singular
        If word.EndsWith("s") AndAlso word.Length > 3 Then
            Return word.Substring(0, word.Length - 1)
        End If

        Return word
    End Function

    Private Function PickRandom(phrases As String()) As String
        Return phrases(rng.Next(phrases.Length))
    End Function

    Private Function GetRandomResponse(emotion As String,
                                   responses As Dictionary(Of String, List(Of String))) As String

        If responses Is Nothing OrElse responses.Count = 0 Then Return ""
        If Not responses.ContainsKey(emotion) Then Return ""

        Dim list = responses(emotion)
        If list Is Nothing OrElse list.Count = 0 Then Return ""

        Dim index As Integer = rng.Next(list.Count)
        Return list(index)
    End Function

    Private Function HandleNameInput(userInput As String) As String
        Dim lowerInput = userInput.ToLower()

        If lowerInput.StartsWith("my name is ") Then
            userName = userInput.Substring(11).Trim()

            ' Remove trailing punctuation
            userName = userName.TrimEnd("."c, "!"c, "?"c)

            Dim nicetomeetyouResponses() As String = {
    "Nice to meet you too!",
    "Likewise!",
    "Pleasure to meet you.",
    "The pleasure is mine.",
    "Great to meet you!",
    "Happy to meet you.",
    "Same here!",
    "Nice meeting you as well.",
    "Glad to meet you!",
    "Good to meet you!"
}

            Return $"{nicetomeetyouResponses(rng.Next(nicetomeetyouResponses.Length))}, {userName}."
        End If

        Return ""
    End Function

    Private Function MaybeUseName(baseResponse As String) As String
        If String.IsNullOrEmpty(userName) Then Return baseResponse

        ' ~25% chance to include the name
        If rnd.Next(5) = 0 Then
            Return $"{NamePrefix()} {baseResponse}"
        End If

        Return baseResponse
    End Function

    Private Function NamePrefix() As String
        If String.IsNullOrEmpty(userName) Then Return ""

        Dim prefixes() As String = {
    $"{userName}, ",
    $"I hear you, {userName}. ",
    $"It sounds like, {userName}, ",
    $"You know, {userName}, ",
    $"Alright, {userName}, ",
    $"Well, {userName}, ",
    $"Honestly, {userName}, ",
    $"From what I can tell, {userName}, ",
    $"If I’m understanding you right, {userName}, ",
    $"Let me think, {userName}, ",
    $"I get what you mean, {userName}. ",
    $"So, {userName}, ",
    $"Okay then, {userName}, ",
    $"That said, {userName}, "
}

        Return prefixes(rnd.Next(prefixes.Length))
    End Function

    Private Function DetectLongTermGoal(input As String) As String
        Dim text = input.ToLowerInvariant().Trim()

        text = text.Replace(".", "").Replace(",", "").Replace("!", "").Replace("?", "")

        Dim goalStarters() As String = {
        "i want to ",
        "i want ",
        "i am trying to ",
        "i'm trying to ",
        "i am trying ",
        "i'm trying ",
        "my goal is to ",
        "my goal is ",
        "i hope to ",
        "i plan to ",
        "i need to "
    }

        For Each starter In goalStarters
            If text.StartsWith(starter) AndAlso text.Length > starter.Length + 3 Then
                Return text.Substring(starter.Length).Trim()
            End If
        Next

        Return ""
    End Function

    Private Sub RememberGoal(goalText As String)
        If String.IsNullOrWhiteSpace(goalText) Then Exit Sub

        Dim now = DateTime.Now

        If Not longTermGoals.ContainsKey(goalText) Then
            longTermGoals(goalText) = New GoalInfo With {
            .Description = goalText,
            .Created = now,
            .LastMentioned = now,
            .ProgressScore = 0
        }
        Else
            longTermGoals(goalText).LastMentioned = now
        End If
    End Sub

    Private Sub UpdateGoalProgress(input As String)
        Dim text = input.ToLowerInvariant()

        For Each goal In longTermGoals.Values
            If text.Contains(goal.Description) Then

                If text.Contains("made progress") OrElse
               text.Contains("getting better") OrElse
               text.Contains("improving") OrElse
               text.Contains("working on it") OrElse
               text.Contains("started") Then

                    goal.ProgressScore += 1

                ElseIf text.Contains("failed") OrElse
                   text.Contains("gave up") OrElse
                   text.Contains("can't") OrElse
                   text.Contains("stuck") OrElse
                   text.Contains("not working") Then

                    goal.ProgressScore -= 1
                End If

                goal.LastMentioned = DateTime.Now
            End If
        Next
    End Sub

    Private Function RecallGoal() As String
        If longTermGoals.Count = 0 Then Return ""

        Dim goal = longTermGoals _
        .OrderByDescending(Function(g) g.Value.LastMentioned) _
        .First().Value

        Dim progressPhrase As String

        Select Case goal.ProgressScore
            Case Is >= 2
                progressPhrase = "You seem to be making progress toward"
            Case Is <= -2
                progressPhrase = "You sound discouraged about"
            Case Else
                progressPhrase = "You’ve mentioned wanting"
        End Select

        Return $"{progressPhrase} {goal.Description}. How do you feel about that now?"
    End Function

End Class
