﻿Imports System.IO

Module Program

    ' === Shared variables (QBasic SHARED ===
    Dim TotalSentences As Integer = 10
    Dim TotalVerbs, TotalAdjectives, TotalNouns, TotalNouns2 As Integer
    Dim TotalStarters, TotalPhrases, TotalAnswers As Integer

    Dim v(50), a(50), n(100), sn(100) As String
    Dim S(50), T(50), q(100), m(100) As String
    Dim u(50), w(50) As String
    Dim C(100) As Integer

    Dim UserName As String = ""
    Dim InputText As String = ""
    Dim ReplyText As String = ""

    Dim rng As New Random()

    Sub Main()
        Console.Title = "MUCAS Chat"

        ReadData()
        AskName()

        Do
            Console.Write("YOU: ")
            InputText = Console.ReadLine()

            If String.IsNullOrWhiteSpace(InputText) Then Continue Do
            If InputText.ToUpper().Contains("BYE") Then Bye()

            ComputerResponse()
        Loop
    End Sub

    Sub AskName()
        Console.Write("WHAT IS YOUR NAME? ")
        UserName = Console.ReadLine()
        Console.WriteLine($"TALK TO ME {UserName}")
    End Sub

    Sub ComputerResponse()
        Dim replyType As Integer = rng.Next(1, 9)

        If replyType <= 3 Then
            PhraseCheck()
        ElseIf replyType <= 6 Then
            AnswerBack()
        Else
            RandomSentence()
        End If
    End Sub

    Sub PhraseCheck()
        For i = 1 To TotalPhrases
            If InputText.Contains(q(i)) AndAlso C(i) = 0 Then
                C(i) += 1
                Speak(m(i))
                Return
            End If
        Next
        RandomSentence()
    End Sub

    Sub AnswerBack()
        Dim response As String = InputText

        For i = 1 To TotalAnswers
            If response.Contains(u(i)) Then
                response = response.Replace(u(i), w(i))
            End If
        Next

        Speak(response)
    End Sub

    Sub RandomSentence()
        Dim e = rng.Next(1, TotalSentences + 1)
        Dim f = rng.Next(1, TotalVerbs + 1)
        Dim g = rng.Next(1, TotalAdjectives + 1)
        Dim h = rng.Next(1, TotalNouns + 1)
        Dim h2 = rng.Next(1, TotalNouns2 + 1)
        Dim l = rng.Next(1, TotalStarters + 1)

        Select Case e
            Case 1
                ReplyText = $"WHAT DO YOU THINK ABOUT {n(h)}?"
            Case 2
                ReplyText = $"{S(l)} {UserName}, YOU DON'T THINK ALL {sn(h2)} ARE {a(g)} DO YOU?"
            Case 3
                ReplyText = $"I'VE HEARD THAT YOU ARE SOME KIND OF {a(g)} {n(h)}, {UserName}"
            Case 4
                ReplyText = $"{S(l)} {UserName}, I THINK YOU ARE JUST AS {a(g)} AS OTHERS"
            Case 5
                ReplyText = $"I AM FEELING {a(g)} NOW"
            Case 6
                ReplyText = $"LETS {v(f)} {n(h)}. I THINK {n(h)} IS {a(g)}"
            Case 7
                ReplyText = $"TELL ME ABOUT {n(h)}, {UserName}"
            Case 8
                ReplyText = $"DO YOU THINK I AM {a(g)}, {UserName}?"
            Case 9
                ReplyText = $"LETS {v(f)} SOMETHING ELSE MORE {a(g)}"
            Case Else
                ReplyText = $"GUESS WHAT I AM THINKING, {UserName}"
        End Select

        Speak(ReplyText)
    End Sub

    Sub Speak(text As String)
        Console.WriteLine("COMPUTER: " & text)
        ResetUsedResponses()
    End Sub

    Sub ResetUsedResponses()
        Dim used = C.Sum()
        If used >= TotalPhrases \ 2 Then
            Array.Clear(C, 0, C.Length)
        End If
    End Sub

    Sub Bye()
        Console.WriteLine("HAD ENOUGH ALREADY?")
        Console.WriteLine("BYE THEN.")
        Environment.Exit(0)
    End Sub

    Sub ReadData()
        LoadList("Verb.lst", v, TotalVerbs)
        LoadList("Adj.lst", a, TotalAdjectives)
        LoadList("Noun.lst", n, TotalNouns)
        LoadList("Noun2.lst", sn, TotalNouns2)
        LoadPairs("Start.lst", S, T, TotalStarters)
        LoadPairs("Phrase.lst", q, m, TotalPhrases)

        ' Embedded DATA replacement
        u(1) = "I AM" : w(1) = "YOU ARE"
        u(2) = "YOU ARE" : w(2) = "I AM"
        u(3) = "YOU" : w(3) = "ME"
        TotalAnswers = 3
    End Sub

    Sub LoadList(file As String, ByRef arr() As String, ByRef total As Integer)
        Dim lines = System.IO.File.ReadAllLines(file)
        total = Integer.Parse(lines(1))
        For i = 1 To total
            arr(i) = lines(i + 1)
        Next
    End Sub

    Sub LoadPairs(file As String, ByRef a() As String, ByRef b() As String, ByRef total As Integer)
        Dim lines = System.IO.File.ReadAllLines(file)
        total = Integer.Parse(lines(1))
        For i = 1 To total
            Dim parts = lines(i + 1).Split(","c)
            a(i) = parts(0)
            b(i) = parts(1)
        Next
    End Sub

End Module
