﻿Imports System.Drawing

Public Class Form1

    Const EMPTY As Integer = -1

    Dim XDim As Integer = 60
    Dim YDim As Integer = 40

    Dim Fish(,) As Integer
    Dim Shark(,) As Integer
    Dim FishMoved(,) As Boolean
    Dim SharkMoved(,) As Boolean
    Dim Starve(,) As Integer

    Dim FBreed As Integer = 8
    Dim SBreed As Integer = 10
    Dim StarveLimit As Integer = 3

    Dim NFish As Integer
    Dim NSharks As Integer
    Dim Chronons As Integer

    Dim rnd As New Random()
    Dim Paused As Boolean = False

    Const CellSize As Integer = 12

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Me.DoubleBuffered = True
        InitWorld()
        tmrTick.Start()
    End Sub

    Sub InitWorld()

        ReDim Fish(XDim - 1, YDim - 1)
        ReDim Shark(XDim - 1, YDim - 1)
        ReDim FishMoved(XDim - 1, YDim - 1)
        ReDim SharkMoved(XDim - 1, YDim - 1)
        ReDim Starve(XDim - 1, YDim - 1)

        For x = 0 To XDim - 1
            For y = 0 To YDim - 1
                Fish(x, y) = EMPTY
                Shark(x, y) = EMPTY
            Next
        Next

        Dim total = XDim * YDim * 9 \ 10
        NFish = total \ 2
        NSharks = total \ 20

        For i = 1 To NFish
            Dim x, y As Integer
            Do
                x = rnd.Next(XDim)
                y = rnd.Next(YDim)
            Loop While Fish(x, y) <> EMPTY
            Fish(x, y) = rnd.Next(FBreed)
        Next

        For i = 1 To NSharks
            Dim x, y As Integer
            Do
                x = rnd.Next(XDim)
                y = rnd.Next(YDim)
            Loop While Fish(x, y) <> EMPTY OrElse Shark(x, y) <> EMPTY
            Shark(x, y) = rnd.Next(SBreed)
            Starve(x, y) = rnd.Next(StarveLimit)
        Next

    End Sub

    Private Sub tmrTick_Tick(sender As Object, e As EventArgs) Handles tmrTick.Tick
        If Paused Then Return
        StepSimulation()
        pnlWorld.Invalidate()
    End Sub

    Sub StepSimulation()

        MoveFish()
        MoveSharks()

        Array.Clear(FishMoved, 0, FishMoved.Length)
        Array.Clear(SharkMoved, 0, SharkMoved.Length)

        Chronons += 1
        lblStats.Text = $"Chronons: {Chronons}   Fish: {NFish}   Sharks: {NSharks}"

    End Sub

    Sub MoveFish()

        For x = 0 To XDim - 1
            For y = 0 To YDim - 1

                If Fish(x, y) >= 0 AndAlso Not FishMoved(x, y) Then

                    Dim moves = GetEmptyNeighbors(x, y)
                    If moves.Count > 0 Then
                        Dim m = moves(rnd.Next(moves.Count))
                        Dim nx = m.X
                        Dim ny = m.Y

                        If Fish(x, y) >= FBreed Then
                            Fish(nx, ny) = 0
                            Fish(x, y) = 0
                            NFish += 1
                        Else
                            Fish(nx, ny) = Fish(x, y) + 1
                            Fish(x, y) = EMPTY
                        End If

                        FishMoved(nx, ny) = True
                    End If

                End If

            Next
        Next

    End Sub

    Sub MoveSharks()

        For x = 0 To XDim - 1
            For y = 0 To YDim - 1

                If Shark(x, y) >= 0 AndAlso Not SharkMoved(x, y) Then

                    Dim fishMoves = GetFishNeighbors(x, y)
                    Dim emptyMoves = GetEmptyNeighbors(x, y)

                    Dim nx As Integer = -1
                    Dim ny As Integer = -1

                    If fishMoves.Count > 0 Then
                        Dim m = fishMoves(rnd.Next(fishMoves.Count))
                        nx = m.X : ny = m.Y
                        Fish(nx, ny) = EMPTY
                        NFish -= 1
                        Starve(nx, ny) = 0
                    ElseIf emptyMoves.Count > 0 Then
                        Dim m = emptyMoves(rnd.Next(emptyMoves.Count))
                        nx = m.X : ny = m.Y
                        Starve(nx, ny) = Starve(x, y) + 1
                    Else
                        Shark(x, y) += 1
                        Starve(x, y) += 1
                    End If

                    If nx <> -1 Then
                        If Shark(x, y) >= SBreed Then
                            Shark(nx, ny) = 0
                            Shark(x, y) = 0
                            NSharks += 1
                        Else
                            Shark(nx, ny) = Shark(x, y) + 1
                            Shark(x, y) = EMPTY
                        End If
                        SharkMoved(nx, ny) = True
                    End If

                    If Starve(x, y) >= StarveLimit Then
                        Shark(x, y) = EMPTY
                        NSharks -= 1
                    End If

                End If

            Next
        Next

    End Sub

    Function GetNeighbors(x As Integer, y As Integer) As List(Of Point)
        Return New List(Of Point) From {
            New Point((x + XDim - 1) Mod XDim, y),
            New Point((x + 1) Mod XDim, y),
            New Point(x, (y + YDim - 1) Mod YDim),
            New Point(x, (y + 1) Mod YDim)
        }
    End Function

    Function GetEmptyNeighbors(x As Integer, y As Integer) As List(Of Point)
        Dim list As New List(Of Point)
        For Each p In GetNeighbors(x, y)
            If Fish(p.X, p.Y) = EMPTY AndAlso Shark(p.X, p.Y) = EMPTY Then
                list.Add(p)
            End If
        Next
        Return list
    End Function

    Function GetFishNeighbors(x As Integer, y As Integer) As List(Of Point)
        Dim list As New List(Of Point)
        For Each p In GetNeighbors(x, y)
            If Fish(p.X, p.Y) >= 0 AndAlso Shark(p.X, p.Y) = EMPTY Then
                list.Add(p)
            End If
        Next
        Return list
    End Function

    Private Sub pnlWorld_Paint(sender As Object, e As PaintEventArgs) Handles pnlWorld.Paint

        Dim g = e.Graphics
        g.Clear(Color.Black)

        For x = 0 To XDim - 1
            For y = 0 To YDim - 1

                Dim r As New Rectangle(x * CellSize, y * CellSize, CellSize, CellSize)

                If Fish(x, y) >= 0 Then
                    g.FillRectangle(Brushes.LightGreen, r)
                ElseIf Shark(x, y) >= 0 Then
                    g.FillRectangle(Brushes.Red, r)
                End If

            Next
        Next

    End Sub

    Private Sub btnPause_Click(sender As Object, e As EventArgs) Handles btnPause.Click
        Paused = Not Paused
        btnPause.Text = If(Paused, "Resume", "Pause")
    End Sub

    Private Sub btnStep_Click(sender As Object, e As EventArgs) Handles btnStep.Click
        If Paused Then
            StepSimulation()
            pnlWorld.Invalidate()
        End If
    End Sub

    Protected Overrides Sub OnPaintBackground(e As PaintEventArgs)
        ' DO NOTHING – prevents flicker
    End Sub

End Class
