﻿Imports System.Diagnostics
Imports System.Threading

Module WaTor

    Dim XDim As Integer
    Dim YDim As Integer

    Dim Fish(,) As Integer
    Dim Shark(,) As Integer
    Dim FishMove(,) As Boolean
    Dim SharkMove(,) As Boolean
    Dim StarveCounter(,) As Integer

    Dim FBreed As Integer
    Dim SBreed As Integer
    Dim StarveLimit As Integer

    Dim NFish As Integer
    Dim NSharks As Integer
    Dim Chronons As Integer

    Dim rnd As New Random()
    Dim SingleStep As Boolean = False

    Sub Main()

        Console.CursorVisible = False

        Console.WriteLine("Wa-Tor: Sharks and Fish Simulation")
        Console.WriteLine()

        XDim = AskInt("X Size of Wa-Tor [40]? ", 40, 2, 40)
        YDim = AskInt("Y Size of Wa-Tor [23]? ", 23, 2, 23)

        Dim totalSpots = XDim * YDim * 9 \ 10
        NFish = totalSpots \ 2
        NSharks = totalSpots \ 20

        FBreed = AskInt("Chronons for fish to breed [8]? ", 8, 1, Integer.MaxValue)
        SBreed = AskInt("Chronons for sharks to breed [10]? ", 10, 1, Integer.MaxValue)
        StarveLimit = AskInt("How long can a shark live without fish [3]? ", 3, 1, Integer.MaxValue)

        Console.Write("Chronons per second (0 = untimed) [0]? ")
        Dim perSecond = Integer.Parse(If(Console.ReadLine() = "", "0", Console.ReadLine()))

        Dim intervalMs As Integer = If(perSecond > 0, 1000 \ perSecond, 0)

        InitWorld()
        Display()

        Dim sw As New Stopwatch()

        Do While NFish > 0 AndAlso NSharks > 0

            If perSecond > 0 AndAlso Not SingleStep Then sw.Restart()

            MoveFish()
            MoveSharks()

            Chronons += 1
            Array.Clear(FishMove, 0, FishMove.Length)
            Array.Clear(SharkMove, 0, SharkMove.Length)

            Display()

            HandleInput()

            If perSecond > 0 AndAlso Not SingleStep Then
                sw.Stop()
                Dim delay = intervalMs - CInt(sw.ElapsedMilliseconds)
                If delay > 0 Then Thread.Sleep(delay)
            End If

        Loop

        Console.SetCursorPosition(0, YDim + 4)
        Console.WriteLine("Simulation ended. Press any key to exit.")
        Console.ReadKey(True)

    End Sub

    Sub InitWorld()

        ReDim Fish(XDim - 1, YDim - 1)
        ReDim Shark(XDim - 1, YDim - 1)
        ReDim FishMove(XDim - 1, YDim - 1)
        ReDim SharkMove(XDim - 1, YDim - 1)
        ReDim StarveCounter(XDim - 1, YDim - 1)

        For x = 0 To XDim - 1
            For y = 0 To YDim - 1
                Fish(x, y) = -1
                Shark(x, y) = -1
            Next
        Next

        For i = 1 To NFish
            Dim x, y As Integer
            Do
                x = rnd.Next(XDim)
                y = rnd.Next(YDim)
            Loop While Fish(x, y) <> -1
            Fish(x, y) = rnd.Next(FBreed)
        Next

        For i = 1 To NSharks
            Dim x, y As Integer
            Do
                x = rnd.Next(XDim)
                y = rnd.Next(YDim)
            Loop While Fish(x, y) <> -1 OrElse Shark(x, y) <> -1
            Shark(x, y) = rnd.Next(SBreed)
            StarveCounter(x, y) = rnd.Next(StarveLimit)
        Next

    End Sub

    Sub MoveFish()

        For x = 0 To XDim - 1
            For y = 0 To YDim - 1

                If Fish(x, y) >= 0 AndAlso Not FishMove(x, y) Then

                    Dim moves = GetFishMoves(x, y)
                    If moves.Count > 0 Then

                        Dim choice = moves(rnd.Next(moves.Count))
                        Dim nx = choice.Item1
                        Dim ny = choice.Item2

                        If Fish(x, y) >= FBreed Then
                            Fish(nx, ny) = 0
                            Fish(x, y) = 0
                            NFish += 1
                            FishMove(nx, ny) = True
                            FishMove(x, y) = True
                        Else
                            Fish(nx, ny) = Fish(x, y) + 1
                            Fish(x, y) = -1
                            FishMove(nx, ny) = True
                        End If
                    End If

                End If

            Next
        Next

    End Sub

    Sub MoveSharks()

        For x = 0 To XDim - 1
            For y = 0 To YDim - 1

                If Shark(x, y) >= 0 AndAlso Not SharkMove(x, y) Then

                    Dim fishMoves = GetSharkMoves(x, y, True)
                    Dim emptyMoves = GetSharkMoves(x, y, False)

                    Dim nx = -1, ny = -1

                    If fishMoves.Count > 0 Then
                        Dim c = fishMoves(rnd.Next(fishMoves.Count))
                        nx = c.Item1 : ny = c.Item2
                        NFish -= 1
                        Fish(nx, ny) = -1
                        StarveCounter(nx, ny) = 0
                    ElseIf emptyMoves.Count > 0 Then
                        Dim c = emptyMoves(rnd.Next(emptyMoves.Count))
                        nx = c.Item1 : ny = c.Item2
                        StarveCounter(nx, ny) = StarveCounter(x, y) + 1
                    Else
                        Shark(x, y) += 1
                        StarveCounter(x, y) += 1
                    End If

                    If nx <> -1 Then
                        If Shark(x, y) >= SBreed Then
                            Shark(nx, ny) = 0
                            Shark(x, y) = 0
                            NSharks += 1
                        Else
                            Shark(nx, ny) = Shark(x, y) + 1
                            Shark(x, y) = -1
                        End If
                        SharkMove(nx, ny) = True
                    End If

                    If StarveCounter(x, y) >= StarveLimit Then
                        Shark(x, y) = -1
                        NSharks -= 1
                    End If

                End If

            Next
        Next

    End Sub

    Function GetFishMoves(x As Integer, y As Integer) As List(Of Tuple(Of Integer, Integer))

        Dim list As New List(Of Tuple(Of Integer, Integer))
        For Each d In Neighbors(x, y)
            If Fish(d.Item1, d.Item2) = -1 AndAlso Shark(d.Item1, d.Item2) = -1 Then
                list.Add(d)
            End If
        Next
        Return list

    End Function

    Function GetSharkMoves(x As Integer, y As Integer, wantFish As Boolean) As List(Of Tuple(Of Integer, Integer))

        Dim list As New List(Of Tuple(Of Integer, Integer))
        For Each d In Neighbors(x, y)
            If Shark(d.Item1, d.Item2) = -1 Then
                If wantFish AndAlso Fish(d.Item1, d.Item2) >= 0 Then list.Add(d)
                If Not wantFish AndAlso Fish(d.Item1, d.Item2) = -1 Then list.Add(d)
            End If
        Next
        Return list

    End Function

    Function Neighbors(x As Integer, y As Integer) As List(Of Tuple(Of Integer, Integer))

        Return New List(Of Tuple(Of Integer, Integer)) From {
            Tuple.Create((x + XDim - 1) Mod XDim, y),
            Tuple.Create((x + 1) Mod XDim, y),
            Tuple.Create(x, (y + YDim - 1) Mod YDim),
            Tuple.Create(x, (y + 1) Mod YDim)
        }

    End Function

    Sub Display()

        Console.SetCursorPosition(0, 0)
        For y = 0 To YDim - 1
            For x = 0 To XDim - 1
                If Fish(x, y) >= 0 Then
                    Console.Write("o ")
                ElseIf Shark(x, y) >= 0 Then
                    Console.Write(ChrW(254) & " ")
                Else
                    Console.Write(ChrW(250) & " ")
                End If
            Next
            Console.WriteLine()
        Next

        Console.WriteLine()
        Console.WriteLine($"Chronons: {Chronons}   Fish: {NFish}   Sharks: {NSharks}")
        Console.WriteLine("P = Pause / Step    E = Exit")

    End Sub

    Sub HandleInput()

        If Console.KeyAvailable Then
            Select Case Console.ReadKey(True).Key
                Case ConsoleKey.P
                    SingleStep = Not SingleStep
                Case ConsoleKey.E
                    Environment.Exit(0)
            End Select
        End If

    End Sub

    Function AskInt(prompt As String, def As Integer, min As Integer, max As Integer) As Integer

        Do
            Console.Write(prompt)
            Dim s = Console.ReadLine()
            If s = "" Then Return def
            Dim v As Integer
            If Integer.TryParse(s, v) AndAlso v >= min AndAlso v <= max Then Return v
        Loop

    End Function

End Module
