﻿Imports System.Windows.Forms
Imports System.Windows.Forms.VisualStyles.VisualStyleElement.Menu

Public Class FindReplaceDialog
    Public Event FindNext(searchText As String, matchCase As Boolean, searchDown As Boolean)
    Public Event ReplaceNext(searchText As String, replaceText As String, matchCase As Boolean, searchDown As Boolean)
    Public Event ReplaceAll(searchText As String, replaceText As String, matchCase As Boolean)

    Private Sub FindReplaceDialog_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        FormBorderStyle = FormBorderStyle.FixedDialog
        MaximizeBox = False
        MinimizeBox = False
        StartPosition = FormStartPosition.CenterParent
        Text = "Find and Replace"
        cboFind.DropDownStyle = ComboBoxStyle.DropDown
        cboReplace.DropDownStyle = ComboBoxStyle.DropDown
        cboFind.Focus()
    End Sub

    Private Sub btnFindNext_Click(sender As Object, e As EventArgs) Handles btnFindNext.Click
        RaiseEvent FindNext(cboFind.Text, chkMatchCase.Checked, rdoDown.Checked)
    End Sub

    Private Sub btnReplace_Click(sender As Object, e As EventArgs) Handles btnReplace.Click
        RaiseEvent ReplaceNext(cboFind.Text, cboReplace.Text, chkMatchCase.Checked, rdoDown.Checked)
    End Sub

    Private Sub btnReplaceAll_Click(sender As Object, e As EventArgs) Handles btnReplaceAll.Click
        RaiseEvent ReplaceAll(cboFind.Text, cboReplace.Text, chkMatchCase.Checked)
    End Sub

    Private Sub btnCancel_Click(sender As Object, e As EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub
End Class
