﻿Imports System.Drawing.Printing
Imports System.Runtime.InteropServices

Public Class Form1
    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        ' Example: Open File Dialog
        Dim dlg As New OpenFileDialog()
        dlg.Filter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*"
        dlg.Title = "Select a File"

        If dlg.ShowDialog() = DialogResult.OK Then
            MessageBox.Show("You selected: " & dlg.FileName)
        End If
    End Sub

    Private Sub Button2_Click(sender As Object, e As EventArgs) Handles Button2.Click
        ' Example: Save File Dialog
        Dim saveDlg As New SaveFileDialog()
        saveDlg.Filter = "Text Files (*.txt)|*.txt"
        If saveDlg.ShowDialog() = DialogResult.OK Then
            IO.File.WriteAllText(saveDlg.FileName, "Hello World!")
        End If
    End Sub

    Private Sub Button3_Click(sender As Object, e As EventArgs) Handles Button3.Click
        ' Example: Choose Color
        Dim colorDlg As New ColorDialog()
        If colorDlg.ShowDialog() = DialogResult.OK Then
            Me.BackColor = colorDlg.Color
        End If
    End Sub

    Private Sub Button4_Click(sender As Object, e As EventArgs) Handles Button4.Click
        ' Example: Choose Font
        Dim fontDlg As New FontDialog()
        If fontDlg.ShowDialog() = DialogResult.OK Then
            Me.Font = fontDlg.Font
        End If
    End Sub

    Private Sub Button5_Click(sender As Object, e As EventArgs) Handles Button5.Click
        Try
            Dim path As String = NativeOpenFileDialog.ShowNativeOpenFileDialog(Me.Handle)
            If path IsNot Nothing Then
                MessageBox.Show("Selected: " & path)
            Else
                MessageBox.Show("Cancelled")
            End If
        Catch ex As Exception
            MessageBox.Show("Dialog error: " & ex.Message)
        End Try
    End Sub

    Private Sub Button6_Click(sender As Object, e As EventArgs) Handles Button6.Click
        Dim colorArgb = NativeChooseColor.ShowNativeChooseColor(Me.Handle)
        If colorArgb.HasValue Then
            MessageBox.Show($"Selected color ARGB: {colorArgb.Value:X8}")
        Else
            MessageBox.Show("Color selection cancelled")
        End If
    End Sub

    Private Sub Button7_Click(sender As Object, e As EventArgs) Handles Button7.Click
        Dim fontChoice = NativeChooseFont.ShowNativeChooseFont(Me.Handle)
        If fontChoice.HasValue Then
            MessageBox.Show($"Selected font: {fontChoice.Value.FontName}, Size: {fontChoice.Value.Size}")
        Else
            MessageBox.Show("Font selection cancelled")
        End If
    End Sub

    Private Sub Button8_Click(sender As Object, e As EventArgs) Handles Button8.Click
        Try
            Dim path As String = NativeSaveFileDialog.ShowNativeSaveFileDialog(Me.Handle,
                                                                               defaultExtension:="txt",
                                                                               dialogTitle:="Save your document",
                                                                               defaultFileName:="Untitled.txt",
                                                                               filter:="Text Files (*.txt)" & vbNullChar & "*.txt" & vbNullChar &
                                                                                       "All Files (*.*)" & vbNullChar & "*.*" & vbNullChar)
            If path IsNot Nothing Then
                MessageBox.Show("File selected to save: " & path)
            Else
                MessageBox.Show("Save cancelled.")
            End If
        Catch ex As Exception
            MessageBox.Show("Dialog error: " & ex.Message)
        End Try
    End Sub

    Private Sub Button9_Click(sender As Object, e As EventArgs) Handles Button9.Click
        If NativePrintDialog.ShowNativePrintDialog(Me.Handle) Then
            MessageBox.Show("Print confirmed")
        Else
            MessageBox.Show("Print cancelled")
        End If
    End Sub

    Private Sub Button10_Click(sender As Object, e As EventArgs) Handles Button10.Click
        If NativePageSetup.ShowNativePageSetup(Me.Handle) Then
            MessageBox.Show("Page setup confirmed")
        Else
            MessageBox.Show("Page setup cancelled")
        End If
    End Sub

    Private Sub Button11_Click(sender As Object, e As EventArgs) Handles Button11.Click
        ShowBuiltInPrintDialog()
    End Sub

    Public Sub ShowBuiltInPrintDialog()
        ' Check for printers first
        ''If Not HasPrintersInstalled() Then
        ''MessageBox.Show("No printers are installed on this computer.")
        ''Exit Sub
        ''End If

        ' Create and configure the dialog
        Using printDialog As New PrintDialog()
            printDialog.AllowSomePages = True
            printDialog.AllowSelection = True
            printDialog.UseEXDialog = True  ' modern style

            ' Assign a PrintDocument object
            Dim doc As New PrintDocument()
            doc.DocumentName = "My Test Document"
            printDialog.Document = doc

            ' Show dialog
            If printDialog.ShowDialog() = DialogResult.OK Then
                ' Perform printing
                doc.Print()
                MessageBox.Show("Document sent to printer: " & doc.PrinterSettings.PrinterName)
            Else
                MessageBox.Show("Print cancelled.")
            End If
        End Using
    End Sub

    Private Sub Button12_Click(sender As Object, e As EventArgs) Handles Button12.Click
        ShowFindReplaceDialog()
    End Sub

    Private Sub Button13_Click(sender As Object, e As EventArgs) Handles Button13.Click
        Dim file = ShowModernFileOpenDialog(Me.Handle)
        If file IsNot Nothing Then
            MessageBox.Show("Selected file: " & file)
        Else
            MessageBox.Show("User cancelled the dialog.")
        End If
    End Sub

    Private Function PtrToString(ptr As IntPtr) As String
        If ptr = IntPtr.Zero Then Return Nothing
        Dim result = Marshal.PtrToStringUni(ptr)
        Marshal.FreeCoTaskMem(ptr)
        Return result
    End Function

    Public Function ShowModernFileOpenDialog(ownerHandle As IntPtr) As String
        ' CLSID for FileOpenDialog
        Dim clsid As New Guid("DC1C5A9C-E88A-4DDE-A5A1-60F82A20AEF7")

        ' Create COM object
        Dim obj As Object = Activator.CreateInstance(Type.GetTypeFromCLSID(clsid))
        Dim dlg As IFileOpenDialog = CType(obj, IFileOpenDialog)

        ' Show dialog
        Dim hr As Integer = dlg.Show(ownerHandle)
        If hr <> 0 Then Return Nothing ' user canceled

        ' For simplicity, we won’t retrieve IShellItem here
        Return "Dialog closed successfully"
    End Function

    Private Sub Button14_Click(sender As Object, e As EventArgs) Handles Button14.Click
        ''System.IO.Path.GetFileName(fullPath)

        Dim path As String = "C:\Users\Alice\Documents\TestFile.txt"
        Dim fileName As String = NativeGetFileTitle.ExtractFileName(path)
        MessageBox.Show("File name: " & fileName) ' Output: "TestFile.txt"
    End Sub

    Private Sub ShowFindReplaceDialog()
        Dim dlg As New FindReplaceDialog()
        AddHandler dlg.FindNext, AddressOf OnFindNext
        AddHandler dlg.ReplaceNext, AddressOf OnReplaceNext
        AddHandler dlg.ReplaceAll, AddressOf OnReplaceAll
        dlg.Show(Me) ' modeless, like Notepad
    End Sub

    Private Sub OnFindNext(searchText As String, matchCase As Boolean, searchDown As Boolean)
        If String.IsNullOrEmpty(searchText) Then Return

        Dim comparison = If(matchCase, StringComparison.Ordinal, StringComparison.OrdinalIgnoreCase)
        Dim i As Integer = -1

        ' Determine starting position
        Dim startIndex As Integer = txtEditor.SelectionStart
        If searchDown Then
            startIndex += txtEditor.SelectionLength
            If startIndex > txtEditor.TextLength Then startIndex = txtEditor.TextLength
            i = txtEditor.Text.IndexOf(searchText, startIndex, comparison)
        Else
            If startIndex > 0 Then startIndex -= 1
            i = txtEditor.Text.LastIndexOf(searchText, startIndex, comparison)
        End If

        If i >= 0 Then
            txtEditor.SelectionStart = i
            txtEditor.SelectionLength = searchText.Length
            If txtEditor.CanFocus Then txtEditor.Focus()
            txtEditor.ScrollToCaret()
        Else
            MessageBox.Show("Text not found.", "Find", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End If
    End Sub

    Private Sub OnReplaceNext(searchText As String, replaceText As String, matchCase As Boolean, searchDown As Boolean)
        If String.IsNullOrEmpty(searchText) Then Return

        ' Replace current match if selected text matches search text
        Dim currentSelection As String = txtEditor.SelectedText
        Dim comparison = If(matchCase, StringComparison.Ordinal, StringComparison.OrdinalIgnoreCase)

        If currentSelection.Equals(searchText, comparison) Then
            txtEditor.SelectedText = replaceText
        End If

        ' Move to next match
        OnFindNext(searchText, matchCase, searchDown)
    End Sub

    Private Sub OnReplaceAll(searchText As String, replaceText As String, matchCase As Boolean)
        If String.IsNullOrEmpty(searchText) Then Return

        Dim comparison = If(matchCase, StringComparison.Ordinal, StringComparison.OrdinalIgnoreCase)
        Dim count As Integer = 0
        Dim builder As New System.Text.StringBuilder(txtEditor.Text)
        Dim i As Integer = 0

        While True
            i = builder.ToString().IndexOf(searchText, i, comparison)
            If i < 0 Then Exit While
            builder.Remove(i, searchText.Length)
            builder.Insert(i, replaceText)
            i += replaceText.Length
            count += 1
        End While

        txtEditor.Text = builder.ToString()
        MessageBox.Show($"{count} occurrence(s) replaced.", "Replace All", MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub

End Class
