﻿Imports System
Imports System.Runtime.InteropServices

Module NativeChooseColor

    <StructLayout(LayoutKind.Sequential)>
    Private Structure CHOOSECOLOR2
        Public lStructSize As Integer
        Public hwndOwner As IntPtr
        Public hInstance As IntPtr
        Public rgbResult As UInteger
        Public lpCustColors As IntPtr
        Public Flags As UInteger
        Public lCustData As IntPtr
        Public lpfnHook As IntPtr
        Public lpTemplateName As IntPtr
    End Structure

    <DllImport("comdlg32.dll", CharSet:=CharSet.Auto, SetLastError:=True)>
    Private Function ChooseColor(ByRef cc As CHOOSECOLOR2) As Boolean
    End Function

    ''' <summary>
    ''' Shows the native Windows color picker dialog.
    ''' Returns selected color as ARGB integer, or Nothing if cancelled.
    ''' </summary>
    Public Function ShowNativeChooseColor(Optional ownerHandle As IntPtr = Nothing) As Integer?
        Dim cc As New CHOOSECOLOR2()
        Dim custColors(15) As UInteger
        Dim custColorsPtr As IntPtr = Marshal.AllocHGlobal(custColors.Length * 4)

        Try
            ' Copy initial custom colors to unmanaged memory
            Marshal.Copy(Array.ConvertAll(custColors, Function(c) CInt(c)), 0, custColorsPtr, custColors.Length)

            cc.lStructSize = Marshal.SizeOf(Of CHOOSECOLOR2)()
            cc.hwndOwner = ownerHandle
            cc.lpCustColors = custColorsPtr
            cc.Flags = &H1 ' CC_RGBINIT
            cc.rgbResult = 0

            Dim ok As Boolean = ChooseColor(cc)
            If ok Then
                Return CInt(cc.rgbResult)
            Else
                Return Nothing
            End If
        Finally
            If custColorsPtr <> IntPtr.Zero Then Marshal.FreeHGlobal(custColorsPtr)
        End Try
    End Function

End Module

