﻿Imports System
Imports System.Runtime.InteropServices
Imports System.Text

Module NativeChooseFont

    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Auto)>
    Private Structure LOGFONT
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=32)>
        Public lfFaceName As String
        Public lfHeight As Integer
        Public lfWidth As Integer
        Public lfEscapement As Integer
        Public lfOrientation As Integer
        Public lfWeight As Integer
        Public lfItalic As Byte
        Public lfUnderline As Byte
        Public lfStrikeOut As Byte
        Public lfCharSet As Byte
        Public lfOutPrecision As Byte
        Public lfClipPrecision As Byte
        Public lfQuality As Byte
        Public lfPitchAndFamily As Byte
    End Structure

    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Auto)>
    Private Structure CHOOSEFONT2
        Public lStructSize As Integer
        Public hwndOwner As IntPtr
        Public hDC As IntPtr
        Public lpLogFont As IntPtr
        Public iPointSize As Integer
        Public Flags As UInteger
        Public rgbColors As UInteger
        Public lCustData As IntPtr
        Public lpfnHook As IntPtr
        Public lpTemplateName As IntPtr
        Public hInstance As IntPtr
        Public lpszStyle As IntPtr
        Public nFontType As UShort
        Public ___MISSING_ALIGNMENT__ As UShort ' alignment placeholder
        Public nSizeMin As Integer
        Public nSizeMax As Integer
    End Structure

    <DllImport("comdlg32.dll", CharSet:=CharSet.Auto, SetLastError:=True)>
    Private Function ChooseFont(ByRef cf As CHOOSEFONT2) As Boolean
    End Function

    ''' <summary>
    ''' Shows the native Windows Font Picker dialog.
    ''' Returns selected font name and size, or Nothing if cancelled.
    ''' </summary>
    Public Function ShowNativeChooseFont(Optional ownerHandle As IntPtr = Nothing) As (FontName As String, Size As Integer)?
        Dim lf As New LOGFONT()
        Dim lfPtr As IntPtr = Marshal.AllocHGlobal(Marshal.SizeOf(Of LOGFONT)())
        Marshal.StructureToPtr(lf, lfPtr, False)

        Dim cf As New CHOOSEFONT2()
        cf.lStructSize = Marshal.SizeOf(Of CHOOSEFONT2)()
        cf.hwndOwner = ownerHandle
        cf.lpLogFont = lfPtr
        cf.Flags = &H40 Or &H2 ' CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT

        Try
            Dim ok As Boolean = ChooseFont(cf)
            If ok Then
                Dim selectedLf As LOGFONT = Marshal.PtrToStructure(Of LOGFONT)(lfPtr)
                ' Height is in logical units; approximate point size
                Dim pointSize As Integer = Math.Abs(selectedLf.lfHeight * 72 / 96)
                Return (selectedLf.lfFaceName, pointSize)
            Else
                Return Nothing
            End If
        Finally
            Marshal.FreeHGlobal(lfPtr)
        End Try
    End Function

End Module
