﻿Imports System.Runtime.InteropServices

Module NativePageSetup
    <StructLayout(LayoutKind.Sequential)>
    Private Structure PAGESETUPDLG2
        Public lStructSize As Integer
        Public hwndOwner As IntPtr
        Public hDevMode As IntPtr
        Public hDevNames As IntPtr
        Public Flags As Integer
        Public ptPaperSizeX As Integer
        Public ptPaperSizeY As Integer
        Public rtMinMarginLeft As Integer
        Public rtMinMarginTop As Integer
        Public rtMinMarginRight As Integer
        Public rtMinMarginBottom As Integer
        Public rtMarginLeft As Integer
        Public rtMarginTop As Integer
        Public rtMarginRight As Integer
        Public rtMarginBottom As Integer
        Public hInstance As IntPtr
        Public lCustData As IntPtr
        Public lpfnPageSetupHook As IntPtr
        Public lpfnPagePaintHook As IntPtr
        Public lpPageSetupTemplateName As IntPtr
        Public hPageSetupTemplate As IntPtr
    End Structure

    <DllImport("comdlg32.dll", CharSet:=CharSet.Auto, SetLastError:=True)>
    Private Function PageSetupDlg(ByRef psd As PAGESETUPDLG2) As Boolean
    End Function

    Public Function ShowNativePageSetup(Optional ownerHandle As IntPtr = Nothing) As Boolean
        Dim psd As New PAGESETUPDLG2()
        psd.lStructSize = Marshal.SizeOf(Of PAGESETUPDLG2)()
        psd.hwndOwner = ownerHandle
        psd.Flags = 0
        Return PageSetupDlg(psd)
    End Function
End Module

