﻿Imports System.Drawing.Printing
Imports System.Runtime.InteropServices

Module NativePrintDialog
    <StructLayout(LayoutKind.Sequential)>
    Private Structure PRINTDLG2
        Public lStructSize As Integer
        Public hwndOwner As IntPtr
        Public hDevMode As IntPtr
        Public hDevNames As IntPtr
        Public hDC As IntPtr
        Public Flags As Integer
        Public nFromPage As Short
        Public nToPage As Short
        Public nMinPage As Short
        Public nMaxPage As Short
        Public nCopies As Short
        Public hInstance As IntPtr
        Public lCustData As IntPtr
        Public lpfnPrintHook As IntPtr
        Public lpfnSetupHook As IntPtr
        Public lpPrintTemplateName As IntPtr
        Public lpSetupTemplateName As IntPtr
        Public hPrintTemplate As IntPtr
        Public hSetupTemplate As IntPtr
    End Structure

    <DllImport("comdlg32.dll", CharSet:=CharSet.Auto, SetLastError:=True)>
    Private Function PrintDlg(ByRef pd As PRINTDLG2) As Boolean
    End Function

    Public Function HasPrintersInstalled() As Boolean
        Try
            ' Safely check installed printers
            Dim count As Integer = PrinterSettings.InstalledPrinters.Count
            Return count > 0
        Catch ex As Exception
            ' If any printing subsystem error occurs, treat as no printers
            Return False
        End Try
    End Function

    Public Function ShowNativePrintDialog(Optional ownerHandle As IntPtr = Nothing) As Boolean
        If Not HasPrintersInstalled() Then
            MessageBox.Show("No printers are installed. Please add a printer first.")
            Exit Function
        End If
        Dim pd As New PRINTDLG2()
        pd.lStructSize = Marshal.SizeOf(Of PRINTDLG2)()
        pd.hwndOwner = ownerHandle
        pd.Flags = &H4 Or &H2 ' PD_RETURNDC | PD_USEDEVMODECOPIESANDCOLLATE
        Dim ok As Boolean = PrintDlg(pd)
        Return ok
    End Function
End Module

