﻿Imports System.Drawing

Public Class MapForm
    Private treasures As New List(Of Point)
    Private uiFont As New Font("Segoe UI", 12, FontStyle.Regular)

    Public Sub New()
        InitializeComponent()
        Me.Text = "Treasure Map"
        Me.Size = New Size(300, 250)
        Me.BackColor = Color.Beige
        Me.DoubleBuffered = True
        Me.Font = uiFont
    End Sub


    Public Sub UpdateMap(newTreasures As List(Of Point))
        treasures = New List(Of Point)(newTreasures)
        Me.Invalidate()
    End Sub

    Protected Overrides Sub OnPaint(e As PaintEventArgs)
        MyBase.OnPaint(e)
        Dim g As Graphics = e.Graphics

        If treasures.Count = 0 Then
            Using drawFont As New Font("Segoe UI", 12, FontStyle.Regular)
                g.DrawString("No treasures buried or all found!", drawFont, Brushes.Black, 20, 100)
            End Using
        Else
            For Each t In treasures
                Dim scaledX As Integer = CInt(t.X / 2.5)
                Dim scaledY As Integer = CInt((t.Y - 50) / 2.5)
                g.FillEllipse(Brushes.Gold, scaledX - 5, scaledY - 5, 10, 10)
                g.DrawEllipse(Pens.Brown, scaledX - 5, scaledY - 5, 10, 10)
            Next
        End If
    End Sub

End Class

