﻿Imports System.IO

Public Class Form1
    ' Game parameters
    Private gridSize As Integer
    Private maxAttempts As Integer
    Private treasureCount As Integer
    Private treasures As New List(Of Treasure)
    Private discovered As New List(Of Treasure)
    Private score As Integer
    Private attemptsLeft As Integer

    ' High scores file
    Private highScoreFile As String = "highscores.txt"

    ' UI Controls (assumed to be added via Designer)
    ' ComboBox: cbDifficulty
    ' Button: btnStart
    ' Button: btnRestart
    ' Panel: panelGrid
    ' Label: lblScore, lblAttempts, lblRemainingTreasures
    ' ListBox: lbHighScores

    Private gridButtons As New List(Of Button)

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        cbDifficulty.Items.AddRange(New String() {"Easy", "Medium", "Hard"})
        cbDifficulty.SelectedIndex = 0
        LoadHighScores()
        gridSize = 8
        SelectDifficulty()
        InitializeGame()
        CreateGrid()
        btnStart.Enabled = False
        btnRestart.Enabled = True
    End Sub

    Private Sub btnStart_Click(sender As Object, e As EventArgs) Handles btnStart.Click
        SelectDifficulty()
        InitializeGame()
        CreateGrid()
        UpdateStatus()
        btnRestart.Enabled = True
        btnStart.Enabled = False
    End Sub

    Private Sub btnRestart_Click(sender As Object, e As EventArgs) Handles btnRestart.Click
        InitializeGame()
        CreateGrid()
        UpdateStatus()
    End Sub

    Private Sub SelectDifficulty()
        Select Case cbDifficulty.SelectedItem.ToString()
            Case "Easy"
                gridSize = 8
                treasureCount = 5
                maxAttempts = 20
            Case "Medium"
                gridSize = 12
                treasureCount = 10
                maxAttempts = 25
            Case "Hard"
                gridSize = 15
                treasureCount = 15
                maxAttempts = 30
            Case Else
                gridSize = 8
                treasureCount = 5
                maxAttempts = 20
        End Select
    End Sub

    Private Sub InitializeGame()
        score = 0
        attemptsLeft = maxAttempts
        treasures.Clear()
        discovered.Clear()
        panelGrid.Controls.Clear()
        gridButtons.Clear()
        GenerateTreasures()
        CreateGrid()
        UpdateStatus()
        lblRemainingTreasures.Text = $"Remaining: {treasureCount}"
    End Sub

    Private Sub GenerateTreasures()
        Dim rand As New Random()
        Dim types() As String = {"Coin", "Pebble", "Bead"}
        treasures = New List(Of Treasure)

        While treasures.Count < treasureCount
            Dim r As Integer = rand.Next(0, gridSize)
            Dim c As Integer = rand.Next(0, gridSize)
            If Not treasures.Any(Function(t) t.Row = r And t.Col = c) Then
                Dim tType As String = types(rand.Next(types.Length))
                treasures.Add(New Treasure(r, c, tType))
            End If
        End While
    End Sub

    Private Sub CreateGrid()
        Dim btnSize As Integer = Math.Min(40, panelGrid.Width \ gridSize)
        For i As Integer = 0 To gridSize - 1
            For j As Integer = 0 To gridSize - 1
                Dim btn As New Button()
                btn.Width = btnSize
                btn.Height = btnSize
                btn.Location = New Point(j * btnSize, i * btnSize)
                btn.Tag = New Point(i, j)
                AddHandler btn.Click, AddressOf GridButton_Click
                panelGrid.Controls.Add(btn)
                gridButtons.Add(btn)
            Next
        Next
    End Sub

    Private Sub GridButton_Click(sender As Object, e As EventArgs)
        Dim btn As Button = CType(sender, Button)
        Dim pos As Point = CType(btn.Tag, Point)
        Dim row As Integer = pos.X
        Dim col As Integer = pos.Y

        ' Check if already searched
        If btn.BackColor = Color.LightGreen OrElse btn.BackColor = Color.Red Then
            MessageBox.Show("Already searched here.")
            Return
        End If

        Dim treasure = treasures.FirstOrDefault(Function(t) t.Row = row And t.Col = col)
        If treasure IsNot Nothing Then
            btn.BackColor = Color.LightGreen
            btn.Text = GetSymbol(treasure.Type)
            score += 10
            discovered.Add(treasure)
            lblRemainingTreasures.Text = $"Remaining: {treasureCount - discovered.Count}"
            MessageBox.Show($"You found a {treasure.Type}!")
        Else
            btn.BackColor = Color.Red
            ''MessageBox.Show("No treasure here.")
        End If

        attemptsLeft -= 1
        UpdateStatus()

        If discovered.Count = treasures.Count Then
            MessageBox.Show($"Congratulations! You found all treasures!" + vbNewLine + $"Score: {score}")
            EndGame()
        ElseIf attemptsLeft = 0 Then
            MessageBox.Show($"Game Over! Out of attempts." + vbNewLine + $"Score: {score}")
            EndGame()
        End If
    End Sub

    Private Function GetSymbol(tType As String) As String
        Select Case tType
            Case "Coin" : Return "$"
            Case "Pebble" : Return "o"
            Case "Bead" : Return "@"
            Case Else : Return "?"
        End Select
    End Function

    Private Sub UpdateStatus()
        lblScore.Text = $"Score: {score}"
        lblAttempts.Text = $"Attempts: {attemptsLeft}"
    End Sub

    Private Sub EndGame()
        SaveHighScore()
        LoadHighScores()
        ' Disable grid buttons
        For Each btn In gridButtons
            btn.Enabled = False
        Next
        btnRestart.Enabled = True
    End Sub

    Private Sub SaveHighScore()
        Dim scores As New List(Of Integer)
        If File.Exists(highScoreFile) Then
            For Each line In File.ReadAllLines(highScoreFile)
                Dim val As Integer
                If Integer.TryParse(line, val) Then scores.Add(val)
            Next
        End If
        scores.Add(score)
        scores.Sort()
        scores.Reverse()
        File.WriteAllLines(highScoreFile, scores.Take(5).Select(Function(s) s.ToString()))
    End Sub

    Private Sub LoadHighScores()
        lbHighScores.Items.Clear()
        If File.Exists(highScoreFile) Then
            For Each line In File.ReadAllLines(highScoreFile)
                lbHighScores.Items.Add(line)
            Next
        End If
    End Sub

    Private Sub cbDifficulty_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cbDifficulty.SelectedIndexChanged
        btnStart.Enabled = True
        btnRestart.Enabled = False
        For Each btn In gridButtons
            btn.Enabled = False
        Next
    End Sub

    Private Sub btnQuit_Click(sender As Object, e As EventArgs) Handles btnQuit.Click
        End
    End Sub
End Class

Public Class Treasure
    Public Property Row As Integer
    Public Property Col As Integer
    Public Property Type As String
    Public Sub New(r As Integer, c As Integer, t As String)
        Row = r
        Col = c
        Type = t
    End Sub
End Class
