///
///  This source code is freeware and is provided on an "as is" basis without warranties of any kind, 
///  whether express or implied, including without limitation warranties that the code is free of defect, 
///  fit for a particular purpose or non-infringing.  The entire risk as to the quality and performance of 
///  the code is with the end user.
///
///  Created by Stefan Goner (stefang@microsoft.com)
///
///  Latest Updates: 
///      V1.0  include Mac client support
///      V1.1  correct buffer size problem 1
///      V1.2  correct buffer size problem 2
///

using System;
using System.IO;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.WebControls;


namespace StefanG.ASPNET20_HttpModule
{

	public class ASPNET20_Filter : Stream 
	{
		private Encoding enc = null;
		private bool closed;
		Stream BaseStream;

		public ASPNET20_Filter(Stream baseStream, Encoding encoding)
		{
			BaseStream = baseStream;
			closed = false;
			enc = encoding;
		}
		
		public override void Write(byte[] buffer, int offset, int count) 
		{

			if(Closed) throw new ObjectDisposedException("ASPNET20_Filter");

			string content = enc.GetString(buffer,offset,count);
			byte[] newBuffer = enc.GetBytes(content);
			int pos = content.IndexOf("<form ");
			while (pos >= 0)
			{
				int endpos = content.IndexOf(">",pos);
				int namepos = content.IndexOf("name=",pos);
				int idpos = content.IndexOf("id=",pos);

				// only modify content if name attribute is not present
				if (namepos == -1 || namepos > endpos)
				{
					pos = idpos+"id=\"".Length;
					endpos = content.IndexOf("\"",pos);
					if (endpos > 0)
					{
						string idString = content.Substring(pos,endpos-pos);

						// add a name attribute with the same value as the ID attribute
						content = content.Insert(idpos,"name=\""+idString+"\" ");

						newBuffer = enc.GetBytes(content);
						break;
					}
				}
				pos = content.IndexOf("<form",pos+1);
			}
			count = newBuffer.Length;
			BaseStream.Write(newBuffer, 0, count);
		}

		public override bool CanRead
		{	
			get { return false; }
		}

		public override bool CanWrite 
		{
			get { return !closed; }
		}

		public override bool CanSeek 
		{
			get { return false; }
		}

		public override void Close() 
		{
			closed = true;
			BaseStream.Close();
		}

		protected bool Closed 
		{
			get { return closed; }
		}

		public override void Flush() 
		{
			BaseStream.Flush();
		}

		public override int Read(byte[] buffer, int offset, int count) 
		{
			throw new NotSupportedException();
		}

		public override long Length 
		{
			get { throw new NotSupportedException(); }
		}

		public override long Seek(long offset, SeekOrigin origin) 
		{
			throw new NotSupportedException();
		}

		public override void SetLength(long value) 
		{
			throw new NotSupportedException();
		}

		public override long Position 
		{
			get { throw new NotSupportedException(); }
			set { throw new NotSupportedException(); }
		}
	}



	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	public class ForceMCMScompatibility : IHttpModule 
	{
		public void Init(HttpApplication httpApp) 
		{
			httpApp.PreRequestHandlerExecute += new EventHandler(this.OnPreRequestHandlerExecute);
		}

		public void Dispose() 
		{
			// Nothing to do.
		}

		public void OnPreRequestHandlerExecute(object sender, EventArgs e) 
		{
			HttpContext ctx = ((HttpApplication)sender).Context;
			IHttpHandler handler = ctx.Handler;

			try
			{
				// only take action if we are inside a channel item
				if (CmsHttpContext.Current.ChannelItem != null)
				{
					// register http filter for ASPNET 2.0 compatibility
					ASPNET20_Filter aspnet20_filter = new ASPNET20_Filter(ctx.Response.Filter, ctx.Response.ContentEncoding);
					ctx.Response.Filter = aspnet20_filter;
				}
			
				if ((CmsHttpContext.Current.Posting != null) && 
					((WebAuthorContext.Current.Mode == WebAuthorContextMode.AuthoringNew) |
					 (WebAuthorContext.Current.Mode == WebAuthorContextMode.AuthoringReedit) 
//                     |
//                     (WebAuthorContext.Current.Mode == WebAuthorContextMode.PresentationUnpublished)
                    )) 
					((System.Web.UI.Page)handler).Init += new EventHandler(	this.OnInit );
			}
			catch
			{
				// this will happen if the request is in the middle of an expired forms authentication login
				// we just ignore this.
			}
		}

        private const string overrideASPXPostback =
            "\n" +
			"<!-- Updated by ASP.NET compliancy module -->\n" +
			"<!-- Generated by Microsoft.ContentManagement.WebControls.Console -->\n" +
			"<SCRIPT language=\"javascript\" type=\"text/javascript\">\n" +
            "<!--\n" +
            "   var __consoleCachedOriginalPostBack;\n" +
            "\n" +
            "   if( eval(\"window.__doPostBack\") != null )\n" +
            "   {\n" +
            "       __consoleCachedOriginalPostBack = __doPostBack;\n" +
            "       __doPostBack = __consoleCustomDoPostBack;\n" +
            "   }\n" +
            "\n" +
            "   __consoleCachedOriginalOnSubmit = __CMS_PostbackForm.onsubmit;\n" +
            "   __CMS_PostbackForm.onsubmit = __consoleHandleOnSubmit;\n" +
            "\n" +
            "   function __consoleCustomDoPostBack( eventTarget, eventArgument )\n" +
            "   {\n" +
            "       WBC_offWarningBeforeLeave();\n" +
            "       __consoleCachedOriginalPostBack( eventTarget, eventArgument );\n" +
            "   }\n" +
            "\n" +
            "   function __consoleHandleOnSubmit()\n" +
            "   {\n" +
            "       WBC_offWarningBeforeLeave();\n" +
            "       if (__consoleCachedOriginalOnSubmit != null)\n" +
            "       {\n" +
            "           return __consoleCachedOriginalOnSubmit();\n" +
			"       }\n" +
			"		return true;\n" +
			"   }\n" +
            "// -->\n" +
            "</SCRIPT>\n\n\n";

		public void OnInit(object sender, EventArgs eventArgs)
		{
			System.Web.UI.Page currentPage = sender as System.Web.UI.Page;
			currentPage.RegisterStartupScript("OverrideASPXPostback",		// now lets register our script to correct the missing return value
				overrideASPXPostback);

		}

	}
}
