Contributors subclass: #CalmoSoft
instanceVariableNames: ''
classVariableNames: ''
!
CalmoSoft subclass: #CalmoPuzzle
instanceVariableNames: 'canvas empty size size2 tileArray'
classVariableNames: ''
!
CalmoPuzzle class
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
CalmoPuzzle
!
addTiles
  1 to: size2 do:[:nr |
    self createTile: nr.
    self placeTile: nr].
  empty := size2.
  (tileArray at: empty) content: ''.
!
buildTopPanel
  | sp |
  sp := StackPanel horizontal.
  sp add: (Button content: '2x2' callback: [self changeSize: 2]).
  sp add: (Button content: '3x3' callback: [self changeSize: 3]).
  sp add: (Button content: '4x4' callback: [self changeSize: 4]).
  sp add: (Button content: '5x5' callback: [self changeSize: 5]).
  sp add: (Button content: '6x6' callback: [self changeSize: 6]).
  sp add: (Button content: '7x7' callback: [self changeSize: 7]).
  sp add: (Button content: '8x8' callback: [self changeSize: 8]).
  sp add: (Button content: '9x9' callback: [self changeSize: 9]).
  ^ sp
!
canMove: nr
  up := (empty = (nr - size)).
  down := (empty = (nr + size)).
  left := ((empty = (nr - 1)) and: ((nr\\size)~=1)).
  right := ((empty = (nr + 1)) and: ((nr\\size)~=0)).
  move1 := up or: down.
  move2 := move1 or: left.
  move3 := move2 or: right.
  ^move3
!
changeSize: nr
  self deleteTiles.
  size := nr.
  size2 := size*size.
  tileArray := Array new: size2.
  self addTiles.
!
createTile: nr
  tile := (Button content: nr callback: [self tryMove: nr]).
  tile width: canvas actualWidth / size.
  tile height: canvas actualHeight / size.
  tileArray at: nr put: tile.
  canvas add: (tileArray at: nr).
  ^ tile
!
deleteTiles
  canvas clear
!
gameOver
  1 to: (size2 - 1) do: [:nr |
    tileContent := (tileArray at: nr) content.
    (tileContent ~= nr) ifTrue: [^false]].
  ^true
!
initVariables  
  size := 4.
  size2 := size*size.
  tileArray := Array new: size2.
!
open
  "   Written by Gal Zsolt (CalmoSoft) ~ 2006   "
  "   CalmoPuzzle open   "
  | button dockpanel top window |
  self initVariables.
  window := self topWindowClass new.
  window title: '15 Puzzle'.
  dockpanel := DockPanel new.
  button := (Button content: 'Scramble' callback: [self scramble]).
  dockpanel add: button.
  DockPanel setDock: button to: Dock bottom.
  top := self buildTopPanel.
  dockpanel add: top.
  DockPanel setDock: top to: Dock top.
  canvas := Canvas new.
  canvas background: Brushes gray.
  dockpanel add: canvas.
  window add: dockpanel.
  window open.
  self addTiles.
!
placeTile: nr
  | row col x y |
  tile := tileArray at: nr.
  row := ((nr - 1) // size) + 1.
  col := ((nr - 1) \\ size) + 1.
  x := canvas actualWidth * (col - 1) / size.
  y := canvas actualHeight * (row - 1) / size.
  Canvas setLeft: tile to: x.
  Canvas setTop: tile to: y
!
scramble
  | random |
  random := Random new.
  1000 timesRepeat: [
    rand := (random nextMin: 1 max: (size2 + 1)).
    self tryMove: rand]
!
tryMove: nr
  (self canMove: nr) ifTrue: [
  (tileArray at: empty) content: (tileArray at: nr) content.
  (tileArray at: nr) content: ''.
  empty := nr.
  self gameOver ifTrue: [(tileArray at: size2) content: 'Hooray!']]
!
CalmoSoft subclass: #PowerBrowser
instanceVariableNames: 'classDict classesTvLeft classesTvRight classLb clipboard instDict instLb notesTextbox nrTextboxRight selectedClass showNr tabctrl texteditor undoText window'
classVariableNames: ''
!
PowerBrowser class
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
PowerBrowser
!
aboutPowerBrowser
   "   PowerBrowser new aboutPowerBrowser   "
  | string window xaml |
  window := self topWindowClass new.
  string := File readAllText: 'xaml/AboutPowerBrowser.xaml'.
  xaml := XamlUtility xamlFromString: string.
  xaml isNil ifFalse: [window add: xaml].
  window width: 550; height: 350; title: 'About Vista Smalltalk'.
  window open
!
classMethodSelection
  | selector method |
  classLb selectedItem notNil ifTrue: [
    selector := classLb selectedItem content.
    method := selectedClass class lookupSelector: selector.
    texteditor text: method text.
    undoText := texteditor text]
!
classSelectionChangedLeft
  | cls |
  classesTvLeft selectedItem isNil ifTrue:[^nil].
  classesTvLeft background: (SolidColorBrush new: Color customBlue).
  classesTvRight background: (SolidColorBrush new: Color customGray).
  cls := classesTvLeft selectedItem tag.
  selectedClass := cls.
  self refreshMethodsLists.
  self showClassText
!
classSelectionChangedRight
  | cls |
  classesTvRight selectedItem isNil ifTrue:[^nil].
  classesTvRight background: (SolidColorBrush new: Color customBlue).
  classesTvLeft background: (SolidColorBrush new: Color customGray).
  cls := classesTvRight selectedItem tag.
  selectedClass := cls.
  self refreshMethodsLists.
  self showClassText
!
clearAppendFile
  File writeAllText: 'vista.st' from: ''.
!
createLineNumbers
  1 to: 99 do: [: nr |
    nr < 10 ifTrue: [nrTextboxLeft println: ('0' + nr asString)] 
                ifFalse: [nrTextboxLeft println: (nr asString)]].
  nrTextboxLeft isenabled: false
!
createNewClass
  texteditor text: Class template.
!
createNewMethod
  texteditor text: MethodContext template.
!
cutText
 | text textLeft textRight cutStart |
  clipboard := texteditor selectedText.
  text := texteditor text.
  cutStart := texteditor selectionStart.
  textLeft := text substring: 0 len: cutStart.
  textRight := text substring: (cutStart + texteditor selectionLength)
                           len: (text length - textLeft length - texteditor selectionLength).
  texteditor text: (textLeft + textRight).
  texteditor selectionStart: cutStart
!
doIt
  | method str |
  (tabctrl selectedIndex == 2) ifTrue: [str := notesTextbox selectedText trim]
                                            ifFalse: [str := texteditor selectedText trim].
  str length == 0 ifTrue: [^nil].
  method := Compiler compileSnippet: str.
  method isNil ifTrue:[^nil].
  Processor scheduleProcess: (Process fromMethod: method)
!
fileoutAll
  | textSave datetime datetimeString timeStart |  
  textSave := File readAllText: 'scripts/startup.st'.
  datetime := self getDateTime.
  datetime length > 13
     ifTrue: [
      datetime length = 14 ifTrue: [timeStart := 8] ifFalse: [timeStart := 9].
      datetimeString := 'scripts/startup_' + (datetime substring: 0 len: 8) + '_'+ (datetime substring: timeStart len: 6) + '.st'] 
    ifFalse: [datetimeString := 'scripts/startup_save.st'].
  File writeAllText: datetimeString from: textSave.
  Vm fileOutAll
!
fileoutClass
  | classOut classOutFile classOutString index1 index2 indexNextClass startupFile text find1 find2 |
  startupFile := File readAllText: 'scripts/startup.st'.
  find1 := ' subclass:'.
  find2 := ' #'.
  classOut := (selectedClass superclass asString) + find1 + find2 + selectedClass asString.
  index1 := startupFile indexOf: classOut.
  indexNextClass := startupFile indexOf: find1 + find2 start: index1 + classOut length.
  text := startupFile substring: index1 len: indexNextClass - index1.
  index2 := text lastIndexOf: '!'.
  classOutString := startupFile substring: index1 len: index2 + 1.
  classOutFile := File writeAllText: selectedClass asString + '.st' from: classOutString.
!
fileoutClassAppend
  | classOut classOutFile classOutString index1 index2 indexNextClass startupFile text find1 find2 textSave |
  startupFile := File readAllText: 'scripts/startup.st'.
  find1 := ' subclass:'.
  find2 := ' #'.
  classOut := (selectedClass superclass asString) + find1 + find2 + selectedClass asString.
  index1 := startupFile indexOf: classOut.
  indexNextClass := startupFile indexOf: find1 + find2 start: index1 + classOut length.
  text := startupFile substring: index1 len: indexNextClass - index1.
  index2 := text lastIndexOf: '!'.
  (File exists: 'vista.st') ifTrue: [textSave := (File readAllText: 'vista.st') + (startupFile substring: index1 len: index2 + 1)]
                                 ifFalse: [textSave := startupFile substring: index1 len: index2 + 1].
  textSave := textSave+ Environment newline.
  classOutFile := File writeAllText: 'vista.st' from: textSave.
!
findIt
  | index string text |
  text := texteditor text.
  string := texteditor selectedText trim.
  string length == 0 ifTrue: [^nil].
  index := (text indexOf: string start: (texteditor selectionStart + string length)).
  index > 0 ifTrue: [
    texteditor selectionStart: index.
    texteditor selectionLength: string length]
!
getDateTime
  | datetime |
  datetime := DateTime now asString.
  datetime := datetime replace: '.' with: ''.
  datetime := datetime replace: ':' with: ''.
  datetime := datetime replace: '/' with: ''.
  datetime := datetime replace: '-' with: ''.
  datetime := datetime replace: ' ' with: '0'.
  ^datetime
!
implementorsClassMethod
  | selector |
  selector := classLb selectedItem content.
  (Vm implementorsOf: selector) inspect
!
implementorsInstMethod
  | selector |
  selector := instLb selectedItem content.
  (Vm implementorsOf: selector) inspect
!
implementorsMethodOfTextbox
  | selector string |
  (tabctrl selectedIndex == 2) ifTrue: [string := notesTextbox selectedText trim]
                                            ifFalse: [string := texteditor selectedText trim].
  selector := string asSymbol.
  (Vm implementorsOf: selector) inspect
!
inheritsFromList
  | aList aString aSuperclass |
  texteditor text: ''.   
  aList := List new.
  aString := ''.
  aSuperclass := selectedClass superclass.
  aList add: (aSuperclass asString).
  [aSuperclass == Vm rootClass] whileFalse: [
     aSuperclass := aSuperclass superclass.
     aList add: (aSuperclass asString)].
  aList reverse.
  aList do: [:cls |
    aString := aString + '  '.
    texteditor println: aString + cls].
  aString := aString + '  '.
  texteditor println: aString + (selectedClass asString).
!
inspectIt
  | method process str |
  (tabctrl selectedIndex == 2) ifTrue: [str := notesTextbox selectedText trim]
                                            ifFalse: [str := texteditor selectedText trim].
  method := Compiler compileSnippet: str.
  method isNil ifTrue:[^nil].
  process := Process fromMethod: method.
  process callback: [:val | self inspectResult: val].
  Processor scheduleProcess: process
!
inspectResult: anObject
  anObject inspect
!
instMethodSelection
  | selector method |
  instLb selectedItem notNil ifTrue: [
    selector := instLb selectedItem content.
    method := selectedClass lookupSelector: selector.
    texteditor text: method text.
    undoText := texteditor text]
!
open
  "   PowerBrowser new open   "
  | tab |
  window := FourPaneTreeTabTreeText new.
  window title: '~~~ Power Browser for Vista Smalltalk ~~~'.
  classesTvLeft := window treeviewLeft.
  classesTvLeft background: (SolidColorBrush new: Color customGray).
  classesTvRight := window treeviewRight.
  classesTvRight background: (SolidColorBrush new: Color customGray).
  tabctrl := window tabcontrol.
  texteditor := window textbox.
  texteditor foreground: Brushes navy.
  texteditor showLines: true.
  texteditor showBreakpoints: true.
  notesTextbox := TextBox new.
  notesTextbox text: 'This is an enhanced workspace in classbrowser !' + Environment newline + Environment newline + 'CalmoPuzzle new open. (Do It)'.
  instLb := ListBox new.
  instLb background: (SolidColorBrush new: Color customGreen).
  instLb borderbrush: (SolidColorBrush new: Color customDarkGray).
  instLb foreground: Brushes darkGreen.
  classLb := ListBox new.
  classLb background: (SolidColorBrush new: Color customGreen).
  classLb borderbrush: (SolidColorBrush new: Color customDarkGray).
  classLb foreground: Brushes darkGreen.
  tab := TabItem new.
  tab header: 'Instance'.
  tab content: instLb.
  window tabcontrol tabStripPlacement: Dock top.
  window tabcontrol items add: tab.
  tab := TabItem new.
  tab header: 'Class'.
  tab content: classLb.
  window tabcontrol items add: tab.
  tab := TabItem new.
  tab header: 'WorkSpace'.
  tab content: notesTextbox.
  window tabcontrol items add: tab.
  Handler on: classesTvLeft event: 'SelectedItemChanged' block: [self classSelectionChangedLeft].
  Handler on: classesTvRight event: 'SelectedItemChanged' block: [self classSelectionChangedRight].
  Handler on: instLb event: 'SelectionChanged' block: [self instMethodSelection].
  Handler on: classLb event: 'SelectionChanged' block: [self classMethodSelection].
  self setInstLbContextMenu; setClassLbContextMenu; setTextBoxContextMenu; setClassesTvRightContextMenu;
        setClassesTvLeftContextMenu; setNotesTextboxContextMenu.
  self setFontSize.
  window open.
  self refreshClassTreeLeft.
  self refreshClassTreeRight.
!
pasteText
  | text textLeft textRight insertStart |
  text := texteditor text.
  insertStart := texteditor selectionStart.
  textLeft := text substring: 0 len: insertStart.
  textRight := text substring: (insertStart + texteditor selectionLength)
                           len: (text length - textLeft length - texteditor selectionLength).
  texteditor text: (textLeft + clipboard asString + textRight).
  texteditor selectionStart: insertStart.
!
readNotes
  | string |
  (File exists: 'notes.txt') ifTrue: [
    string := File readAllText: 'notes.txt'.
    notesTextbox text: string]
  ifFalse: [^nil]
!
refreshClassTreeLeft
  | rootClass rootNode |
  rootClass := Vm rootClass.
  classesTvLeft items clear.
  rootNode := TreeViewItem new.
  rootNode foreground: Brushes fireBrick.
  rootNode header: rootClass name.
  rootNode tag: rootClass.
  classesTvLeft items add: rootNode.
  self refreshClassTreeLeft: rootClass node: rootNode
!
refreshClassTreeLeft: aClass node: aNode
  | childNode |
  aClass subclasses do:[:cls |
    childNode := TreeViewItem new.
    childNode foreground: Brushes fireBrick.
    childNode header: cls name.
    childNode tag: cls.
    aNode items add: childNode.
    self refreshClassTreeLeft: cls node: childNode]
!
refreshClassTreeRight
  | clsName rootClass childClass nrMethod |
  classesTvRight items clear.
  rootClass := Vm rootClass.
  rootClass withAllSubclasses do:[:cls |
    childClass := TreeViewItem new.
    nrMethod := (cls methodDictionary size) + (cls class methodDictionary size).
    nrMethod = 0 ifTrue: [clsName := (cls name + ' (-)')]
                        ifFalse: [clsName := (cls name)].
    childClass header: clsName.
    childClass tag: cls.
    classesTvRight items add: childClass]
!
refreshMethodsLists
  | li |
  instDict := selectedClass methodDictionary.
  classDict := selectedClass class methodDictionary.
  instLb items clear.
  classLb items clear.
  texteditor text: ''.
  instDict keysDo: [:k |
    li := ListBoxItem new.
    li content: k.
    instLb items add: li].
  classDict keysDo: [:k |
    li := ListBoxItem new.
    li content: k.
    classLb items add: li]
!
removeClass
  selectedClass remove.
  self refreshClassTreeLeft.
  self refreshClassTreeRight
!
removeClassMethod
  | selector |
  selector := classLb selectedItem content.
  selectedClass class removeMethod: selector.
  self refreshMethodsLists
!
removeInstMethod
  | selector |
  selector := instLb selectedItem content.
  selectedClass removeMethod: selector.
  self refreshMethodsLists
!
saveStartup
  | datetime datetimeString text start1 start2 textSave timeStart |  
  text := texteditor text.
  start1 := 'nil subclass:'.
  start2 := ' #Object'.
  textSave := File readAllText: 'scripts/startup.st'.
  datetime := self getDateTime.
  datetime length > 13
    ifTrue: [
      datetime length = 14 ifTrue: [timeStart := 8] ifFalse: [timeStart := 9].
      datetimeString := 'scripts/startup_' + (datetime substring: 0 len: 8) + '_'+ (datetime substring: timeStart len: 6) + '.st'] 
    ifFalse: [datetimeString := 'scripts/startup_save.st'].
  File writeAllText: datetimeString from: textSave.
  (text startsWith: start1 + start2) ifTrue: [File writeAllText: 'scripts/startup.st' from: text]
!
selectAllText
  texteditor selectionStart: 0.
  texteditor selectionLength: (texteditor text length).
!
selectedClass
  | index |
  index := tabctrl selectedIndex.
  index == 0
    ifTrue: [^ selectedClass]
    ifFalse: [^ selectedClass class]
!
sendersClassMethod
  | selector |
  selector := classLb selectedItem content.
  (Vm sendersOf: selector) inspect
!
sendersInstMethod
  | selector |
  selector := instLb selectedItem content.
  (Vm sendersOf: selector) inspect
!
sendersMethodOfTextbox
  | selector string |
  (tabctrl selectedIndex == 2) ifTrue: [string := notesTextbox selectedText trim]
                                            ifFalse: [string := texteditor selectedText trim].
  selector := string asSymbol.
  (Vm sendersOf: selector) inspect
!
setClassesTvLeftContextMenu
  | menu |
  menu := ContextMenu new.
  menu add: (MenuItem name: 'New class' action: [self createNewClass]).
  menu add: (MenuItem name: 'Remove class !!!' action: [self removeClass]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Fileout class' action: [self fileoutClass]).
  menu add: (MenuItem name: 'Fileout class with append' action: [self fileoutClassAppend]).
  menu add: (MenuItem name: 'Clear append file' action: [self clearAppendFile]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Inherits from ...' action: [self inheritsFromList]).
  classesTvLeft contextMenu: menu.
!
setClassesTvRightContextMenu
  | menu |
  menu := ContextMenu new.
  menu add: (MenuItem name: 'New class' action: [self createNewClass]).
  menu add: (MenuItem name: 'Remove class !!!' action: [self removeClass]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Fileout class' action: [self fileoutClass]).
  menu add: (MenuItem name: 'Fileout class with append' action: [self fileoutClassAppend]).
  menu add: (MenuItem name: 'Clear append file' action: [self clearAppendFile]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Inherits from ...' action: [self inheritsFromList]).
  classesTvRight contextMenu: menu.
!
setClassLbContextMenu
  | menu |
  menu := ContextMenu new.
  menu add: (MenuItem name: 'New method' action: [self createNewMethod]).
  menu add: (MenuItem name: 'Remove method' action: [self removeClassMethod]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Senders of method ...' action: [self sendersClassMethod]).
  menu add: (MenuItem name: 'Implementors of method ...' action: [self implementorsClassMethod]).
  classLb contextMenu: menu.
!
setFontSize
  | fntsize |
  fntsize := 12.
  classesTvLeft fontsize: fntsize.
  classesTvRight fontsize: fntsize.
  classLb fontsize: fntsize.
  instLb fontsize: fntsize.
  notesTextbox fontsize: fntsize.
!
setInstLbContextMenu
  | menu |
  menu := ContextMenu new.
  menu add: (MenuItem name: 'New method' action: [self createNewMethod]).
  menu add: (MenuItem name: 'Remove method' action: [self removeInstMethod]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Senders of method ...' action: [self sendersInstMethod]).
  menu add: (MenuItem name: 'Implementors of method ...' action: [self implementorsInstMethod]).
  instLb contextMenu: menu.
!
setNotesTextboxContextMenu
  | menu |
  menu := ContextMenu new.
  menu add: (MenuItem name: 'Clear' action: [notesTextbox text: '']).
  menu add: Separator new.
  menu add: (MenuItem name: 'Filein Notes' action: [self readNotes]).
  menu add: (MenuItem name: 'Fileout Notes' action: [self writeNotes]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Do It' action: [self doIt]).
  menu add: (MenuItem name: 'Show It' action: [self showIt]).
  menu add: (MenuItem name: 'Inspect It' action: [self inspectIt]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Senders of it ...' action: [self sendersMethodOfTextbox]).
  menu add: (MenuItem name: 'Implementors of it ...' action: [self implementorsMethodOfTextbox]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Overview' action: [self showOverview]).
  menu add: (MenuItem name: 'Home Site' action: [VistaBrowserHome open]).
  menu add: (MenuItem name: 'About' action: [self aboutPowerBrowser]).
  notesTextbox contextMenu: menu.
!
setTextBoxContextMenu
  | menu |
  menu := ContextMenu new.
  menu add: (MenuItem name: 'Save' action: [self textSave]).
  menu add: (MenuItem name: 'Fileout all' action: [self fileoutAll]).
  menu add: (MenuItem name: 'Clear' action: [texteditor text: '']).
  menu add: (MenuItem name: 'Undo all' action: [texteditor text: undoText]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Copy' action: [clipboard := texteditor selectedText]).
  menu add: (MenuItem name: 'Cut' action: [self cutText]).
  menu add: (MenuItem name: 'Paste' action: [self pasteText]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Copy all' action: [clipboard := texteditor text]).
  menu add: (MenuItem name: 'Select all' action: [self selectAllText]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Find it ...' action: [self findIt]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Do It' action: [self doIt]).
  menu add: (MenuItem name: 'Show It' action: [self showIt]).
  menu add: (MenuItem name: 'Inspect It' action: [self inspectIt]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Senders of it ...' action: [self sendersMethodOfTextbox]).
  menu add: (MenuItem name: 'Implementors of it ...' action: [self implementorsMethodOfTextbox]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Filein startup.st' action: [self showStartup]).
  menu add: (MenuItem name: 'Fileout startup.st' action: [self saveStartup]).
  texteditor contextMenu: menu.
!
showClassText
  texteditor text: selectedClass storeString
!
showIt
  | method process str |
  (tabctrl selectedIndex == 2) ifTrue: [str := notesTextbox selectedText trim]
                                            ifFalse: [str := texteditor selectedText trim].
  str length == 0 ifTrue: [^nil].
  method := Compiler compileSnippet: str.
  method isNil ifTrue:[^nil].
  process := Process fromMethod: method.
  process callback: [:val | self showResult: val].
  Processor scheduleProcess: process
!
showOverview
   texteditor text: '                                       Overview

After nearly six years of work and billions of dollars expenditure,
Microsoft has begun releasing the major components of its .Net initiative.

Most media focus has been on the Vista operating system,
but Vista is just part of a much larger architectural change
in how Microsoft applications will be written and deployed.

The Smalltalk language is ideally suited for the enhanced
application connectivity that these new architectures will allow.

Vista Smalltalk runs in Internet Explorer 7 as well as on the Windows Vista
desktop and is designed to be fully compatible with the .Net framework
including future (WPF/E) cross-platform implementations.

Copyright 2000-2006 RoboWiz Corporation - All Rights Reserved'
!
showResult: anObject
  | box n |
  (tabctrl selectedIndex == 2) ifTrue: [box := notesTextbox]
                                            ifFalse: [box := texteditor].
  n := box selectionStart + box selectionLength.
  box selectionStart: n+1.
  box selectedText: anObject printString
!
showStartup
  | string |
  string := File readAllText: 'scripts/startup.st'.
  texteditor text: string.
!
template
  ^' subclass:' + ' #NameOfSubclass' + Environment newline +
   'instanceVariableNames: ''''' + Environment newline +
   'classVariableNames: '''''
!
textSave
  | nrMethod txt |
  txt := texteditor text trim.
  txt length == 0 ifTrue: [^nil].
  nrMethod := (selectedClass methodDictionary size) + (selectedClass class methodDictionary size).
  ((txt at: 0) isUpper and: (txt indexOf: ' subclass:') > 0)
  ifTrue: [
    SmalltalkReader addSubclass: self selectedClass string: txt.
    self refreshClassTreeLeft.
    self refreshClassTreeRight]
  ifFalse: [
    SmalltalkReader addMethod: self selectedClass string: txt.
    self refreshMethodsLists.
    nrMethod == 0 ifTrue: [ 
      self refreshClassTreeLeft.
      self refreshClassTreeRight]]
!
writeNotes
    File writeAllText: 'notes.txt' from: notesTextbox text.
!
CalmoSoft subclass: #PowerLauncher
instanceVariableNames: 't1 t2 t3 t4'
classVariableNames: ''
!
PowerLauncher class
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
PowerLauncher
!
buildBottom
  | sp tWidth |
  tWidth := 130.
  sp := StackPanel horizontal.
  t1 := TreeView new.
  t2 := TreeView new.
  t3 := TreeView new.
  t4 := TreeView new.
  t1 width: tWidth.
  t2 width: tWidth.
  t3 width: tWidth.
  t4 width: tWidth.
  t1 borderbrush: Brushes red.
  t2 borderbrush: Brushes red.
  t3 borderbrush: Brushes red.
  t4 borderbrush: Brushes red.
  sp add: t1.
  sp add: t2.
  sp add: t3.
  sp add: t4.
  t1 isenabled: true.
  t2 isenabled: false.
  t3 isenabled: false.
  t4 isenabled: false.
  t1 items add: 'PowerBrowser'.
  t1 items add: 'ClassBrowser'.
  t1 items add: 'PowerSpace'.
  t1 items add: 'Workspace'.
  t1 items add: 'PowerWriter'.
  t2 items add: 'CalmoPuzzle'.
  t2 items add: 'Editor'.
  t2 items add: 'QuickBrowser'.
  t2 items add: 'RssDemo'.
  t2 items add: 'ScaleDemo'.
  t2 items add: 'SketchPad'.
  t2 items add: 'VideoStore'.
  t2 items add: 'WheelDemo'.
  t2 items add: 'XamlDemo'.
  t2 items add: 'YahooLocalSearch'.
  t2 items add: 'YahooNewsSearch'.
  t3 items add: 'AnimationTest'.
  t3 items add: 'PhpTest'.
  t3 items add: 'RotationTest'.
  t4 items add: 'ColorButtons '.
  t4 items add: 'CombinedXaml'.
  t4 items add: 'Greetings'.
  t4 items add: 'VideoStore2'.
  ^ sp
!
buildTop
  | sp bWidth |
  bWidth := 130.
  sp := StackPanel horizontal.
  sp add: (button1 := (Button content: 'Tools' callback: [self setMenus: 1])).
  sp add: (button2 := (Button content: 'Demos' callback: [self setMenus: 2])).
  sp add: (button3 := (Button content: 'Test' callback: [self setMenus: 3])).
  sp add: (button4 := (Button content: 'Wiki' callback: [self setMenus: 4])).
  button1 width: bWidth. 
  button2 width: bWidth. 
  button3 width: bWidth. 
  button4 width: bWidth. 
  button1 background: Brushes yellow. 
  button2 background: Brushes yellow. 
  button3 background: Brushes yellow. 
  button4 background: Brushes yellow. 
  ^ sp
!
open 
  "   PowerMenu new open   "
  | top dockpanel window |
  window := self topWindowClass new.
  window title: 'Power Launcher'.
  window width: 520; height: 240.
  dockpanel := DockPanel new.
  top := self buildTop.
  top clipToBounds: True.
  dockpanel add: top.
  DockPanel setDock: top to: Dock top.
  top := self buildBottom.
  dockpanel add: top.
  DockPanel setDock: top to: Dock top.
  window add: dockpanel.
  Handler on: t1 event: 'SelectedItemChanged' block: [self selectionChangedT1].
  Handler on: t2 event: 'SelectedItemChanged' block: [self selectionChangedT2].
  Handler on: t3 event: 'SelectedItemChanged' block: [self selectionChangedT3].
  Handler on: t4 event: 'SelectedItemChanged' block: [self selectionChangedT4].
  window open
!
selectionChangedT1
  (t1 selectedItem='PowerBrowser') ifTrue: [PowerBrowser new open].
  (t1 selectedItem='ClassBrowser') ifTrue: [ClassBrowser new open].
  (t1 selectedItem='PowerSpace') ifTrue: [PowerSpace new open].
  (t1 selectedItem='Workspace') ifTrue: [Workspace new open].
  (t1 selectedItem='PowerWriter') ifTrue: [PowerWriter new open].
!
selectionChangedT2
  (t2 selectedItem='CalmoPuzzle') ifTrue: [CalmoPuzzle new open].
  (t2 selectedItem='Editor') ifTrue: [Editor new open].
  (t2 selectedItem='QuickBrowser') ifTrue: [QuickBrowser new open].
  (t2 selectedItem='RssDemo') ifTrue: [RssDemo new open].
  (t2 selectedItem='ScaleDemo') ifTrue: [ScaleDemo new open].
  (t2 selectedItem='SketchPad') ifTrue: [SketchPad new open].
  (t2 selectedItem='VideoStore') ifTrue: [VideoStore new open].
  (t2 selectedItem='WheelDemo') ifTrue: [WheelDemo new open].
  (t2 selectedItem='XamlDemo') ifTrue: [XamlDemo new open].
  (t2 selectedItem='YahooLocalSearch') ifTrue: [YahooLocalSearch new open].
  (t2 selectedItem='YahooNewsSearch') ifTrue: [YahooNewsSearch new open].
!
selectionChangedT3
  (t3 selectedItem='AnimationTest') ifTrue: [AnimationTest new open].
  (t3 selectedItem='PhpTest') ifTrue: [PhpTest new open].
  (t3 selectedItem='RotationTest') ifTrue: [RotationTest new open].
!
selectionChangedT4
  (t4 selectedItem='ColorButtons ') ifTrue: [ColorButtons new open].
  (t4 selectedItem='CombinedXaml') ifTrue: [CombinedXaml new open].
  (t4 selectedItem='Greetings') ifTrue: [Greetings new open].
  (t4 selectedItem='VideoStore2') ifTrue: [VideoStore2 new open].
!
setMenus: nr
  (nr = 1) ifTrue: [t1 isenabled: true] ifFalse: [t1 isenabled: false].
  (nr = 2) ifTrue: [t2 isenabled: true] ifFalse: [t2 isenabled: false].
  (nr = 3) ifTrue: [t3 isenabled: true] ifFalse: [t3 isenabled: false].
  (nr = 4) ifTrue: [t4 isenabled: true] ifFalse: [t4 isenabled: false].
!
CalmoSoft subclass: #PowerSpace
instanceVariableNames: 'clipboard textBox window'
classVariableNames: ''
!
PowerSpace
!
buildTop
  | sp bWidth |
  bWidth := 130.
  sp := StackPanel horizontal.
  sp add: (button1 := (Button content: 'Clear' callback: [textBox text: ''])).
  sp add: (button2 := (Button content: 'Method Template' callback: [self methodTemplate])).
  sp add: (button3 := (Button content: 'Save to file' callback: [self saveToFile])).
  sp add: (button4 := (Button content: 'Save to append file' callback: [self saveToAppendFile])).
  sp add: (button5 := (Button content: 'Clear saved file' callback: [self clearSavedFile])).
  sp add: (button6 := (Button content: 'Clear append file' callback: [self clearAppendFile])).
  button1 width: bWidth. 
  button2 width: bWidth. 
  button3 width: bWidth. 
  button4 width: bWidth. 
  button5 width: bWidth. 
  button6 width: bWidth. 
  button1 background: Brushes yellow. 
  button2 background: Brushes yellow. 
  button3 background: Brushes yellow. 
  button4 background: Brushes yellow. 
  button5 background: Brushes yellow. 
  button6 background: Brushes yellow. 
  ^ sp
!
clearAppendFile
  File writeAllText: 'power_space_append.st' from: ''.
!
clearSavedFile
  File writeAllText: 'power_space.st' from: ''.
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
cutText
 | text textLeft textRight cutStart |
  clipboard := textBox selectedText.
  text := textBox text.
  cutStart := textBox selectionStart.
  textLeft := text substring: 0 len: cutStart.
  textRight := text substring: (cutStart + textBox selectionLength)
                           len: (text length - textLeft length - textBox selectionLength).
  textBox text: (textLeft + textRight).
  textBox selectionStart: cutStart
!
doIt
  | method str |
  str := textBox selectedText trim.
  str length == 0 ifTrue: [^nil].
  method := Compiler compileSnippet: str.
  method isNil ifTrue:[^nil].
  Processor scheduleProcess: (Process fromMethod: method)
!
findIt
  | index string text |
  text := textBox text.
  string := textBox selectedText trim.
  string length == 0 ifTrue: [^nil].
  index := (text indexOf: string start: (textBox selectionStart + string length)).
  index > 0 ifTrue: [
    textBox selectionStart: index.
    textBox selectionLength: string length]
!
implementorsMethodOfTextbox
  | selector string |
  string := textBox selectedText trim.
  selector := string asSymbol.
  (Vm implementorsOf: selector) inspect
!
inspectIt
  | method process str |
  str := textBox selectedText trim.
  method := Compiler compileSnippet: str.
  method isNil ifTrue:[^nil].
  process := Process fromMethod: method.
  process callback: [:val | self inspectResult: val].
  Processor scheduleProcess: process
!
inspectResult: anObject
  anObject inspect
!
methodTemplate
  textBox println: '| myVar |'.
  textBox println: ''.
  textBox appendText: 'Transcript showCr:'.
!
open 
  "   PowerSpace new open   "
  | top dockpanel|
  window := self topWindowClass new.
  window title: 'PowerSpace'.
  window width: 797; height: 560.
  window background: Brushes gray.
  dockpanel := DockPanel new.
  top := self buildTop.
  top clipToBounds: True.
  dockpanel add: top.
  DockPanel setDock: top to: Dock top.
  textBox := TextEditor new.
  textBox showLines: true. 
  textBox showBreakpoints: true. 
  textBox height: 450.
  textBox width: 790. 
  textBox background: Brushes ivory.
  textBox foreground: Brushes navy.
  dockpanel add: textBox.
  DockPanel setDock: textBox to: Dock top.
  window add: dockpanel.
  self setTextBoxContextMenu.
  window open
!
pasteText
  | text textLeft textRight insertStart |
  text := textBox text.
  insertStart := textBox selectionStart.
  textLeft := text substring: 0 len: insertStart.
  textRight := text substring: (insertStart + textBox selectionLength)
                           len: (text length - textLeft length - textBox selectionLength).
  textBox text: (textLeft + clipboard asString + textRight).
  textBox selectionStart: insertStart.
!
saveToAppendFile
  | outFile textSave |
  (File exists: 'power_space_append.st') ifTrue: [textSave := (File readAllText: 'power_space_append.st') + (textBox text)]
    ifFalse: [textSave := textBox text].
  textSave := textSave+ Environment newline.
  outFile := File writeAllText: 'power_space_append.st' from: textSave.
!
saveToFile
    File writeAllText: 'power_space.st' from: textBox text.
!
selectAllText
  textBox selectionStart: 0.
  textBox selectionLength: (textBox text length).
!
sendersMethodOfTextbox
  | selector string |
  string := textBox selectedText trim.
  selector := string asSymbol.
  (Vm sendersOf: selector) inspect
!
setTextBoxContextMenu
  | menu |
  menu := ContextMenu new.
  menu add: (MenuItem name: 'Copy' action: [clipboard := textBox selectedText]).
  menu add: (MenuItem name: 'Cut' action: [self cutText]).
  menu add: (MenuItem name: 'Paste' action: [self pasteText]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Copy all' action: [clipboard := textBox text]).
  menu add: (MenuItem name: 'Select all' action: [self selectAllText]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Find it ...' action: [self findIt]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Do It' action: [self doIt]).
  menu add: (MenuItem name: 'Show It' action: [self showIt]).
  menu add: (MenuItem name: 'Inspect It' action: [self inspectIt]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Senders of it ...' action: [self sendersMethodOfTextbox]).
  menu add: (MenuItem name: 'Implementors of it ...' action: [self implementorsMethodOfTextbox]).
  textBox contextMenu: menu.
!
showIt
  | method process str |
  str := (textBox selectedText trim).
  str length == 0 ifTrue: [^nil].
  method := Compiler compileSnippet: str.
  method isNil ifTrue:[^nil].
  process := Process fromMethod: method.
  process callback: [:val | self showResult: val].
  Processor scheduleProcess: process
!
showResult: anObject
  | box n |
  box := textBox.
  n := box selectionStart + box selectionLength.
  box selectionStart: n+1.
  box selectedText: anObject printString
!
CalmoSoft subclass: #PowerWriter
instanceVariableNames: 'clipboard textBox window'
classVariableNames: ''
!
PowerWriter
!
buildTop1
  | sp bWidth |
  bWidth := 130.
  sp := StackPanel horizontal.
  sp add: (button1 := (Button content: 'Clear' callback: [textBox text: ''])).
  sp add: (button2 := (Button content: 'Method Template' callback: [self methodTemplate])).
  sp add: (button3 := (Button content: 'Save to file' callback: [self saveToFile])).
  sp add: (button4 := (Button content: 'Save to append file' callback: [self saveToAppendFile])).
  sp add: (button5 := (Button content: 'Clear saved file' callback: [self clearSavedFile])).
  sp add: (button6 := (Button content: 'Clear append file' callback: [self clearAppendFile])).
  button1 width: bWidth. 
  button2 width: bWidth. 
  button3 width: bWidth. 
  button4 width: bWidth. 
  button5 width: bWidth. 
  button6 width: bWidth. 
  button1 background: Brushes yellow. 
  button2 background: Brushes yellow. 
  button3 background: Brushes yellow. 
  button4 background: Brushes yellow. 
  button5 background: Brushes yellow. 
  button6 background: Brushes yellow. 
  ^ sp
!
buildTop2
  | sp bWidth |
  bWidth := (130/8).
  sp := StackPanel horizontal.
  sp add: (button1 := (Button content: 'a' callback: [textBox text: textBox text + 'a'])).
  sp add: (button2 := (Button content: 'b' callback: [textBox text: textBox text + 'b'])).
  sp add: (button3 := (Button content: 'c' callback: [textBox text: textBox text + 'c'])).
  sp add: (button4 := (Button content: 'd' callback: [textBox text: textBox text + 'd'])).
  sp add: (button5 := (Button content: 'e' callback: [textBox text: textBox text + 'e'])).
  sp add: (button6 := (Button content: 'f' callback: [textBox text: textBox text + 'f'])).
  sp add: (button7 := (Button content: 'g' callback: [textBox text: textBox text + 'g'])).
  sp add: (button8 := (Button content: 'h' callback: [textBox text: textBox text + 'h'])).
  sp add: (button9 := (Button content: 'i' callback: [textBox text: textBox text + 'i'])).
  sp add: (button10 := (Button content: 'j' callback: [textBox text: textBox text + 'j'])).
  sp add: (button11 := (Button content: 'k' callback: [textBox text: textBox text + 'k'])).
  sp add: (button12 := (Button content: 'l' callback: [textBox text: textBox text + 'l'])).
  sp add: (button13 := (Button content: 'm' callback: [textBox text: textBox text + 'm'])).
  sp add: (button14 := (Button content: 'n' callback: [textBox text: textBox text + 'n'])).
  sp add: (button15 := (Button content: 'o' callback: [textBox text: textBox text + 'o'])).
  sp add: (button16 := (Button content: 'p' callback: [textBox text: textBox text + 'p'])).
  button1 width: bWidth. 
  button2 width: bWidth. 
  button3 width: bWidth. 
  button4 width: bWidth. 
  button5 width: bWidth. 
  button6 width: bWidth. 
  button7 width: bWidth. 
  button8 width: bWidth. 
  button9 width: bWidth. 
  button10 width: bWidth. 
  button11 width: bWidth. 
  button12 width: bWidth. 
  button13 width: bWidth. 
  button14 width: bWidth. 
  button15 width: bWidth. 
  button16 width: bWidth. 
  button1 background: Brushes yellow. 
  button2 background: Brushes yellow. 
  button3 background: Brushes yellow. 
  button4 background: Brushes yellow. 
  button5 background: Brushes yellow. 
  button6 background: Brushes yellow.
  button7 background: Brushes yellow.
  button8 background: Brushes yellow.
  button9 background: Brushes yellow.
  button10 background: Brushes yellow. 
  button11 background: Brushes yellow. 
  button12 background: Brushes yellow. 
  button13 background: Brushes yellow. 
  button14 background: Brushes yellow. 
  button15 background: Brushes yellow. 
  button16 background: Brushes yellow.
  ^ sp
!
buildTop3
  | sp bWidth |
  bWidth := (130/8).
  sp := StackPanel horizontal.
  sp add: (button17 := (Button content: 'q' callback: [textBox text: textBox text + 'q'])).
  sp add: (button18 := (Button content: 'r' callback: [textBox text: textBox text + 'r'])).
  sp add: (button19 := (Button content: 's' callback: [textBox text: textBox text + 's'])).
  sp add: (button20 := (Button content: 't' callback: [textBox text: textBox text + 't'])).
  sp add: (button21 := (Button content: 'u' callback: [textBox text: textBox text + 'u'])).
  sp add: (button22 := (Button content: 'x' callback: [textBox text: textBox text + 'x'])).
  sp add: (button23 := (Button content: 'y' callback: [textBox text: textBox text + 'y'])).
  sp add: (button24 := (Button content: 'v' callback: [textBox text: textBox text + 'v'])).
  sp add: (button25 := (Button content: 'w' callback: [textBox text: textBox text + 'w'])).
  sp add: (button26 := (Button content: 'z' callback: [textBox text: textBox text + 'z'])).
  sp add: (button27 := (Button content: ' ' callback: [textBox text: textBox text + ' '])).
  sp add: (button28 := (Button content: '. ' callback: [textBox text: textBox text + ' .'])).
  sp add: (button29 := (Button content: '[ ' callback: [textBox text: textBox text + ' ['])).
  sp add: (button30 := (Button content: ' ]' callback: [textBox text: textBox text + ' ]'])).
  sp add: (button31 := (Button content: ' (' callback: [textBox text: textBox text + ' ('])).
  sp add: (button32 := (Button content: ' )' callback: [textBox text: textBox text + ' )'])).
  button17 width: bWidth. 
  button18 width: bWidth. 
  button19 width: bWidth. 
  button20 width: bWidth. 
  button21 width: bWidth. 
  button22 width: bWidth. 
  button23 width: bWidth. 
  button24 width: bWidth. 
  button25 width: bWidth. 
  button26 width: bWidth. 
  button27 width: bWidth. 
  button28 width: bWidth. 
  button29 width: bWidth. 
  button30 width: bWidth. 
  button31 width: bWidth. 
  button32 width: bWidth. 
  button17 background: Brushes yellow.
  button18 background: Brushes yellow.
  button19 background: Brushes yellow.
  button20 background: Brushes yellow. 
  button21 background: Brushes yellow. 
  button22 background: Brushes yellow. 
  button23 background: Brushes yellow. 
  button24 background: Brushes yellow. 
  button25 background: Brushes yellow. 
  button26 background: Brushes yellow. 
  button27 background: Brushes yellow. 
  button28 background: Brushes yellow. 
  button29 background: Brushes yellow. 
  button30 background: Brushes yellow. 
  button31 background: Brushes yellow. 
  button32 background: Brushes yellow. 
  ^ sp
!
clearAppendFile
  File writeAllText: 'power_space_append.st' from: ''.
!
clearSavedFile
  File writeAllText: 'power_space.st' from: ''.
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
cutText
 | text textLeft textRight cutStart |
  clipboard := textBox selectedText.
  text := textBox text.
  cutStart := textBox selectionStart.
  textLeft := text substring: 0 len: cutStart.
  textRight := text substring: (cutStart + textBox selectionLength)
                           len: (text length - textLeft length - textBox selectionLength).
  textBox text: (textLeft + textRight).
  textBox selectionStart: cutStart
!
doIt
  | method str |
  str := textBox selectedText trim.
  str length == 0 ifTrue: [^nil].
  method := Compiler compileSnippet: str.
  method isNil ifTrue:[^nil].
  Processor scheduleProcess: (Process fromMethod: method)
!
findIt
  | index string text |
  text := textBox text.
  string := textBox selectedText trim.
  string length == 0 ifTrue: [^nil].
  index := (text indexOf: string start: (textBox selectionStart + string length)).
  index > 0 ifTrue: [
    textBox selectionStart: index.
    textBox selectionLength: string length]
!
implementorsMethodOfTextbox
  | selector string |
  string := textBox selectedText trim.
  selector := string asSymbol.
  (Vm implementorsOf: selector) inspect
!
inspectIt
  | method process str |
  str := textBox selectedText trim.
  method := Compiler compileSnippet: str.
  method isNil ifTrue:[^nil].
  process := Process fromMethod: method.
  process callback: [:val | self inspectResult: val].
  Processor scheduleProcess: process
!
inspectResult: anObject
  anObject inspect
!
methodTemplate
  textBox println: '| myVar |'.
  textBox println: ''.
  textBox appendText: 'Transcript showCr:'.
!
open 
  "   PowerWriter new open   "
  | top dockpanel |
  window := self topWindowClass new.
  window title: 'Power Writer'.
  window width: 797; height: 560.
  window background: Brushes gray.
  dockpanel := DockPanel new.
  top := self buildTop1.
  top clipToBounds: True.
  dockpanel add: top.
  DockPanel setDock: top to: Dock top.
  top := self buildTop2.
  top clipToBounds: True.
  dockpanel add: top.
  DockPanel setDock: top to: Dock top.
  top := self buildTop3.
  top clipToBounds: True.
  dockpanel add: top.
  DockPanel setDock: top to: Dock top.
  textBox := TextEditor new.
  textBox showLines: true. 
  textBox showBreakpoints: true. 
  textBox height: 450.
  textBox width: 790. 
  textBox background: Brushes ivory.
  textBox foreground: Brushes navy.
  dockpanel add: textBox.
  DockPanel setDock: textBox to: Dock top.
  window add: dockpanel.
  self setTextBoxContextMenu.
  window open
!
pasteText
  | text textLeft textRight insertStart |
  text := textBox text.
  insertStart := textBox selectionStart.
  textLeft := text substring: 0 len: insertStart.
  textRight := text substring: (insertStart + textBox selectionLength)
                           len: (text length - textLeft length - textBox selectionLength).
  textBox text: (textLeft + clipboard asString + textRight).
  textBox selectionStart: insertStart.
!
saveToAppendFile
  | outFile textSave |
  (File exists: 'power_space_append.st') ifTrue: [textSave := (File readAllText: 'power_space_append.st') + (textBox text)]
    ifFalse: [textSave := textBox text].
  textSave := textSave+ Environment newline.
  outFile := File writeAllText: 'power_space_append.st' from: textSave.
!
saveToFile
    File writeAllText: 'power_space.st' from: textBox text.
!
selectAllText
  textBox selectionStart: 0.
  textBox selectionLength: (textBox text length).
!
sendersMethodOfTextbox
  | selector string |
  string := textBox selectedText trim.
  selector := string asSymbol.
  (Vm sendersOf: selector) inspect
!
setTextBoxContextMenu
  | menu |
  menu := ContextMenu new.
  menu add: (MenuItem name: 'Copy' action: [clipboard := textBox selectedText]).
  menu add: (MenuItem name: 'Cut' action: [self cutText]).
  menu add: (MenuItem name: 'Paste' action: [self pasteText]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Copy all' action: [clipboard := textBox text]).
  menu add: (MenuItem name: 'Select all' action: [self selectAllText]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Find it ...' action: [self findIt]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Do It' action: [self doIt]).
  menu add: (MenuItem name: 'Show It' action: [self showIt]).
  menu add: (MenuItem name: 'Inspect It' action: [self inspectIt]).
  menu add: Separator new.
  menu add: (MenuItem name: 'Senders of it ...' action: [self sendersMethodOfTextbox]).
  menu add: (MenuItem name: 'Implementors of it ...' action: [self implementorsMethodOfTextbox]).
  textBox contextMenu: menu.
!
showIt
  | method process str |
  str := (textBox selectedText trim).
  str length == 0 ifTrue: [^nil].
  method := Compiler compileSnippet: str.
  method isNil ifTrue:[^nil].
  process := Process fromMethod: method.
  process callback: [:val | self showResult: val].
  Processor scheduleProcess: process
!
showResult: anObject
  | box n |
  box := textBox.
  n := box selectionStart + box selectionLength.
  box selectionStart: n+1.
  box selectedText: anObject printString
!
CalmoSoft subclass: #Tutorial
instanceVariableNames: ''
classVariableNames: ''
!
Tutorial class
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
Tutorial subclass: #Classes
instanceVariableNames: ''
classVariableNames: ''
!
Classes class
!
comment
"   Written by Gal Zsolt (CalmoSoft) ~ 2006   "
"   See this link :   "
"   http://vistascript.net/vistascript/docuwiki/doku.php?id=tutorial   "
"   The best way to predict the future is to learn and develop Vista Smalltalk.   "
"   (CalmoSoft)   "
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
Classes
!
array01
  "   Classes new array01   "
  "   This code create an array, add three items and write reversed items to Transcript   "
  | myArray nr |
  myArray := Array new: 3.
  myArray at: 1 put: 'Vista'.
  myArray at: 2 put: 'Smalltalk'.
  myArray at: 3 put: 'Forever'.
  1 to: 3 do: [:nr |
    Transcript showCr: (myArray at: 4-nr)]
!
array02
  "   Classes new array02   "
  "   Size of array   "
  | myArray nr |
  myArray := Array new: 3.
  myArray at: 1 put: 'Vista'.
  myArray at: 2 put: 'Smalltalk'.
  myArray at: 3 put: 'Forever'.
  1 to: myArray size do: [:nr |
    Transcript showCr: (myArray at: 4-nr)]
!
behavior01
  "   Classes new behavior01   "
  "   Shows the superclass of a class   "
  Transcript showCr: Button superclass
!
behavior02
  "   Classes new behavior02   "
  "   Shows the instancevariables of a class   "
  ClassBrowserPlus instanceVariables inspect
!
boolean01
  "   Classes new boolean01   "
  Transcript showCr: ((1<2) and: (4<3))
!
boolean02
  "   Classes new boolean02   "
  Transcript showCr: ((1<2) or: (4<3))
!
char01
  "   Classes new char01   "
  "   Check is a character upper   "
  | myChar |
  myChar := $a.
  Transcript showCr: myChar isUpper
!
char02
  "   Classes new char02   "
  "   Check is a character upper   "
  | myChar |
  myChar := $B.
  Transcript showCr: myChar isUpper
!
char03
  "   Classes new char03   "
  "   Check is a character upper   "
  Transcript showCr: $a isUpper
!
char04
  "   Classes new char04   "
  "   Check is a character upper   "
  Transcript showCr: $B isUpper
!
class01
  "   Classes new class01   "
  "   Print a class definition   "
  Transcript showCr: (CalmoSoft storeString)
!
class02
  "   Classes new class02   "
  "   Print the maptype of a class  "
  Transcript showCr: (Color mapType)
!
class03
  "   Classes new class03   "
  "   Print the subclasses of a class   " 
  CalmoSoft subclasses inspect
!
clipboard01
  "   Classes new clipboard01   "
  "   This code copy a text to the Clipboard and write to Transcript too   "
  | myText |
  myText := 'Vista Smalltalk Forever!'.
  Clipboard clear.
  Clipboard setText: myText.
  Transcript showCr: Clipboard getText
!
clipboard02
  "   Classes new clipboard02  "
  "   This code copy concatenation of two text to the Clipboard and write to Transcript too   "
  | myText1 myText2 |
  myText1 := 'Vista Smalltalk Forever!'.
  myText2 := 'Vista Smalltalk this Friday will win the IBM Vista Code Competition!'.
  Clipboard clear.
  Clipboard setText: myText1 + Environment newline + myText2.
  Transcript showCr: Clipboard getText
!
datetime01
  "   Classes new datetime01   "
  "   Usage of DateTime   "
  | time1 time2 |
  time1 := DateTime now.
  1 to: 100 do: [:nr |
    Transcript showCr: nr asString].
  time2 := DateTime now.
  Transcript showCr: time1.
  Transcript showCr: time2
!
dictionary01
  "    Classes new dictionary01   "
  "    Set dictionary elements at index   "
  | myDictionary |
  myDictionary := Dictionary new.
  myDictionary at: #a put: 'Vista'.
  myDictionary at: #b put: 'Smalltalk'.
  myDictionary at: #c put: 'Forever'.
  myDictionary inspect
!
dictionary02
  "   Classes new dictionary02   "
  "   Number of elements   "
  | myDictionary |
  myDictionary := Dictionary new.
  myDictionary at: #a put: 'Vista'.
  myDictionary at: #b put: 'Smalltalk'.
  myDictionary at: #c put: 'Forever'.
  Transcript showCr: myDictionary size
!
dictionary03
  "   Classes new dictionary03   "
  "   Retrieve element at index   "
  | myDictionary |
  myDictionary := Dictionary new.
  myDictionary at: #a put: 'Vista'.
  myDictionary at: #b put: 'Smalltalk'.
  myDictionary at: #c put: 'Forever'.
  Transcript showCr: (myDictionary at: #b)
!
file01
  "   Classes new file01   "
  "   This code shows the configuration file (config.vs) in Transcript   "
  Transcript show: (File readAllText: 'config.vs')
!
file02
  "   Classes new file02   "
  "   Verify if file exists   "
  Transcript show: (File exists: 'config.vs')
!
file03
  "   Classes new file03   "
  "   Copy config.vs to config2.vs   "
  | text |
  text := (File readAllText: 'config.vs').
  File writeAllText: 'config2.vs' from: text
!
file04
  "   Classes new file04   "
  "   Copy config.vs to config2.vs   "
  File writeAllText: 'config2.vs' from: (File readAllText: 'config.vs').
!
file05
  "   Classes new file05   "   
  "   This code write all classes name to a file.   "  
  | classesString |
  classesString := ''.
  Object withAllSubclasses do:  [ : cls | classesString := (classesString + cls name + Environment newline ) asString].
  File writeAllText: 'vst_classes.txt' from: classesString
!
gc01
  "   Classes new gc01   "
  "   Print total memory   "
  Transcript showCr: (GC getTotalMemory: true)
!
list01
  "   Classes new list01   "
  "   This code create a list, add three items, reverse the items and write this result to Transcript   "
  | myList |
   myList := List new.
   myList add: 'Vista';
             add: 'Smalltalk';
             add: 'Forever'.
  myList reverse.
  myList do: [:item |
    Transcript showCr: item]
!
list02
  "   Classes new list02   "
  "   Sort the list   "
  | myList |
  myList := List new.
  myList add: 'Vista';
            add: 'Smalltalk';
            add: 'Forever'.
  myList sort.
  myList do: [:item |
    Transcript showCr: item]
!
math01
  "   Classes new math01   "
  "   Print a class definition   "
  Transcript showCr: (Math cos: 3.14).
  Transcript showCr: (Math sin: 3.14).
  Transcript showCr: (Math e).
  Transcript showCr: (Math pi).
  Transcript showCr: (Math round: 3.14).
!
random01
  "   Classes new random01   "
  "   This code generate 100 random numbers from 1 to 99 and write to Transcript   "
  | nr random |
  nr := 0.
  random := Random new.
  100 timesRepeat: [
    nr := nr + 1.
    rand := (random nextMin: 1 max: 100).
    Transcript show: nr; show: ' -> '; showCr: rand]
!
string01
  "   Classes new string01   "
  "   Substring of a string.   "
  | myString myNewString |
  myString := 'Vista Smalltalk'.
  myNewString := myString substring: 6 len: 9.
  Transcript showCr: myNewString.
!
string02
  "   Classes new string02   "
  "   Substring of a string.   "
  | myString |
  myString := 'Vista Smalltalk'.
  Transcript showCr: (myString substring: 6 len: 9).
!
string03
  "   Classes new string03   "
  "   Substring of a string.   "
  | myString index |
  myString := 'Vista Smalltalk'.
  index := myString indexOf: 'Smalltalk'.
  Transcript showCr: (myString substring: index len: myString length - index).
!
string04
  "   Classes new string04   "
  "   Substring of a string.   "
  Transcript showCr: ('Vista Smalltalk' substring: 6 len: 9).
!
string05
  "   Classes new string05   "
  "   Concatenation of two strings   "
  | string string1 string2 | 
  string1 := 'Vista '.
  string2 := 'Smalltalk'.
  string := string1 concat: string2.
  Transcript showCr: string
!
string06
  "   Classes new string06   "
  "   Concatenation of two strings   "
  | string string1 string2 | 
  string1 := 'Vista '.
  string2 := 'Smalltalk'.
  string := string1 + string2.
  Transcript showCr: string
!
string07
  "   Classes new string07   "
  "   Concatenation of two strings   "
  | string string1 string2 | 
  string1 := 'Vista '.
  string2 := 'Smalltalk'.
  Transcript showCr: string1 + string2
!
string08
  "   Classes new string08   "
  "   Concatenation of two strings   "
  Transcript showCr: 'Vista' + ' ' +'Smalltalk'
!
string09
  "   Classes new string09   "
  "   Evaluation of a string   "
  | myString |
  myString := 'CalmoPuzzle open'.
  myString eval.
!
string10
  "   Classes new string10   "
  "   Insert a string   "
  | string string1 string2 |
  string1 := 'Vista Forever!'.
  string2 := 'Smalltalk '.
  string := string1 insertAt: 6 string: string2.
  Transcript showCr: string
!
string11
  "   Classes new string11   "
  "   Trim method   "
  | string1 string2 |
  string1 := '   Vista Smalltalk   '.
  string2 := string1 trim.
  Transcript showCr: '>' + string1 + '<'.
  Transcript showCr: '>' + string2 + '<'
!
transcript01
  "   Classes new transcript01   "
  Transcript show: 'Vista Smalltalk'.
  Transcript cr.
  Transcript show: 'Forever!'
!
transcript02
  "   Classes new transcript02   "
  Transcript show: 'Vista Smalltalk'; cr; show: 'Forever!'
!
transcript03
  "   Classes new transcript03   "
  Transcript showCr: 'Vista Smalltalk'.
  Transcript show: 'Forever!'
!
vm01
  "   Classes new vm01   "
  "   You can find all implementors of a method   "
  (Vm implementorsOf: 'open' asSymbol) inspect
!
vm02
  "   Classes new vm02   "
  "   You can find all senders of a method   "
  (Vm sendersOf: 'size' asSymbol) inspect
!
Tutorial subclass: #GUI
instanceVariableNames: ''
classVariableNames: ''
!
GUI class
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
GUI subclass: #CalmoDialog
instanceVariableNames: ''
classVariableNames: ''
!
CalmoDialog class
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
CalmoDialog
!
open
  "   Dialog new open   "
  | button canvas dialogTextbox dockpanel window |
  window := self topWindowClass new.
  window title: 'Dialog'.
  dockpanel := DockPanel new.
  dialogTextbox := TextBox new.
  dialogTextbox text: 'Vista Smalltalk Forever!'.
  button := (Button content: 'OK' callback: [Transcript showCr: (dialogTextbox text asString)]).
  dockpanel  add: button.
  DockPanel setDock: button to: Dock bottom.
  dockpanel add: dialogTextbox.
  DockPanel setDock: dialogTextbox to: Dock top.
  canvas := Canvas new.
  canvas background: Brushes gray.
  dockpanel add: canvas.
  window add: dockpanel.
  window width: 250; height: 82.
  window open
!
GUI subclass: #CalmoStackpanel
instanceVariableNames: ''
classVariableNames: ''
!
CalmoStackpanel class
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
CalmoStackpanel
!
open
  "   CalmoStackpanel new open   "
  | buttonOK buttonClear canvas dialogTextbox dockpanel stackpanel window |
  window := self topWindowClass new.
  window title: 'Dialog'.
  dockpanel := DockPanel new.
  dialogTextbox := TextBox new.
  stackpanel := StackPanel horizontal.
  dialogTextbox text: 'Vista Smalltalk Forever!'.
  buttonOK := (Button content: 'OK' callback: [Transcript showCr: (dialogTextbox text asString)]).
  buttonClear := (Button content: 'Clear' callback: [dialogTextbox text: '']).
  stackpanel add: buttonOK.
  stackpanel add: buttonClear.
  dockpanel  add: stackpanel.
  DockPanel setDock: stackpanel to: Dock bottom.
  dockpanel add: dialogTextbox.
  DockPanel setDock: dialogTextbox to: Dock top.
  canvas := Canvas new.
  canvas background: Brushes gray.
  dockpanel add: canvas.
  window add: dockpanel.
  window width: 250; height: 82.
  window open
!
GUI subclass: #DigitalClock
instanceVariableNames: 'textBox'
classVariableNames: ''
!
DigitalClock
!
open
  "   DigitalClock new open   "
  | button dockpanel  window |
  window := self topWindowClass new.
  window title: 'Digital Clock'.
  window width: 100; height: 80.
  dockpanel := DockPanel new.
  button := (Button content: 'Show Date & Time' callback: [self showDateTime]).
  dockpanel add: button.
  DockPanel setDock: button to: Dock bottom.
  textBox := TextBox new.
  textBox textalignment: TextAlignment center.
  textBox background: Brushes yellow.
  textBox text: (DateTime now) asString.
  dockpanel add: textBox.
  DockPanel setDock: textBox to: Dock top.
  window add: dockpanel.
  window open.
!
showDateTime
  textBox text: (DateTime now) asString.
!
GUI subclass: #ListSwapDialog
instanceVariableNames: 'dockpanel listLeft listRight'
classVariableNames: ''
!
ListSwapDialog class
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
ListSwapDialog
!
buildBottom
  | buttonMoveLeft buttonMoveRight stackpanel |
  buttonMoveLeft := (Button content: 'Copy to Left' callback: [self moveLeft]).
  buttonMoveLeft width: 120.
  buttonMoveLeft height: 20.
  buttonMoveLeft background: Brushes yellow.
  buttonMoveRight := (Button content: 'Copy to Right' callback: [self moveRight]).
  buttonMoveRight width: 120.
  buttonMoveRight height: 20.
  buttonMoveRight background: Brushes yellow.
  stackpanel := StackPanel horizontal.
  stackpanel add: buttonMoveRight.
  stackpanel add: buttonMoveLeft.
  dockpanel  add: stackpanel.
  DockPanel setDock: stackpanel to: Dock bottom.
!
buildTop
  | stackpanel |
  listLeft := ListBox new.
  listRight := ListBox new.
  listLeft width: 120.
  listRight width: 120.
  listLeft borderbrush: Brushes red.
  listRight borderbrush: Brushes red.
  listLeft add: 'Beatles'.
  listLeft add: 'Rolling Stones '.
  listLeft add: 'Pink Floyd'.
  listLeft add: 'ELP '.
  listLeft add: 'Yes'.
  listRight add: 'Abba'.
  listRight add: 'Smokie'.
  listRight add: 'Tina Turner'.
  listRight add: 'Baccrara'.
  listRight add: 'Tom Jones'.
  stackpanel := StackPanel horizontal.
  stackpanel add: listLeft.
  stackpanel add: listRight.
  dockpanel  add: stackpanel.
  DockPanel setDock: stackpanel to: Dock top.
!
moveLeft
  | selected |
  (listRight selectedIndex > -1) ifTrue: [
    selected := listRight selectedItem.
    listLeft items add: selected]
!
moveRight
  | selected |
  (listLeft selectedIndex > -1) ifTrue: [
    selected := listLeft selectedItem.
    listRight items add: selected]
!
open
  "   ListSwapDialog new open   "
  | dockpanel window |
  window := self topWindowClass new.
  window title: 'List Swap Dialog'.
  window width: 240.
  window height: 360.
  dockpanel := DockPanel new.
  self buildTop.
  self buildBottom.
  window add: dockpanel.
  window open.
!
Tutorial subclass: #Lisp
instanceVariableNames: ''
classVariableNames: ''
!
Lisp class
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
Lisp
!
lisp01
  "   Lisp new lisp01   "
  "   Create a list   "
  | string1 string2 string3 list1 list2|
  string1 := '123'.
  string2 := '456'.
  string3 := '789'.
  list1 := Cons car: string1 cdr: string2.
  list2 := Cons car: list1 cdr: string3.
  Transcript showCr: list2 length.
  Transcript showCr: list2 car.
  Transcript showCr: list2 cdr.
!
Tutorial subclass: #Structures
instanceVariableNames: ''
classVariableNames: ''
!
Structures class
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
Structures
!
block01
  "   Structures new block01   "
  | myBlock |
  myBlock := [
    Transcript showCr: 'Vista'.
    Transcript showCr: 'Smalltalk'.
    Transcript showCr: 'Forever!']. 
  myBlock run
!
iteration01
  "   Structures new iteration01   "
  "   Usage of iteration   "
  | nr |
  1 to:10 do: [:nr |
    Transcript showCr: nr asString]
!
iteration02
  "   Structures new iteration02   "
  "   Usage of iteration   "
  | nr |
  nr := 0.
  10 timesRepeat: [
    nr := nr+1.
    Transcript showCr: nr asString]
!
Tutorial subclass: #Syntax
instanceVariableNames: ''
classVariableNames: ''
!
Syntax class
!
copyright
   "   ~  written by: Gal Zsolt & Cathlyn Cosca ( CalmoSoft ) ~ 2006 ~ calmosoft@gmail.com ~   "
!
Syntax
!
syntax

"   source:   "
"   http://minnow.cc.gatech.edu/squeak/5699   "

"   The original was created by Chris Rathman, at http://www.angelfire.com/tx4/cus/notes/smalltalk.html   "

"
Allowable characters:                                                
    - a-z                                                             
    - A-Z                                                            
    - 0-9                                                            
    - .+/\*~<>@%|&?                                                   
    - blank, tab, cr, ff, lf                                          
                                                                      
 Variables:                                                           
    - variables must be declared before use                           
    - shared vars must begin with uppercase                          
    - local vars must begin with lowercase                            
    - reserved names: nil, true, false, self, super, and Smalltalk    
                                                                      
 Variable scope:                                                      
    - Global: defined in Dictionary Smalltalk and accessible by all   
         objects in system                                            
    - Special: (reserved) Smalltalk, super, self, true, false, & nil 
    - Method Temporary: local to a method                             
    - Block Temporary: local to a block                               
    - Pool: variables in a Dictionary object                          
    - Method Parameters: automatic local vars created as a result of  
         message call with params                                     
    - Block Parameters: automatic local vars created as a result of   
         value: message call                                          
    - Class: shared with all instances of one class & its subclasses  
    - Class Instance: unique to each instance of a class              
    - Instance Variables: unique to each instance                     
"
!
