using System;
using Microsoft.ContentManagement.Publishing;
using StefanG.Tools;
using System.Collections.Specialized;

namespace TestDLL
{
	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	class Class1
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			CmsApplicationContext appContext = new CmsApplicationContext();
			appContext.AuthenticateAsCurrentUser();

			ResourceGallery resGal = appContext.RootResourceGallery;

			CollectResourceGalleries(appContext, resGal);
		}

		static void CollectResourceGalleries(CmsApplicationContext appContext, ResourceGallery resGal)
		{
			ResourceGalleryCollection rsgcol = resGal.ResourceGalleries;
			rsgcol.SortByName();
			foreach (ResourceGallery resG in rsgcol)
			{
				CollectResourceGalleries(appContext, resG);
			}

			ResourceCollection rescol = resGal.Resources;
			rescol.SortByName();
			foreach (Resource res in rescol)
			{
				Console.WriteLine(res.Path);
				StringCollection PostingGUIDs = CheckResourceDependencies.GetDependendPosting(appContext, res);
				foreach (string guid in PostingGUIDs)
				{
					Posting p = appContext.Searches.GetByGuid(guid) as Posting;
					if (p == null)
					{
						Console.WriteLine("- Posting with GUID "+guid+" cannot be found. Not accessable through PAPI");
					}
					else
					{
						Console.WriteLine("- "+p.Path);
					}
				}
			}
		}

	}
}
