///
///  This source code is freeware and is provided on an "as is" basis without warranties of any kind, 
///  whether express or implied, including without limitation warranties that the code is free of defect, 
///  fit for a particular purpose or non-infringing.  The entire risk as to the quality and performance of 
///  the code is with the end user.
///
///  Created by Stefan Goner (stefang@microsoft.com)
///
///  Latest Updates: 
///      V1.0  include Mac client support
///      V1.1  correct buffer size problem 1
///      V1.2  correct buffer size problem 2
///      V1.3  added support for Mac with MCMS 2002 SP2
///      V1.4  added check for non Page objects
///      V1.5  added support for ASP.NET 2.0 master pages
///

using System;
using System.IO;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using Microsoft.ContentManagement.Publishing;

namespace StefanG.HttpModules
{
	// To avoid postbacks on Mac it is necessary to modify the action on the form tag.
	// the only way I found to do this (as it is not an accessable attribute) is to consume the stream
	// before sent to the client and modify it using a stream filter

	public class FormTagFilter : Stream 
	{
		private Encoding enc = null;
		private bool closed;
		Stream BaseStream;

		public FormTagFilter(Stream baseStream, Encoding encoding)
		{
			BaseStream = baseStream;
			closed = false;
			enc = encoding;
		}
		
		public override void Write(byte[] buffer, int offset, int count) 
		{

			if(Closed) throw new ObjectDisposedException("FormTagFilter");

			string content = enc.GetString(buffer,offset,count);
			byte[] newBuffer = enc.GetBytes(content);
			int pos = content.IndexOf("<form ");
			while (pos >= 0)
			{
				pos = content.IndexOf("action=",pos);
				if (pos >= 0)
				{
					pos += "action=\"".Length;
					int endpos = content.IndexOf("\"",pos);
					if (endpos > 0)
					{
						string actionString = content.Substring(pos,endpos-pos);
						if (actionString.IndexOf("NRMODE") > 0)
						{
							string head = content.Substring(0,pos);
							string tail = content.Substring(endpos);
							content = head+CmsHttpContext.Current.ChannelItem.UrlModePublished+tail;
			
//							buffer = enc.GetBytes(content);
							newBuffer= enc.GetBytes(content);
							break;
						}
					}
				}
				pos = content.IndexOf("<form",pos);
			}
			count = newBuffer.Length;
//			BaseStream.Write(buffer, offset, count);
			BaseStream.Write(newBuffer, 0, count);
		}

		public override bool CanRead
		{	
			get { return false; }
		}

		public override bool CanWrite 
		{
			get { return !closed; }
		}

		public override bool CanSeek 
		{
			get { return false; }
		}

		public override void Close() 
		{
			closed = true;
			BaseStream.Close();
		}

		protected bool Closed 
		{
			get { return closed; }
		}

		public override void Flush() 
		{
			BaseStream.Flush();
		}

		public override int Read(byte[] buffer, int offset, int count) 
		{
			throw new NotSupportedException();
		}

		public override long Length 
		{
			get { throw new NotSupportedException(); }
		}

		public override long Seek(long offset, SeekOrigin origin) 
		{
			throw new NotSupportedException();
		}

		public override void SetLength(long value) 
		{
			throw new NotSupportedException();
		}

		public override long Position 
		{
			get { throw new NotSupportedException(); }
            set { throw new NotSupportedException(); }
		}
	}


	public class CmsNiceUrlHttpModule : IHttpModule 
	{
		public void Init(HttpApplication httpApp) 
		{
			httpApp.PreRequestHandlerExecute += new EventHandler(this.OnPreRequestHandlerExecute);
			httpApp.PreSendRequestHeaders += new EventHandler(this.OnPreSendRequestHeaders);
		}

		public void Dispose() 
		{
			// Nothing to do.
		}

		public void OnPreSendRequestHeaders(object sender, EventArgs e)
		{
		}

		public void OnPreRequestHandlerExecute(object sender, EventArgs e) 
		{
			HttpContext ctx = ((HttpApplication)sender).Context;
			IHttpHandler handler = ctx.Handler;

			if (handler is System.Web.UI.Page)
			{

				try
				{
					// lets correct the ugly URLs when switching between update and published mode
					Posting thisPosting = CmsHttpContext.Current.Posting;
					PublishingMode currentMode = CmsHttpContext.Current.Mode;
					if (thisPosting != null && currentMode == PublishingMode.Published)
					{
						// register http filter for Mac browsers only
						// to avoid performance impact for non-Mac users this code is only activated for Mac clients
						//if (ctx.Request.UserAgent.IndexOf("Win") > 0)
						if (ctx.Request.UserAgent.IndexOf("Mac_PowerPC") > 0)
						{
							FormTagFilter ftf = new FormTagFilter(ctx.Response.Filter, ctx.Response.ContentEncoding);
							ctx.Response.Filter = ftf;
						}

						if (ctx.Request.QueryString["NRORIGINALURL"] != null &&
						    ctx.Request.QueryString["NRORIGINALURL"].StartsWith("/NR/exeres"))
						{
							if (!thisPosting.Url.StartsWith("/NR/exeres"))
								ctx.Response.Redirect(thisPosting.Url);
						}

						// to correct the ugly URL problem for normal postbacks we have to register an eventhandler for the
						// Init event of the page object. This handler then can register a better client script block as the one in 
						// the console code
					}
					if ((CmsHttpContext.Current.Channel != null) && currentMode == PublishingMode.Published)
						((System.Web.UI.Page)handler).Init += new EventHandler(this.OnInit);
				}
				catch
				{
					// this will happen if the request is in the middle of an expired forms authentication login
					// we just ignore this.
				}
			}
		}

		public void OnInit(object sender, EventArgs eventArgs)
		{
			System.Web.UI.Page currentPage = sender as System.Web.UI.Page;

			//if (currentPage.Request.UserAgent.IndexOf("Win") > 0)
			if (currentPage.Request.UserAgent.IndexOf("Mac_PowerPC") > 0)
			{
				currentPage.RegisterClientScriptBlock("__CMS_Page","");
				currentPage.RegisterStartupScript("ResetFormActionScript", "");
			}
			else
			{
				currentPage.RegisterClientScriptBlock("__CMS_Page",		// now lets register our script with the nice URL
					"<script language=\"javascript\" type=\"text/javascript\">\n"+
					"<!--\n"+
					"   var __CMS_PostbackForm = theForm;\n" +
					"   var __CMS_CurrentUrl = \"" + CmsHttpContext.Current.ChannelItem.Url + "\";\n" +
					"   __CMS_PostbackForm.action = __CMS_CurrentUrl;\n" +
					"// -->\n"+
					"</script>\n");
			}
		}

	}
}
