using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Security.Principal;
using System.Web;
using CmsUsersLibrary.Security;
using CmsUsersLibrary.UsersObject;
using CmsUsersLibrary.Searches;

namespace CmsUsersDisplay
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.TextBox NameToSearch;
		private System.Windows.Forms.TreeView ResultsTV;
		private UserRole[] gruppi = null;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.CheckBox QuickSearchCB;
		private System.Windows.Forms.Button CloseButton;
		private System.Windows.Forms.Label MessageLabel;
		private System.Windows.Forms.Button ClearButton;
		private string hostName = string.Empty;
		private string hostPort = string.Empty;

		public static string AppName = "CMSUserSearch";
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public string HostName
		{
			get{return hostName;}
		}

		public string HostPort
		{
			get{return hostPort;}
		}

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//

			//Connect();
			InizializeTreeView();
			this.Text = AppName;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.NameToSearch = new System.Windows.Forms.TextBox();
			this.ResultsTV = new System.Windows.Forms.TreeView();
			this.label1 = new System.Windows.Forms.Label();
			this.QuickSearchCB = new System.Windows.Forms.CheckBox();
			this.CloseButton = new System.Windows.Forms.Button();
			this.MessageLabel = new System.Windows.Forms.Label();
			this.ClearButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(216, 320);
			this.button1.Name = "button1";
			this.button1.TabIndex = 0;
			this.button1.Text = "Search";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// NameToSearch
			// 
			this.NameToSearch.Location = new System.Drawing.Point(128, 264);
			this.NameToSearch.Name = "NameToSearch";
			this.NameToSearch.Size = new System.Drawing.Size(192, 20);
			this.NameToSearch.TabIndex = 2;
			this.NameToSearch.Text = "";
			// 
			// ResultsTV
			// 
			this.ResultsTV.ImageIndex = -1;
			this.ResultsTV.Location = new System.Drawing.Point(8, 8);
			this.ResultsTV.Name = "ResultsTV";
			this.ResultsTV.SelectedImageIndex = -1;
			this.ResultsTV.Size = new System.Drawing.Size(312, 224);
			this.ResultsTV.TabIndex = 4;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 264);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(72, 23);
			this.label1.TabIndex = 5;
			this.label1.Text = "UserName";
			// 
			// QuickSearchCB
			// 
			this.QuickSearchCB.Location = new System.Drawing.Point(24, 288);
			this.QuickSearchCB.Name = "QuickSearchCB";
			this.QuickSearchCB.Size = new System.Drawing.Size(232, 24);
			this.QuickSearchCB.TabIndex = 7;
			this.QuickSearchCB.Text = "QuickSearch (Only Authors and Editors)";
			// 
			// CloseButton
			// 
			this.CloseButton.Location = new System.Drawing.Point(8, 320);
			this.CloseButton.Name = "CloseButton";
			this.CloseButton.TabIndex = 8;
			this.CloseButton.Text = "Close";
			this.CloseButton.Click += new System.EventHandler(this.CloseButton_Click);
			// 
			// MessageLabel
			// 
			this.MessageLabel.Location = new System.Drawing.Point(8, 240);
			this.MessageLabel.Name = "MessageLabel";
			this.MessageLabel.Size = new System.Drawing.Size(312, 23);
			this.MessageLabel.TabIndex = 9;
			// 
			// ClearButton
			// 
			this.ClearButton.Location = new System.Drawing.Point(112, 320);
			this.ClearButton.Name = "ClearButton";
			this.ClearButton.TabIndex = 10;
			this.ClearButton.Text = "Clear";
			this.ClearButton.Click += new System.EventHandler(this.ClearButton_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(328, 349);
			this.Controls.Add(this.ClearButton);
			this.Controls.Add(this.MessageLabel);
			this.Controls.Add(this.CloseButton);
			this.Controls.Add(this.QuickSearchCB);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.ResultsTV);
			this.Controls.Add(this.NameToSearch);
			this.Controls.Add(this.button1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Name = "Form1";
			this.Text = "Form1";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			GroupMember[] result = null;

			if(NameToSearch.Text.Trim() != string.Empty)
			{
				InizializeTreeView();

				try
				{
					if (QuickSearchCB.Checked)
					{
						result = Searches.QuickSearch(NameToSearch.Text);
					}
					else
					{
						if (ResultsTV.SelectedNode != null)
						{
							result = Searches.SearchByRoles(ResultsTV.SelectedNode.Text,NameToSearch.Text);
						}
						else
						{
							result = Searches.FullSearch(NameToSearch.Text);
						}
					}

					if ((result != null)&&(result.Length != 0))
					{
						int indexTN = 0;
						for (int i = 0; i < result.Length; i++) 
						{
							GroupMember user = result[i];
							if(user != null)
							{
								RightsGroup group = user.Rightsgroup;
								int role = (int) group.Role.GetEnum();                               
								IEnumerator myEnumerator = ResultsTV.Nodes[role].Nodes.GetEnumerator();
								bool found = false;

								while(myEnumerator.MoveNext())
								{
									TreeNode currentNode = (TreeNode)myEnumerator.Current;
									if(currentNode != null)
									{
										if(group.Name.ToLower() ==currentNode.Text.ToLower())
										{
											indexTN = currentNode.Index;
											found = true;
											break;
										}
									}
								}
								if(!found)
								{
									TreeNode node = new TreeNode(group.Name);
									indexTN = ResultsTV.Nodes[role].Nodes.Add(node);
								}
								ResultsTV.Nodes[role].Nodes[indexTN].Nodes.Add(user.UserName);
							}
						}
						ResultsTV.ExpandAll();
						MessageLabel.ForeColor = System.Drawing.Color.Black;
						MessageLabel.Text = NameToSearch.Text + " Found";
					}
					else
					{
						MessageLabel.ForeColor = System.Drawing.Color.Black;
						MessageLabel.Text = NameToSearch.Text + "Not Found";
					}

				}
				catch(Exception ex)
				{
					MessageLabel.Text = ex.Message;
					MessageLabel.ForeColor = System.Drawing.Color.Red;
				}
			}
			else
			{
				MessageLabel.Text = "Insert a username to search!";
				MessageLabel.ForeColor = System.Drawing.Color.Red;
			}
		}

		private void CloseButton_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}
		private void InizializeTreeView()
		{
			ResultsTV.Nodes.Clear();
			try
			{
				gruppi = UserRole.GetUserRoles();

				for (int i = 0; i < gruppi.Length; i++) 
				{
					ResultsTV.Nodes.Add(gruppi[i].Name);
				}
				ResultsTV.ExpandAll();
			}
			catch(Exception ex)
			{
				MessageLabel.Text = ex.Message;
				MessageLabel.ForeColor = System.Drawing.Color.Red;
			}
		}

		private void ClearButton_Click(object sender, System.EventArgs e)
		{
			InizializeTreeView();
			NameToSearch.Text = string.Empty;
			QuickSearchCB.Checked = false;
			MessageLabel.ForeColor = System.Drawing.Color.Black;
			MessageLabel.Text = string.Empty;
		}
		private void Connect()
		{
			ConnectForm frm = new ConnectForm();
			if(frm.ShowDialog() == DialogResult.OK)
			{
				this.hostName = frm.txtHost.Text;
				this.hostPort = frm.txtPort.Text;
			}
		}
	}
}
