using System;
using System.Collections;
using CmsUsersLibrary.UsersObject;

namespace CmsUsersLibrary.Searches
{
	/// <summary>
	/// Summary description for Searches.
	/// </summary>
	public class Searches
	{
		public Searches()
		{
			//
			// TODO: Add constructor logic here
			//
		}
		public static GroupMember[] FullSearch(string name)
		{
			//cicla tutto
			//le parti commentate davano errore...
			GroupMember[] rtn = null;
			ArrayList arrayList = new ArrayList();

			arrayList.AddRange(SearchByRoles(UserRoles.Administrators.ToString(),name));
			arrayList.AddRange(SearchByRoles(UserRoles.Authors.ToString(),name));
//			arrayList.AddRange(SearchByRoles(UserRoles.ChannelManagers.ToString(),name));
			arrayList.AddRange(SearchByRoles(UserRoles.Editors.ToString(),name));
			arrayList.AddRange(SearchByRoles(UserRoles.Moderators.ToString(),name));
//			arrayList.AddRange(SearchByRoles(UserRoles.ResourceManagers.ToString(),name));
			arrayList.AddRange(SearchByRoles(UserRoles.Subscribers.ToString(),name));
//			arrayList.AddRange(SearchByRoles(UserRoles.TemplateDesigners.ToString(),name));
			

			rtn = new GroupMember[arrayList.Count];
			arrayList.CopyTo(rtn);

			return rtn;
		}
		public static GroupMember[] QuickSearch(string name)
		{
			//cicla solo editori e autori			
			GroupMember[] rtnTmp1 = SearchByRoles(UserRoles.Authors.ToString(),name);
			GroupMember[] rtnTmp2 = SearchByRoles(UserRoles.Editors.ToString(),name);
			
			GroupMember[] rtn = new GroupMember[rtnTmp1.Length + rtnTmp2.Length];
			
			rtnTmp1.CopyTo(rtn,0);
			rtnTmp2.CopyTo(rtn,rtnTmp1.Length);

			return rtn;
		}
		public static GroupMember[] SearchByRoles(string role,string name)
		{
			//cicla solo il ruolo scelto
			GroupMember[] rtn = null;
			RightsGroup[] rightsGroup = UserRole.GetRightsGroup(role);
			ArrayList arrayList = new ArrayList();

			if (rightsGroup != null)
			{
				GroupMember[] groupResults = null;
				
				for(int i = 0; i < rightsGroup.Length; i++)
				{
					groupResults = rightsGroup[i].ContainsUser(name);
					if(groupResults!= null)
					{
						arrayList.AddRange(groupResults);
					}
				}
				rtn = new GroupMember[arrayList.Count];
				arrayList.CopyTo(rtn);				
			}
			return rtn;
		}
	}
}
