using System;
using System.Collections;
using System.Text.RegularExpressions;
using Microsoft.ContentManagement.Interop.AEServerObject;
using CmsUsersLibrary.Security;

namespace CmsUsersLibrary.UsersObject
{
	/// <summary>
	/// ES: editori,autori,moderatori,amministratori
	/// </summary>
	public class UserRole
	{
		#region Members
		public string Name = string.Empty;
		public string Guid = string.Empty;
		private SecurityManager securityManager = null;
		private IAESession session = null;
		private IAEServer6 server = null;
		#endregion

		#region Constructors
		public UserRole(string userRoleName)
		{
			this.securityManager = new SecurityManager();
			this.session = securityManager.Session;
			this.server = securityManager.Server;
			
			try 
			{
				string ur = server.GetNodeByPath("/User Roles/" + userRoleName);				
				IAEUserGallery usergallery = server.GetNodeByGUID(ur,true) as IAEUserGallery;
				if(usergallery != null)
				{
					this.Name = usergallery.Name;
					this.Guid = usergallery.GUID;
				}
			}
			finally
			{
				this.session.Logout();
			}
		}
		public UserRole(IAEUserGallery userrole)
		{
			this.Name = userrole.Name;
			this.Guid = userrole.GUID;
		}
		#endregion

		#region Public Members
		public RightsGroup[] GetRightsGroup()
		{
			//tira fuori la lista di RightsGroup del ruolo con cui  stato istanziato l'oggetto.
			try 
			{
				//				string ur = this.server.GetNodeByPath("/User Roles/" + this.Name);
				IAEUserGallery usergallery = this.server.GetNodeByGUID(this.Guid,true) as IAEUserGallery;
				if(usergallery != null)
				{
					RightsGroup[] rightsGroup = new RightsGroup[usergallery.Children.Count];
					for(int i = 0;i<usergallery.Children.Count;++i)
					{
						IAEUserRole role =  this.server.GetNodeByGUID(usergallery.Children[i],true) as IAEUserRole;
						rightsGroup[i] = new RightsGroup(role,this);
					}
					return rightsGroup;
				}
			}
			finally
			{
				session.Logout();
			}
			return null;
		}
		public UserRoles GetEnum()
		{
			switch(this.Name.ToLower())
			{
				case "administrators":
					return UserRoles.Administrators;
				case "authors":
					return UserRoles.Authors;
				case "channelmanagers":
					return UserRoles.ChannelManagers;
				case "editors":
					return UserRoles.Editors;
				case "moderators":
					return UserRoles.Moderators;
				case "resourcemanagers":
					return UserRoles.ResourceManagers;
				case "templatedesigners":
					return UserRoles.TemplateDesigners;
				default:
					return UserRoles.Subscribers;
			}
		}
		#endregion

		#region Static Members
		public static RightsGroup[] GetRightsGroup(string userRoleName)
		{
			//dato uno userRoleName (Es: moderators,editors,administrrators)
			//tira fuori la lista di RightsGroup di quel ruolo
			UserRole uRole = new UserRole(userRoleName);
			return uRole.GetRightsGroup();
		}

		public static UserRole[] GetUserRoles()
		{
			//tira fuori la lista degli UserRole
			//Es: Administrator, editors,moderators, etc etc
			SecurityManager sec = new SecurityManager();			
			IAESession session1 = sec.Session;
			IAEServer6 server1 = sec.Server;
			
			try 
			{
				string ur = server1.GetNodeByPath("/User Roles/");
				IAEUserGallery usergallery1 = server1.GetNodeByGUID(ur,true) as IAEUserGallery;

				if(usergallery1 != null)
				{
					UserRole[] userRole = new UserRole[8];
					for(int i = 0, l=0 ;i<usergallery1.Children.Count;i++)
					{	
						IAEUserGallery userDir =  server1.GetNodeByGUID(usergallery1.Children[i],true) as IAEUserGallery;
						if (userDir != null)
						{
							userRole[l] = new UserRole(userDir);
							l++;
						}
					}
					return userRole;
				}
			}
			finally
			{
				session1.Logout();
			}
			return null;
		}
		#endregion
	}


	/// <summary>
	/// ES: PortaleEditori, DeisAutori, AgrariaChannelManager
	/// </summary>
	public class RightsGroup
	{
		public string Name = string.Empty;
		public string Guid = string.Empty;
		public GroupMember[] Members = null;
		public UserRole Role = null;

		public RightsGroup(IAEUserRole rightsgroup, UserRole parent)
		{
			this.Name = rightsgroup.Name;
			this.Guid = rightsgroup.GUID;
			this.Role = parent;

			Members = new GroupMember[rightsgroup.RoleMembers.Count];
			for(int i = 0; i < rightsgroup.RoleMembers.Count; i++)
			{
				Members[i] = new GroupMember(rightsgroup.RoleMembers[i],this);
			}
		}
		public GroupMember[] ContainsUser(string name)
		{
			GroupMember[] rtn = null;
			ArrayList results = new ArrayList();
			string pattern = name;
			Regex rg = new Regex(pattern,RegexOptions.Compiled|RegexOptions.IgnoreCase);

			for(int i=0; i < this.Members.Length; i++)
			{
				if(	(rg.IsMatch(this.Members[i].FullName))||
					(rg.IsMatch(this.Members[i].ShortUserName))||
					(rg.IsMatch(this.Members[i].UserName)))
				{
					results.Add(this.Members[i]);
				}
			}
			rtn = new GroupMember[results.Count];
			results.CopyTo(rtn);
			return rtn;
		}
	}


	/// <summary>
	/// ES: WINNT://STUDENTI/PeterPArker,  WINNT://STUDENTI/CMSEditori
	/// </summary>
	public class GroupMember
	{
		public string UserName = string.Empty;
		public string FullName = string.Empty;
		public string ShortUserName = string.Empty;
		public RightsGroup Rightsgroup = null;

		public GroupMember(IAEUser user, RightsGroup parent)
		{
			this.UserName = user.UserName;
			this.ShortUserName = user.ShortUserName;
			this.FullName = user.FullName;
			this.Rightsgroup = parent;
		}
		public GroupMember()
		{
		}
	}

	public enum UserRoles
	{
		Administrators = 0,
		ChannelManagers,
		Subscribers,
		Authors,
		Editors,
		Moderators,
		ResourceManagers,
		TemplateDesigners		
	}
}
