using System;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.WebControls.ConsoleControls;

namespace ContosoNet.Console
{
	/// <summary>
	/// Summary description for PolicyConsole_ChannelManagerAction.
	/// </summary>
	public class ChannelManagerAction : BaseNewWindowAction
	{
		public ChannelManagerAction()
		{
			//
			// TODO: Add constructor logic here
			//
		}

		public override string ActionJavascript
		{
			get
			{
				string parentChannelID = CmsHttpContext.Current.Channel.Guid;

				string javaScript
					 = "var channelManUrl = '/ContosoNet/Console/ChannelMan.aspx?channelID="
						+ parentChannelID + "';"
					+ "var windowSettings = 'height=500; width=600';"
					+ "window.open (channelManUrl, '_blank', windowSettings);";

				return javaScript;
			}
		}

		public override bool Available
		{
			get
			{
				Channel parentChannel = CmsHttpContext.Current.Channel;
				bool canManageChannels = parentChannel.CanCreateChannels;
				return canManageChannels;
			}
		}

		public override string Text
		{
			get
			{
				return "Channel Manager";
			}
			set
			{
				base.Text = value;
			}
		}

	}
}
