using System;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.WebControls.ConsoleControls;

namespace ContosoNet.Console
{
	/// <summary>
	/// Summary description for NewContentAction.
	/// </summary>
	public class NewContentAction : BaseNewWindowAction
	{
		public NewContentAction()
		{
			//
			// TODO: Add constructor logic here
			//
		}

		public override string ActionJavascript
		{
			get
			{
				Channel relatedChannel = GetRelatedChannel ();
				string javaScript = "";

				if (relatedChannel != null)
				{
					string relatedChannelID = relatedChannel.Guid;

					javaScript
						= "CMS_openWindowCreateNewPage"
						+ "	('/ContosoNet/CMS/WebAuthor/Dialogs/PageCreationWizard/TemplateGalleriesBrowse/TemplateGalleriesBrowse.aspx?NRMODE=UNPUBLISHED&DestinationChannel="
					    + relatedChannelID
						+ "');return false";
				}
				return javaScript;
			}
		}

		private Channel relatedChannel = null;
		private bool relatedChannelSet = false;

		private Channel GetRelatedChannel ()
		{
			if (!relatedChannelSet)
			{
				CustomProperty cp =
					CmsHttpContext.Current.Posting.CustomProperties ["Related Content Channel"];
				if (cp == null  ||
					cp.Value == "")
				{
					return (null);
				}
				else
				{
					string relatedChannelPath = cp.Value;
					Channel relatedChannelFound = null;

					try
					{
						relatedChannelFound = SiteUtils.GetChannel (relatedChannelPath);
					}
					catch (Exception ex)
					{
						try
						{
							System.Diagnostics.EventLog.WriteEntry ("ContosoNet Application",
								"Channel error in NetContentAction  console: " +
								ex.Message +
								" Requested channel: " +
								relatedChannelPath +
								" Requesting page: " +
								CmsHttpContext.Current.Posting.Url, 
								System.Diagnostics.EventLogEntryType.Warning);
						}
						catch {}
					}
					return (relatedChannelFound);
				}
			}
			else
			{
				return (relatedChannel);
			}
		}


		public override bool Available
		{
			get
			{
				// TODO - Check content channel not this one
                Channel parentChannel = GetRelatedChannel();
				if (parentChannel != null)
				{
					return parentChannel.CanCreatePostings;
				}
				else
				{
					return false;
				}
			}
		}

		public override string Text
		{
			get
			{
				Channel relatedChannel = GetRelatedChannel();
				if (relatedChannel != null)
				{
					return "Create " + relatedChannel.DisplayName;
				}
				else
				{
					return "";
				}
			}
			set
			{
				base.Text = value;
			}
		}

	}
}
