using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;

namespace ContosoNet.RSS
{
	/// <summary>
	/// Summary description for NewsRSS.
	/// </summary>
	public class NewsRSS : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Literal SiteUrlLiteral;
		protected System.Web.UI.WebControls.Repeater RssItemsRepeater;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			SiteUrlLiteral.Text = "http://" + Server.MachineName + "/ContosoNet/";
			Channel newsChannel =
				SiteUtils.GetChannel (SiteValues.ExternalPressReleasesChannelPath);
			PostingCollection myPostings = newsChannel.Postings;
			myPostings.SortByStartDate (false);

			RssItemsRepeater.ItemDataBound +=new RepeaterItemEventHandler(RssItemsRepeater_ItemDataBound);
			RssItemsRepeater.DataSource = myPostings;
			RssItemsRepeater.DataBind();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void RssItemsRepeater_ItemDataBound(object sender, RepeaterItemEventArgs e)
		{
			Posting p = e.Item.DataItem as Posting;

			if (e.Item.ItemType == ListItemType.Item ||
				e.Item.ItemType == ListItemType.AlternatingItem)
			{
				Literal titleLiteral = e.Item.FindControl ("TitleLiteral") as Literal;
				Literal pubDateLiteral = e.Item.FindControl ("PubDateLiteral") as Literal;
				Literal descriptionLiteral = e.Item.FindControl ("DescriptionLiteral") as Literal;
				Literal linkLiteral = e.Item.FindControl ("LinkLiteral") as Literal;

				if (titleLiteral != null &&
					pubDateLiteral != null &&
					descriptionLiteral != null &&
					linkLiteral != null)
				{
					string summary = "";
					HtmlPlaceholder summaryPlaceholder =
						p.Placeholders ["Abstract"] as HtmlPlaceholder;
					if (summaryPlaceholder != null)
					{
						summary = SiteUtils.CleanPlaceholderHtml (summaryPlaceholder.Html);
						summary = Server.HtmlEncode (summary);
					}

					titleLiteral.Text = p.DisplayName;
					DateTime pubDate = p.StartDate.ToUniversalTime();
					pubDateLiteral.Text = pubDate.ToString ("ddd, dd MMM yyyy hh:mm:ss") + " GMT";
					descriptionLiteral.Text = summary;
					linkLiteral.Text = "http://" + Server.MachineName + p.Url;
				}
			}
		}
	}
}
