using System;
using Microsoft.ContentManagement.Publishing;
using System.Resources;
using System.Globalization;
using System.Threading;
using System.Web;


namespace ContosoNet
{
	/// <summary>
	/// Summary description for SiteUtils.
	/// </summary>
	public class SiteUtils
	{
		public SiteUtils()
		{
		}

		public static Channel GetChannel (string channelPath)
		{
			return (GetChannel (channelPath, CmsHttpContext.Current));
		}

		public static Channel GetChannel (string channelPath, CmsContext context)
		{
			return (context.Searches.GetByPath (channelPath) as Channel);
		}

		public static Template GetTemplate (string templatePath)
		{
			return (GetTemplate (templatePath, CmsHttpContext.Current));
		}

		public static Template GetTemplate (string templatePath, CmsContext context)
		{
			return (context.Searches.GetByPath (templatePath) as Template);
		}

		public static string CleanPlaceholderHtml (string html)
		{
			string result = html;
			
			// Transformations for Telerik control
			result = result.Replace ("~LT~","<");
			result = result.Replace ("~GT~",">");

			// Translations to condense white space in summaries
			result = result.Replace ("<p>","");
			result = result.Replace ("</p>","<br>");
			result = result.Replace ("<P>","");
			result = result.Replace ("</P>","<br>");

			return (result);
		}

	}
}
