using System;
using System.Threading;

namespace ContosoNet
{
	/// <summary>
	/// Summary description for SiteConstants.
	/// </summary>
	public class SiteValues
	{
		public SiteValues()
		{
		}

		// Channel structure
		public const string ExternalLanguageParentUrl =
			"/ContosoNet/Cultures";
		public const string ExternalLanguageParentChannelPath =
			"/Channels/ContosoNet/Cultures";

		// Values for placeholder names referenced in code
		public const string PlaceholderForCustomProperties = "Custom Properties";
		public const string PlaceholderForNewsTitle = "Title";
		public const string PlaceholderForNewsSummary = "Abstract";
		public const string PlaceholderForNewsBody = "Body";
		public const string PlaceholderForNewsEmployeeNotes = "Employee Notes";

		// Values for External Home Page
		public static string ExternalHomeUrl 
		{
			get
			{
				return ("/ContosoNet/Cultures/" +
						Thread.CurrentThread.CurrentUICulture.Name +
						"/MainNav");
			}
		}
		public static string ExternalHomeChannelPath 
		{
			get
			{
				return ("/Channels/ContosoNet/Cultures/" +
					Thread.CurrentThread.CurrentUICulture.Name +
					"/MainNav");
			}
		}
		public const string ExternalJobPostingTemplatePath =
			"/Templates/ContosoNet/External Content/Job Posting";

		// Values for External Press Releases
		public const string ExternalPressReleasesTemplatePath =
			"/Templates/ContosoNet/External Content/Press Release";
		public const string ExternalPressReleasesUrl = "/ContosoNet/News/";
		public const string ExternalPressReleasesChannelPath = "/Channels/ContosoNet/News/";

		// Values for External Press Release Documents
		public const string ExternalPressReleaseDocumentTemplatePath =
			"/Templates/ContosoNet/External Content/Press Release Document";
		public const string ExternalPressReleaseDocumentUrl = "/ContosoNet/News/";
		public const string ExternalPressReleaseDocumentChannelPath = "/Channels/ContosoNet/News/";

		// Values for External Job Postings
		public const string ExternalJobPostingsUrl = "/ContosoNet/JobPostings/";
		public const string ExternalJobPostingsChannelPath = "/Channels/ContosoNet/JobPostings/";
		public static string ExternalCareerCenterUrl
		{
			get
			{
				return ("/ContosoNet/Cultures/" +
					Thread.CurrentThread.CurrentUICulture.Name +
					"/MainNav/Careers/Careers.htm");
			}
		}
		public static string ExternalJobFinderUrl
		{
			get
			{
				return ("/ContosoNet/Cultures/" +
					Thread.CurrentThread.CurrentUICulture.Name +
					"/MainNav/Careers/JobFinder.htm");
			}
		}

		// Values for External Footer Content
		public static string ExternalFooterChannelPath 
		{
			get
			{
				return ("/Channels/ContosoNet/Cultures/" +
					Thread.CurrentThread.CurrentUICulture.Name +
					"/Footer");
			}
		}

		// Values for Internal Job Postings
		public const string InternalJobPostingsChannelPath = "/Channels/ContosoSP/JobPostings/";
		public const string InternalJobPostingsTemplatePath = "/Templates/ContosoSP/Internal Content/Job Posting";

		// Values for Internal Press Releases
		public const string InternalPressReleasesChannelPath = "/Channels/ContosoSP/News/";
		public const string InternalPressReleasesTemplatePath = "/Templates/ContosoSP/Internal Content/Press Release";
		
		// Values for Internal Press Release Documents
		public const string InternalPressReleaseDocumentChannelPath = "/Channels/ContosoSP/News/";
		public const string InternalPressReleaseDocumentTemplatePath = "/Templates/ContosoSP/Internal Content/Press Release Document";
		
		// CSS Classes
		public const string cssSelectedNavigation = "navigationSelectedLink";
		public const string cssNavigation = "navigationLink";
		public const string cssSelectedSubNavigation = "navigationSubSelectedLink";
		public const string cssSubNavigation = "navigationSubLink";

		// Query String Parameters
		public const string propNameQS = "propName";
		public const string propValueQS = "propVal";
	}
}
