namespace ContosoNet.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	using System.Resources;
	using Microsoft.ContentManagement.Publishing;

	/// <summary>
	///		Summary description for Footer.
	/// </summary>
	public class Footer : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.Literal FooterLiteral;
		protected System.Web.UI.WebControls.Repeater FooterRepeater;

		protected LocalizationManager localizationManager;

		private void Page_Load(object sender, System.EventArgs e)
		{
			localizationManager = new LocalizationManager();

			FooterLiteral.Text = localizationManager.GetString ("footerText");

			Channel footerChannel =
				SiteUtils.GetChannel (SiteValues.ExternalFooterChannelPath);
			PostingCollection postings = footerChannel.Postings;
			postings.SortByOrdinal();

			FooterRepeater.ItemDataBound +=new RepeaterItemEventHandler(FooterRepeater_ItemDataBound);

			FooterRepeater.DataSource = postings;
			FooterRepeater.DataBind();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void FooterRepeater_ItemDataBound(object sender, RepeaterItemEventArgs e)
		{
			Posting boundPosting = e.Item.DataItem as Posting;

			if (e.Item.ItemType == ListItemType.Item ||
				e.Item.ItemType == ListItemType.AlternatingItem)
			{
				// Get controls within this repeater iteration
				HyperLink hyperLinkControl =
					e.Item.FindControl ("FooterLink") as HyperLink;
				Label labelControl = e.Item.FindControl("FooterLabel") as Label;
				Label separatorLabelControl =
					e.Item.FindControl ("SeparatorLabel") as Label;

				if (hyperLinkControl != null &&
					labelControl != null &&
					separatorLabelControl != null &&
					boundPosting != null)
				{
					hyperLinkControl.NavigateUrl = boundPosting.Url;
					labelControl.Text = boundPosting.DisplayName;
					if (e.Item.ItemIndex == 0)
					{
						separatorLabelControl.Visible = false;
					}
					else
					{
						separatorLabelControl.Visible = true;
					}
				}
			}
		}
	}
}
