namespace ContosoNet.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	using System.Text;
	using Microsoft.ContentManagement.Publishing;
	using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;

	/// <summary>
	///		Summary description for JobResults.
	/// </summary>
	public class JobResults : System.Web.UI.UserControl
	{
		private LocalizationManager localizationManager;

		protected System.Web.UI.WebControls.Table JobListingsTable;
		protected System.Web.UI.WebControls.Label FoundLabel;
		protected System.Web.UI.WebControls.Label PostingLabel;
		protected System.Web.UI.WebControls.Label TitleLabel;
		protected System.Web.UI.WebControls.Label CategoryLabel;
		protected System.Web.UI.WebControls.Label LocationLabel;
		protected System.Web.UI.WebControls.Label JobResultsLabel;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			localizationManager = new LocalizationManager();
			JobResultsLabel.Text = localizationManager.GetString ("jobFinderResultsLabel");
			FoundLabel.Text = localizationManager.GetString ("jobFinderFoundLabel");
			PostingLabel.Text = localizationManager.GetString ("jobFinderPostingLabel");
			TitleLabel.Text = localizationManager.GetString ("jobFinderTitleLabel");
			LocationLabel.Text = localizationManager.GetString ("jobFinderLocationLabel");
			CategoryLabel.Text = localizationManager.GetString ("jobFinderCategoryLabel");

			string propName = Request.QueryString [SiteValues.propNameQS];
			string propValue = Request.QueryString [SiteValues.propValueQS];

			if (propName != null &&
				propName != "" &&
				propValue != null &&
				propValue != "")
			{
				JobListingsTable.Visible = true;
				JobResultsLabel.Visible = true;
				FoundLabel.Visible = true;

				PostingCollection thePostings =
					CmsHttpContext.Current.Searches.GetPostingsByCustomProperty
					(propName, propValue);

				int postingIndex = 0;
				int linkCount = 0;
				if (thePostings.Count > 0)
				{
					do
					{
						Posting p = thePostings [postingIndex++];
						if (p.Name.ToLower() != "default" && 
							p.Path.IndexOf ("ContosoSP") < 0)
						{
							string jobTitle =
								localizationManager.TranslateDisplayName (p.CustomProperties["Job Title"].Value);
							string jobCategory = 
								localizationManager.TranslateDisplayName (p.CustomProperties["Job Category"].Value);
							string division = 
								localizationManager.TranslateDisplayName (p.CustomProperties["Division"].Value);
							string location =
								p.CustomProperties["Location"].Value;
							string url =
								p.Url;

							TableRow tr = new TableRow();
							TableCell tc;
							HyperLink link;

							tc = new TableCell ();
							link = new HyperLink ();
							link.Text = jobTitle;
							link.NavigateUrl = url;
							tc.Controls.Add (link);
							tc.CssClass = "tableCell";
							tr.Cells.Add (tc);

							tc = new TableCell ();
							tc.Text = jobCategory;
							tc.CssClass = "tableCell";
							tr.Cells.Add (tc);

							tc = new TableCell ();
							tc.Text = division;
							tc.CssClass = "tableCell";
							tr.Cells.Add (tc);

							tc = new TableCell ();
							tc.Text = location;
							tc.CssClass = "tableCell";
							tr.Cells.Add (tc);

							JobListingsTable.Rows.Add (tr);
							linkCount++;
						}
					} 
					while ((postingIndex<thePostings.Count));
			
					FoundLabel.Text = FoundLabel.Text.Replace ("xxx", linkCount.ToString());

				}
				else
				{
					JobListingsTable.Visible = false;
					JobResultsLabel.Visible = true;
					FoundLabel.Visible = true;
					FoundLabel.Text = localizationManager.GetString("jobFinderNoneFound");
				}
			}
			else
			{
				JobListingsTable.Visible = false;
				JobResultsLabel.Visible = false;
				FoundLabel.Visible = false;
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

	}
}
