namespace ContosoNet.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	using System.Resources;
	using System.Text;
	using Microsoft.ContentManagement.Publishing;
	using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;

	/// <summary>
	///		Summary description for JobSelector.
	/// </summary>
	public class JobSelector : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.Label CriterionLabel;
		protected System.Web.UI.WebControls.Label SearchLabel;
		protected System.Web.UI.WebControls.DropDownList CriterionDropDownList;
		protected System.Web.UI.WebControls.DropDownList SearchDropDownList;

		private LocalizationManager localizationManager;

		private void Page_Load(object sender, System.EventArgs e)
		{
			// Set up page for localization
			localizationManager = new LocalizationManager();
			CriterionLabel.Text = localizationManager.GetString ("searchCriterionLabel");
			SearchLabel.Text = localizationManager.GetString ("searchSearchLabel");

			// Get current search from query string
			string propName = Request.QueryString [SiteValues.propNameQS];
			string propValue = Request.QueryString [SiteValues.propValueQS];

			// If we're rendering fresh, then fill in the drop boxes

			if (!this.IsPostBack)
			{
				Template jobPostingTemplate =
					SiteUtils.GetTemplate (SiteValues.ExternalJobPostingTemplatePath);

				// First the criterion dropdown
				CriterionDropDownList.Items.Add (new ListItem ("", ""));

				foreach (CustomPropertyDefinition cpd 
							 in jobPostingTemplate.CustomPropertyDefinitions)
				{
					if (cpd.AllowedValues.Count > 1)
					{
						string criterionName = localizationManager.TranslateDisplayName (cpd.Name);
						string criterionValue = cpd.Name;
					
						ListItem li = new ListItem (criterionName, criterionValue);
						CriterionDropDownList.Items.Add (li);
						if (propName == criterionValue)
						{
							li.Selected = true;
						}
					}
				}
				// Next fill in the search dropdown
				FillSearchDropDownList (jobPostingTemplate, propName, propValue);
			}

			// Wire the event handlers and set for auto-postback
			CriterionDropDownList.AutoPostBack = true;
			CriterionDropDownList.SelectedIndexChanged +=
				new EventHandler(CriterionDropDownList_SelectedIndexChanged);

			SearchDropDownList.AutoPostBack = true;			
			SearchDropDownList.SelectedIndexChanged +=
				new EventHandler(SearchDropDownList_SelectedIndexChanged);

		}

		private void FillSearchDropDownList (Template jobPostingTemplate, string propName, string propValue)
		{
			SearchDropDownList.Items.Add (new ListItem ("", ""));

			propName = CriterionDropDownList.SelectedValue;
			if (propName != "")
			{
				CustomPropertyDefinition customProperty = 
					jobPostingTemplate.CustomPropertyDefinitions [propName];

				foreach (string val in customProperty.AllowedValues)
				{
					ListItem li = new ListItem (localizationManager.TranslateDisplayName(val), val);
					SearchDropDownList.Items.Add (li);
					if (propValue == val)
					{
						li.Selected = true;
					}
				}
			}
		}
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void CriterionDropDownList_SelectedIndexChanged(object sender, EventArgs e)
		{
			string propertyName = CriterionDropDownList.SelectedValue;

			Template jobPostingTemplate =
				SiteUtils.GetTemplate (SiteValues.ExternalJobPostingTemplatePath);

			SearchDropDownList.Items.Clear();
			FillSearchDropDownList (jobPostingTemplate, propertyName, "");
		}

		private void SearchDropDownList_SelectedIndexChanged(object sender, EventArgs e)
		{
			string propertyName = CriterionDropDownList.SelectedValue;
			string propertyValue = SearchDropDownList.SelectedValue;

			if (propertyName != "" && propertyValue != "")
			{
				string resultsUrl = SiteValues.ExternalJobFinderUrl
					+ "?" + SiteValues.propNameQS + "=" + propertyName
					+ "&" + SiteValues.propValueQS + "=" + propertyValue;
				Response.Redirect (resultsUrl);
			}
		}
	}
}
