namespace ContosoNet.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	using System.Resources;
	using Microsoft.ContentManagement.Publishing;

	/// <summary>
	///		Summary description for LanguageChooser.
	/// </summary>
	public class LanguageChooser : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.Literal ContosoWorldwideLiteral;
		protected System.Web.UI.WebControls.Literal ChooseLangLteral;
		protected System.Web.UI.WebControls.DropDownList LanguageDropDownList;

		private LocalizationManager localizationManager;

		private void Page_Load(object sender, System.EventArgs e)
		{
			localizationManager = new LocalizationManager();
			ContosoWorldwideLiteral.Text = localizationManager.GetString ("languageChooserControlContosoWorldwideLiteral");
			ChooseLangLteral.Text = localizationManager.GetString ("languageChooserControlChooseLangLiteral");

			if (!this.IsPostBack)
			{
				string currentLanguage = localizationManager.CurrentLanguage;

				Channel langChannel =
					SiteUtils.GetChannel (SiteValues.ExternalLanguageParentChannelPath);
				ChannelCollection langChannelCollection =
					langChannel.Channels;

				foreach (Channel c in langChannelCollection)
				{
					// Value is the channel name, such as "en-us"
					// Name is localized with resource string such as "Langen-us"
					string langVal = c.Name;
					string langName = localizationManager.GetString ("Lang" + langVal);

					ListItem li = new ListItem (langName, langVal);
					LanguageDropDownList.Items.Add (li);

					if (langVal.ToLower() == currentLanguage.ToLower())
					{
						li.Selected = true;
					}
				}
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.LanguageDropDownList.SelectedIndexChanged += new System.EventHandler(this.LanguageDropDownList_SelectedIndexChanged);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void LanguageDropDownList_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			string newLang = LanguageDropDownList.SelectedValue;
			string newUrl = SiteValues.ExternalLanguageParentUrl + "/" + newLang;

			localizationManager.SetLanguageCookie (newLang);
			Response.Redirect (newUrl);
		}
	}
}
