namespace ContosoNet.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	using Microsoft.ContentManagement.Publishing;

	/// <summary>
	///		Summary description for Navigation.
	/// </summary>
	public class Navigation : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.Repeater NavRepeater;

		private string thisChannelPath;
		private string thisPostingPath;

		private void Page_Load(object sender, System.EventArgs e)
		{
			thisChannelPath = CmsHttpContext.Current.Channel.Path;
			thisPostingPath = CmsHttpContext.Current.Posting.Path;

			Channel navChannel = 
				SiteUtils.GetChannel (SiteValues.ExternalHomeChannelPath);
			ChannelItemCollection channelItems = navChannel.AllChildren;
			channelItems.SortByOrdinal(false);

			NavRepeater.ItemDataBound +=new RepeaterItemEventHandler(NavRepeater_ItemDataBound);

			NavRepeater.DataSource = channelItems;
			NavRepeater.DataBind();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void NavRepeater_ItemDataBound(object sender, RepeaterItemEventArgs e)
		{
			ChannelItem channelItem = e.Item.DataItem as ChannelItem;
			
			if (e.Item.ItemType == ListItemType.Item ||
				e.Item.ItemType == ListItemType.AlternatingItem)
			{
				// Get controls within this repeater iteration
				HyperLink hyperLinkControl =
					e.Item.FindControl ("NavLink") as HyperLink;
				Repeater repeaterControl = e.Item.FindControl ("SubNavRepeater") as Repeater;

				// If we found them, set them up for display
				if (hyperLinkControl != null &&
					repeaterControl != null &&
					channelItem != null)

					// Fill in the hyperlink
					hyperLinkControl.NavigateUrl = channelItem.Url;
					hyperLinkControl.Text = channelItem.DisplayName;

					// Check to see if this is the "selected" link
					if (channelItem.Path == thisPostingPath ||
						channelItem.Path == thisChannelPath)
					{
						// If here, we are rendering the "selected" link.

						// If this is a channel, display the channel content as
						// a subnavigation
						Channel subChannel = channelItem as Channel;
						if (subChannel != null)
						{
							// We have children, so display "unselected" CSS class
							// since one of the children will be selected.
							hyperLinkControl.CssClass = SiteValues.cssNavigation;

							// Bind the child repeater to this channel's children
							ChannelItemCollection subChannelItems = subChannel.AllChildren;
							subChannelItems.SortByOrdinal(false);

							repeaterControl.Visible = true;
							repeaterControl.ItemDataBound +=new RepeaterItemEventHandler(SubNavRepeater_ItemDataBound);
							repeaterControl.DataSource = subChannelItems;
							repeaterControl.DataBind();
						}
						else
						{
							// This page is selected and has no children... go ahead
							// and display with the "selected" CSS class
							hyperLinkControl.CssClass = SiteValues.cssSelectedNavigation;
						}
					}
					else
					{
						// This page is not selected - set unselected CSS class
						// and hide the children
						hyperLinkControl.CssClass = SiteValues.cssNavigation;
						repeaterControl.Visible = false;
					}
			}
		}

		private void SubNavRepeater_ItemDataBound(object sender, RepeaterItemEventArgs e)
		{
			ChannelItem channelItem = e.Item.DataItem as ChannelItem;
			
			if (e.Item.ItemType == ListItemType.Item ||
				e.Item.ItemType == ListItemType.AlternatingItem)
			{
				// Get controls within this repeater iteration
				HyperLink hyperLinkControl =
					e.Item.FindControl ("SubNavLink") as HyperLink;

				// If we found them, set them up for display
				if (hyperLinkControl != null &&
					channelItem != null)
				{
					hyperLinkControl.NavigateUrl = channelItem.Url;
					hyperLinkControl.Text = channelItem.DisplayName;

					if (channelItem.Path == thisPostingPath ||
						channelItem.Path == thisChannelPath)
					{
						// This page is selected - set selected CSS class
						hyperLinkControl.CssClass = SiteValues.cssSelectedSubNavigation;
					}
					else
					{
						// This page is not selected - set unselected CSS class
						hyperLinkControl.CssClass = SiteValues.cssSubNavigation;
					}
				}
			}
		}
	}
}
