namespace ContosoNet.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	using System.Text;
	using Microsoft.ContentManagement.Publishing;
	using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;

	/// <summary>
	///		Summary description for TopPostings.
	/// </summary>
	public class TopPostings : System.Web.UI.UserControl
	{
		protected System.Web.UI.WebControls.Table ListingsTable;
		protected System.Web.UI.WebControls.Label NameLabel;
		protected System.Web.UI.WebControls.Label DateLabel;
		protected System.Web.UI.WebControls.Label SummaryLabel;

		protected LocalizationManager localizationManager;

		#region Control Properties

		// ChannelPath property - defines which channel will be listed
		private string channelPath = "";	// default value
		public string ChannelPath
		{
			get
			{
				return (channelPath);
			}
			set
			{
				channelPath = value;
			}
		}

		// ListingsToShow property - defines how many listings to show
		private int listingsToShow = 5;		// default value
		public int ListingsToShow
		{
			get
			{
				return (listingsToShow);
			}
			set
			{
				listingsToShow = value;
			}
		}

		// SummaryPlaceholderName - placeholder to render as a summary
		private string summaryPlaceholderName = "";	// default value
		public string SummaryPlaceholderName
		{
			get
			{
				return (summaryPlaceholderName);
			}
			set
			{
				summaryPlaceholderName = value;
			}
		}
		#endregion

		private void Page_Load(object sender, System.EventArgs e)
		{
			localizationManager = new LocalizationManager();

			NameLabel.Text = localizationManager.GetString ("topListingsName");
			DateLabel.Text = localizationManager.GetString ("topListingsDate");
			SummaryLabel.Text = localizationManager.GetString ("topListingsSummary");

			// Fill in top news stories
			Channel theChannel = 
				SiteUtils.GetChannel (this.channelPath);
			PostingCollection thePostings = theChannel.Postings;
			thePostings.SortByStartDate(false);		// descending order

			int postingIndex = 0;
			int linkCount = this.listingsToShow;
			if (thePostings.Count > 0)
			{
				do
				{
					Posting p = thePostings [postingIndex++];

					HtmlPlaceholder hp = p.Placeholders[summaryPlaceholderName]
						as HtmlPlaceholder;
					string placeholderHtml = "";
					if (hp != null)
					{
						placeholderHtml = SiteUtils.CleanPlaceholderHtml (hp.Html);
					}

					TableRow tr = new TableRow();
					TableCell tc;
					HyperLink link;

					tc = new TableCell ();
					link = new HyperLink ();
					link.Text = p.DisplayName;
					link.NavigateUrl = p.Url;
					tc.Controls.Add (link);
					tc.CssClass = "tableCell";
					tr.Cells.Add (tc);

					tc = new TableCell ();
					tc.Text = p.StartDate.ToShortDateString();
					tc.CssClass = "tableCell";
					tr.Cells.Add (tc);

					tc = new TableCell ();
					tc.Text = placeholderHtml;
					tc.CssClass = "tableCell";
					tr.Cells.Add (tc);

					ListingsTable.Rows.Add (tr);
				}
				while ((postingIndex<thePostings.Count) && (linkCount-- > 0));
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
