/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
/// ' Microsoft Content Management Server - Sample Code 
/// '
/// ' This sample code is provided "AS IS" with no warranties, and confers no rights. 
/// ' You assume all risk for your use. (c) 2001 Microsoft Corporation. All rights reserved.
/// '
/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

using System;
using System.Web;
using System.Web.UI.WebControls;
//Add reference for localization
using System.EnterpriseServices;
using System.Globalization;
using System.Resources;
using System.Threading;
//Add reference for navigation tree control
using Microsoft.Web.UI.WebControls;
//Add reference to the CMS API
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Web.Security;



namespace ContosoSP.Templates
{
	/// <summary>
	/// Summary description for RootHome page.
	/// This is the home page.It contains links to other RootHome sites.
	/// </summary>
	
	public class RootHome : System.Web.UI.Page
	{
		protected Table tablePressRelease;
		protected System.Web.UI.WebControls.Literal LTMcmsNews;
		protected System.Web.UI.WebControls.Literal LTCommunityWebPage;
		protected System.Web.UI.WebControls.Literal LTDownloads;
		protected System.Web.UI.WebControls.Literal LTWhitePapers;
		protected System.Web.UI.WebControls.Literal LTKBArticles;
		protected System.Web.UI.WebControls.Literal LTMSPress;
		protected System.Web.UI.WebControls.Literal LTGotDotNet;
		protected System.Web.UI.WebControls.Literal LeftNav;
		protected System.Web.UI.WebControls.LinkButton BTRootHome;
		protected System.Web.UI.WebControls.LinkButton BTNetEnterpriseServer;
		private Channel CurrentStartChannel=null;
		protected Microsoft.ContentManagement.WebControls.ConsoleControls.Console Console1;
		protected System.Web.UI.WebControls.LinkButton BTMcmsHomeport;
		
		
		//Instantiate Resource Manager for Localization
		protected ResourceManager LocalizationResourceManager;
				

		#region Page Load
		private void Page_Load(object sender, System.EventArgs e)
		{		
			//Get the resources from the resource files
			//and assign the values to the literal controls			

			LTMcmsNews.Text = LocalizationResourceManager.GetString("LTMcmsNews");
			LTCommunityWebPage.Text = LocalizationResourceManager.GetString("LTCommunityWebPage");
			LTDownloads.Text = LocalizationResourceManager.GetString("LTDownloads");
			LTWhitePapers.Text = LocalizationResourceManager.GetString("LTWhitePapers");

			CmsHttpContext cmsContext = CmsHttpContext.Current;
			ChannelCollection colRootChannels;
			colRootChannels=cmsContext.RootChannel.Channels;
			CurrentStartChannel = cmsContext.Channel;
			
			LeftNav.Text = "";

			if(CurrentStartChannel.AllChildren!= null && CurrentStartChannel.AllChildren.Count>0)
			{
				int i = 0;
				foreach(Channel subChannel in CurrentStartChannel.Channels)
				{
					LeftNav.Text = LeftNav.Text + "<table class=\"menuBar\" id=\"menu" + i.ToString() +"\" onmouseout=\"if (document.readyState=='complete') if (!(menu" + i.ToString() + ").contains(window.event.toElement) ) {rolloff(this);cancelDelay();}\" onmouseover=\"if (document.readyState=='complete') {rollon(this); delayRemove();}\" style=\"WIDTH: 201px; HEIGHT: 19px\" cellSpacing=\"0\" cellPadding=\"0\" width=\"201\" border=\"0\"><tbody><tr><td width=\"17\"><IMG height=\"1\" src=\"/MCMS/RootHome/Images/Trans.gif\" width=\"17\" border=\"0\"></td><td class=\"menuBarFont\" align=\"left\" width=\"100%\"><a href=" + subChannel.Url + ">" + subChannel.DisplayName + "</a></td></tr></tbody></table>\n";
					i++;
				}

				// add the following code to display Postings as well as Channels
/*
				foreach(Posting posting in CurrentStartChannel.Postings)
				{
					LeftNav.Text = LeftNav.Text + "<table class=\"menuBar\" id=\"menu" + i.ToString() +"\" onmouseout=\"if (document.readyState=='complete') if (!(menu" + i.ToString() + ").contains(window.event.toElement) ) {rolloff(this);cancelDelay();}\" onmouseover=\"if (document.readyState=='complete') {rollon(this); delayRemove();}\" style=\"WIDTH: 201px; HEIGHT: 19px\" cellSpacing=\"0\" cellPadding=\"0\" width=\"201\" border=\"0\"><tbody><tr><td width=\"17\"><IMG height=\"1\" src=\"/MCMS/RootHome/Images/Trans.gif\" width=\"17\" border=\"0\"></td><td class=\"menuBarFont\" align=\"left\" width=\"100%\"><a href=" + posting.Url + ">" + posting.DisplayName + "</a></td></tr></tbody></table>\n";
					i++;
				}				
*/
			}
		
		} //Close Page_Load
		#endregion Page Load

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
			LocalizationResourceManager = (ResourceManager) Application["RootHomeResourceManager"];
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.ID = "RootHome";
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
