/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
/// ' Microsoft Content Management Server - Sample Code 
/// '
/// ' This sample code is provided "AS IS" with no warranties, and confers no rights. 
/// ' You assume all risk for your use.  2001 Microsoft Corporation. All rights reserved.
/// '
/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

namespace ContosoSP.UserControls
{
	using System;
	using System.Web;
	//Add reference for localization
	using System.EnterpriseServices;
	using System.Globalization;
	using System.Resources;
	using System.Threading;
	
	//Add reference to CMS API
	using Microsoft.ContentManagement.Publishing;
	
	/// <summary>
	///		Summary description for headTags.
	/// </summary>
	public abstract class HeadTags : System.Web.UI.UserControl
	{
		protected Microsoft.ContentManagement.WebControls.RobotMetaTag RobotMetaTag1;
		protected System.Web.UI.WebControls.Literal LTHeadTagsTitle;
		
		//Resource Manager for localization
		protected ResourceManager LocalizationResourceManager;

		public string GetPageTitle()
		{
			//Output the page display name
			string PageDisplayName;
			PageDisplayName = Server.HtmlEncode(Microsoft.ContentManagement.Publishing.CmsHttpContext.Current.Posting.DisplayName);
			return(PageDisplayName);
		}
		
		private void Page_Load(object sender, System.EventArgs e)
		{
			//Picking Up literal from resource file
			LTHeadTagsTitle.Text = LocalizationResourceManager.GetString("HeadTagsTitle");	
		}
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
			LocalizationResourceManager = (ResourceManager) Application["ContosoSPResourceManager"];
		}
		
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
