namespace ContosoSP.UserControls
{
	using System;
	using System.Data;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;
	using Microsoft.ContentManagement.Publishing;
	using Microsoft.ContentManagement.Web.Caching;
	using Microsoft.ContentManagement.WebControls;

	/// <summary>
	///		Summary description for PostingDescription.
	/// </summary>
	public abstract class PostingDescription : System.Web.UI.UserControl
	{
		protected System.Web.UI.HtmlControls.HtmlTextArea internalDescription;

		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			CmsHttpContext currentContext = CmsHttpContext.Current;
			if (!Page.IsPostBack) 
			{
				internalDescription.InnerHtml = currentContext.Posting.Description;
			}
			internalDescription.Disabled = !(WebAuthorContext.Current.Mode == WebAuthorContextMode.AuthoringNew || WebAuthorContext.Current.Mode == WebAuthorContextMode.AuthoringReedit);
		}

		private void saveDescription(object sender, WebAuthorPostingEventArgs e) 
		{
			e.Posting.Description = internalDescription.InnerHtml;
		}
		
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
			WebAuthorContext.Current.SavePostingEvent += new WebAuthorPostingEventHandler(saveDescription);
		}
		
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
