/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
/// ' Microsoft Content Management Server - Sample Code 
/// '
/// ' This sample code is provided "AS IS" with no warranties, and confers no rights. 
/// ' You assume all risk for your use. (c) 2001 Microsoft Corporation. All rights reserved.
/// '
/// ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

namespace ContosoSP
{
	using System;
	using System.Web;
	//Add reference for localization
	using System.EnterpriseServices;
	using System.Globalization;
	using System.Resources;
	using System.Threading;
	
	/// <summary>
	/// 
	///		Summary description for Footer.
	///		Adds the appropriate footer information to the site.
	/// </summary>
	public abstract class RootFooter : System.Web.UI.UserControl
	{
		//Literal controls used for localization		

		protected System.Web.UI.WebControls.Literal LTFooterContactUs;
		protected System.Web.UI.WebControls.Literal LTFooterEmail;
		protected System.Web.UI.WebControls.Literal LTFooterCopyRight;
		protected System.Web.UI.WebControls.Literal LTFooterPrivacyStatement;
		protected System.Web.UI.WebControls.Literal LTFooterAccessibility;
		
		//Instantiate Resource Manager for Localization
		protected ResourceManager LocalizationResourceManager;

		private void Page_Load(object sender, System.EventArgs e)
		{
			//Get the resources from the resource files
			//and assign the values to the literal controls
			
			LTFooterContactUs.Text = LocalizationResourceManager.GetString("ContactUs");
			LTFooterEmail.Text = LocalizationResourceManager.GetString("Email");
			LTFooterCopyRight.Text = LocalizationResourceManager.GetString("CopyRight");
			LTFooterPrivacyStatement.Text = LocalizationResourceManager.GetString("PrivacyStatement");
			LTFooterAccessibility.Text = LocalizationResourceManager.GetString("Accessibility");
			
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
			LocalizationResourceManager = (ResourceManager) Application["RootHomeResourceManager"];
		}
		
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
