--Demo 1 

--Subquery
SELECT Salespeople.Salesperson, 100 * 
 (SELECT COUNT(*) FROM Sales
  WHERE Sales.Sales_ID = Salespeople.Sales_ID) /
 (SELECT COUNT(*) FROM Sales) AS PercentSales
FROM Salespeople

--The Rozenshtein Method
SELECT Salespeople.Salesperson, SUM(Sales.Quantity*Sales.Price) AS Total, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-1)))) AS Jan, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-2)))) AS Feb, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-3)))) AS Mar, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-4)))) AS Apr, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-5)))) AS May, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-6)))) AS Jun, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-7)))) AS Jul, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-8)))) AS Aug, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-9)))) AS Sep, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-10)))) AS Oct, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-11)))) AS Nov, 
  SUM(Sales.Quantity*Sales.Price*(1-ABS(SIGN(DatePart(mm,Sales.Invoice_Date)-12)))) AS Dec
FROM Sales INNER JOIN Salespeople ON Sales.Sales_ID = Salespeople.Sales_ID
GROUP BY Salespeople.Salesperson;

--CASE
SELECT Salespeople.Salesperson, SUM(Sales.Quantity*Sales.Price) AS Total, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 1 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS Jan, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 2 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS Feb, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 3 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS Mar, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 4 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS Apr, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 5 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS May, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 6 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS Jun, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 7 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS Jul, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 8 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS Aug, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 9 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS Sep, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 10 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS Oct, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 11 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS Nov, 
  SUM(CASE DATEPART(mm, Sales.Invoice_Date) WHEN 12 THEN Sales.Quantity*Sales.Price ELSE 0 END) AS Dec
FROM Sales INNER JOIN Salespeople ON Sales.Sales_ID = Salespeople.Sales_ID
GROUP BY Salespeople.Salesperson

--Self Joins
SELECT s1.Salesperson AS Person,
 s2.Salesperson AS ReportsTo
FROM Salespeople AS s1 INNER JOIN Salespeople AS s2
 ON s1.ReportsTo_ID = s2.Sales_ID

SELECT s1.Salesperson, s2.Salesperson
FROM Salespeople AS s1 INNER JOIN Salespeople AS s2
 ON s1.Salesperson > s2.Salesperson

SELECT p1.Product_Name, p1.Price, count(*)
FROM Products AS p1, Products AS p2
WHERE p1.Price >= p2.Price 
GROUP BY p1.Product_Name, p1.Price
HAVING COUNT(*) = 3