---------------------------------------
use master 

IF EXISTS (SELECT * 
	   FROM   master..sysdatabases 
	   WHERE  name = N'Fortissimo')
	DROP DATABASE Fortissimo
GO

CREATE DATABASE Fortissimo
ON PRIMARY
	( NAME = ForteFileGroup1,
	  FILENAME = N'c:\program files\microsoft sql server\mssql\data\ForteDB1.mdf',
          SIZE = 1MB,
          MAXSIZE = 200MB,
          FILEGROWTH = 10%),
	
FILEGROUP ForteFileGroup2
	( NAME = ForteFileGroup2,
	  FILENAME = N'c:\program files\microsoft sql server\mssql\data\ForteDB2.ndf',
          SIZE = 1MB,
          MAXSIZE = 200MB,
          FILEGROWTH = 10%),

FILEGROUP ForteIndexGroup
	( NAME = ForteIndexGroup,
	  FILENAME = N'c:\program files\microsoft sql server\mssql\data\ForteIndex.ndf',
          SIZE = 1MB,
          MAXSIZE = 200MB,
          FILEGROWTH = 10%)
	
LOG ON
	( NAME = ForteLogFile,
	  FILENAME = N'c:\program files\microsoft sql server\mssql\data\ForteLog1.ldf',
          SIZE = 1MB,
          MAXSIZE = 200MB,
          FILEGROWTH = 10%)
GO

USE Fortissimo
GO

IF EXISTS (SELECT name 
	   FROM   sysobjects 
	   WHERE  name = N'EVCCRoutes' 
	   AND 	  type = 'U')
    DROP TABLE EVCCRoutes
GO

CREATE TABLE EVCCRoutes (
RouteID int IDENTITY(1,1) NOT NULL,
RouteName varchar(40) NOT NULL
)
ON ForteFileGroup2
GO

CREATE UNIQUE CLUSTERED INDEX udxEVCCRountes ON EVCCRoutes ( RouteName ) ON ForteIndexGroup

SET NOCOUNT ON

INSERT EVCCRoutes ( RouteName ) VALUES ('Everest' ) INSERT EVCCRoutes ( RouteName ) VALUES ('K2' ) INSERT EVCCRoutes ( RouteName ) VALUES ('Kili' ) INSERT EVCCRoutes ( RouteName ) VALUES ('Orange Card Overhang' )

-- there can be only one turtle
INSERT EVCCRoutes ( RouteName ) VALUES ('Turtle' )

SELECT * FROM EVCCRoutes

GO
